//=============================================================================
// RestoreMenuAfterCommon.js
//=============================================================================

/*:
 * @plugindesc Back to the same menu scene after common events caused by items.
 * @author terunon (AliasAche)
 *
 * @help
 * j[ŃRCxgĂԃACegpăj[ꂽƂA
 * ̉ʂɖ߂񋟂܂B
 * Ē`sĂ̂ŏ̕ɔzuĂB
 *
 * ΏۃRCxg̖ɃXNvgFthis.sceneRestore()Ɠ邱ƂŎgpł܂B
 *
 * NWbgƂāAuterunoniGCAXGCNjv̑fނgp|
 * ReadMe܂̓uEU̎FłꏊɋLڂĂ΁A
 * cc킸AcN[MViŎgpEς܂B
 *
 * Copyright (c) 2016 terunon (AliasAche)
 * You can use and modify it for every your commercial/non-commercial RPG Maker MV game
 * if you credit "terunon (AliasAche)"
 */

//Global variables
    var aliasAcheCommon = false;
    var aliasAcheSelectRestore = false;

(function() {

Scene_Item.prototype.popScene = function() {
    if (aliasAcheCommon){
        aliasAcheCommon = false;
        aliasAcheSelectRestore = false;
        SceneManager.goto(Scene_Menu);
    }else{
    SceneManager.pop();
    }
};

Game_Interpreter.prototype.sceneRestore = function(){
    if (!$gameParty.inBattle()){
           aliasAcheCommon = true;
           aliasAcheSelectRestore = true;
	   SceneManager.push(Scene_Item);
    }
};

Scene_Item.prototype.update = function() {
    if (aliasAcheSelectRestore) {
       aliasAcheSelectRestore = false;
       this.onCategoryOk();
       this._categoryWindow.deactivate();
       if ($gameParty.numItems($gameParty.lastItem()) > 0){
          this.onItemOk();
          this._itemWindow.deactivate();
       }
    }
    Scene_Base.prototype.update.call(this);
};

})();
