#ifndef ODOMAIN_H__
#define ODOMAIN_H__

enum
{
// Simulation
  DOMAIN_SIMULATION                         = 10000,
  DOMAIN_LINKED_NODES                       = 10002,
  
// Particles
  DOMAIN_PARTICLES                          = 10003,
  DOMAIN_PARTICLES_TYPE                     = 10004,
  DOMAIN_PARTICLES_TYPE_DUMB                = 10005,
  DOMAIN_PARTICLES_TYPE_LIQUID              = 10006,
  DOMAIN_PARTICLES_TYPE_LIQUIDPBF           = 10007,
  
  DOMAIN_PARTICLES_RESOLUTION               = 10008,
  DOMAIN_PARTICLES_DENSITY                  = 10009,
  DOMAIN_USE_INITIAL_STATE                  = 10010,
  DOMAIN_CREATE_INITIAL_STATE               = 10011,


  
// Solver Liquid
  DOMAIN_SOLVER_LIQUID                      = 10012,
  DOMAIN_SOLVER_LIQUID_INT_PRESSURE         = 10013,
  DOMAIN_SOLVER_LIQUID_EXT_PRESSURE         = 10014,
  DOMAIN_SOLVER_LIQUID_VISCOSITY            = 10015,
  DOMAIN_SOLVER_LIQUID_SURFACE_TENSION      = 10016,
  
// Solver Liquid PBF
 // DOMAIN_SOLVER_LIQUID_PBF                  = 10015,
 // DOMAIN_SOLVER_LIQUID_PBF_INT_PRESSURE     = 10016,
 // DOMAIN_SOLVER_LIQUID_PBF_EXT_PRESSURE     = 10017,
 // DOMAIN_SOLVER_LIQUID_PBF_VISCOSITY        = 10018,
 // DOMAIN_SOLVER_LIQUID_PBF_SURFACE_TENSION  = 10019,

  
  
// Display
  DOMAIN_DISPLAY                            = 10017,
  DOMAIN_VISIBLE                            = 10018,
  DOMAIN_DETAIL                             = 10022,
  DOMAIN_DETAIL_BEST                        = 10023,
  DOMAIN_DETAIL_MEDIUM                      = 10024,
  DOMAIN_DETAIL_LOW                         = 10025,
  DOMAIN_DISPLAY_TYPE                       = 10026,
  DOMAIN_DISPLAY_TYPE_POINT                 = 10027,
  DOMAIN_DISPLAY_TYPE_SPHERE                = 10028,
  DOMAIN_DISPLAY_TYPE_TRAIL                 = 10029,
  DOMAIN_DISPLAY_TYPE_OBJECT                = 10030,
  DOMAIN_DISPLAY_TYPE_OBJECT_SELECTED       = 10031,
  DOMAIN_SIZE,
  DOMAIN_SIZE_VAR,
  DOMAIN_PROPERTY,
  DOMAIN_PROPERTY_VELOCITY,
  DOMAIN_PROPERTY_VELOCITY_X,
  DOMAIN_PROPERTY_VELOCITY_Y,
  DOMAIN_PROPERTY_VELOCITY_Z,
  DOMAIN_COLOR,
  DOMAIN_PERCENTAGE,
  DOMAIN_PERCENTAGE_VAR,
  DOMAIN_AUTOMATIC_RANGE,
  DOMAIN_RANGE_MIN,
  DOMAIN_RANGE_MAX,
  
  DOMAIN_HUD,
  DOMAIN_HUD_SHOW,
  DOMAIN_HUD_X,
  DOMAIN_HUD_Y,
  
// Export
  // DOMAIN_EXPORT,
  // DOMAIN_EXPORT_FORMAT,
  // DOMAIN_EXPORT_FORMAT_RPC,
  // DOMAIN_EXPORT_FORMAT_ABC,
  // DOMAIN_EXPORT_FOLDER,
  
  DOMAIN_RENDERING,
  
// Debug
  DOMAIN_DEBUG                              ,
  DOMAIN_DEBUG_SHOW_GEOMETRY                ,
  DOMAIN_SPLINE                             ,
  
  DOMAIN_PARTICLES_VIS_GROUP                     = 10100,
  DOMAIN_PARTICLES_VIS_CHILD_OBJECTS              = 10101,
  DOMAIN_PARTICLES_VIS_CHILD_OBJECTS_RENDER_ONLY  = 10102,
  DOMAIN_PARTICLES_VIS_CREATE_TP                 = 10103,

  DOMAIN_HELP_SIMULATION,
  DOMAIN_HELP_FLUID,
  DOMAIN_HELP_PARTICLE,
  DOMAIN_HELP_DISPLAY,
  
  DOMAIN_SCENE_LINK,

  DOMAIN_PARTICLES_VIS_GROUP_TP
};

#endif
