/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.awt.geom.Point2D;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class Point2DObjectDescription
extends AbstractObjectDescription {
    public Point2DObjectDescription() {
        super(Point2D.class);
        this.setParameterDefinition("x", Float.class);
        this.setParameterDefinition("y", Float.class);
    }

    public Object createObject() {
        Point2D.Float point = new Point2D.Float();
        float x = this.getFloatParameter("x");
        float y = this.getFloatParameter("y");
        ((Point2D)point).setLocation(x, y);
        return point;
    }

    private float getFloatParameter(String param) {
        Float p = (Float)this.getParameter(param);
        if (p == null) {
            return 0.0f;
        }
        return p.floatValue();
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof Point2D)) {
            throw new ObjectFactoryException("The given object is no java.awt.geom.Point2D.");
        }
        Point2D point = (Point2D)o;
        float x = (float)point.getX();
        float y = (float)point.getY();
        this.setParameter("x", new Float(x));
        this.setParameter("y", new Float(y));
    }
}

