/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace.typeblocking;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Page;
import edu.mit.blocks.workspace.PageChangeEventManager;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.typeblocking.LinkFinderUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class BlockDropAnimator
implements ActionListener {
    private final Workspace workspace;
    private final RenderableBlock childBlock;
    private final RenderableBlock parentBlock;
    private final Point focusPoint;
    private final Timer timer;

    public BlockDropAnimator(Workspace workspace, Point focusPoint, RenderableBlock childBlock, RenderableBlock parentBlock) {
        this.workspace = workspace;
        this.childBlock = childBlock;
        this.parentBlock = parentBlock;
        this.focusPoint = focusPoint;
        this.timer = new Timer(25, this);
        if (childBlock == null || childBlock.getBlockID() == Block.NULL) {
            throw new RuntimeException("may not drop a null block");
        }
        this.timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.childBlock.getLocation().distance(this.focusPoint) < 75.0) {
            this.childBlock.setLocation(this.focusPoint);
            if (this.parentBlock != null && this.parentBlock.getBlockID() != null && !this.parentBlock.getBlockID().equals(Block.NULL)) {
                BlockLink link = LinkFinderUtil.connectBlocks(this.workspace, this.workspace.getEnv().getBlock(this.childBlock.getBlockID()), this.workspace.getEnv().getBlock(this.parentBlock.getBlockID()));
                if (link == null) {
                    BlockDropAnimator.dropBlock(this.childBlock);
                    this.childBlock.repaintBlock();
                    this.childBlock.repaint();
                } else {
                    link.connect();
                    BlockDropAnimator.dropBlock(this.childBlock);
                    this.workspace.notifyListeners(new WorkspaceEvent(this.workspace, this.workspace.getEnv().getRenderableBlock(link.getPlugBlockID()).getParentWidget(), link, 5));
                    this.workspace.getEnv().getRenderableBlock(link.getSocketBlockID()).moveConnectedBlocks();
                    this.workspace.getEnv().getRenderableBlock(link.getSocketBlockID()).repaintBlock();
                    this.workspace.getEnv().getRenderableBlock(link.getSocketBlockID()).repaint();
                }
            } else {
                BlockDropAnimator.dropBlock(this.childBlock);
                this.childBlock.repaintBlock();
                this.childBlock.repaint();
            }
            this.timer.stop();
            if (this.workspace.getEnv().getBlock(this.childBlock.getBlockID()).getGenusName().equals("number")) {
                this.childBlock.switchToLabelEditingMode(false);
            } else {
                this.childBlock.switchToLabelEditingMode(true);
            }
            PageChangeEventManager.notifyListeners();
        } else {
            this.childBlock.setLocation((int)(this.focusPoint.getX() * 0.67) + (int)((double)this.childBlock.getX() * 0.34), (int)(this.focusPoint.getY() * 0.67) + (int)((double)this.childBlock.getY() * 0.34));
        }
    }

    private static void dropBlock(RenderableBlock block) {
        if (block == null) {
            throw new RuntimeException("Invariant Violated: child block was null");
        }
        Workspace workspace = block.getWorkspace();
        Page p = workspace.getCurrentPage(block);
        if (p == null) {
            throw new RuntimeException("Invariant Violated: child block was located on a null widget");
        }
        p.blockDropped(block);
    }
}

