/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CBorderlessButton;
import edu.mit.blocks.codeblockutil.CHoverScrollPane;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.Explorer;
import edu.mit.blocks.codeblockutil.ExplorerListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class WindowExplorer
extends JPanel
implements Explorer {
    private static final long serialVersionUID = 328149080308L;
    private static final int buttonHeight = 13;
    private List<JComponent> canvases;
    private JPanel canvasPane;
    private JPanel buttonPane;

    public WindowExplorer() {
        this.setLayout(new BorderLayout());
        this.canvases = new ArrayList<JComponent>();
        this.canvasPane = new JPanel(new BorderLayout());
        this.buttonPane = new JPanel();
        this.buttonPane.setBorder(BorderFactory.createMatteBorder(3, 0, 0, 0, new Color(0, 150, 240)));
        this.buttonPane.setBackground(Color.black);
        this.add((Component)this.canvasPane, "Center");
        this.buttonPane.setLayout(new GridLayout(0, 2, 10, 5));
        this.add((Component)this.buttonPane, "South");
    }

    @Override
    public boolean anyCanvasSelected() {
        return false;
    }

    @Override
    public int getSelectedCanvasWidth() {
        return this.canvasPane.getWidth();
    }

    @Override
    public void addListener(ExplorerListener gel) {
    }

    @Override
    public void removeListener(ExplorerListener gel) {
    }

    @Override
    public void setDrawersCard(List<? extends Canvas> items) {
        this.canvases.clear();
        this.buttonPane.removeAll();
        int size = items.size();
        if (size % 2 == 1) {
            ++size;
        }
        this.buttonPane.setPreferredSize(new Dimension(6, size *= 13));
        int i = 0;
        while (i < items.size()) {
            final int index = i;
            Canvas item = items.get(i);
            CBorderlessButton button = new CBorderlessButton(item.getName());
            CHoverScrollPane scroll = new CHoverScrollPane(item.getJComponent(), CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_AS_NEEDED, 18, item.getColor(), Color.darkGray);
            this.canvases.add(scroll);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowExplorer.this.selectCanvas(index);
                }
            });
            this.buttonPane.add(button);
            ++i;
        }
        if (!this.canvases.isEmpty()) {
            this.canvasPane.add(this.canvases.get(0));
        }
        this.revalidate();
    }

    @Override
    public void selectCanvas(int index) {
        if (index >= 0 && index < this.canvases.size()) {
            JComponent scroll = this.canvases.get(index);
            this.canvasPane.removeAll();
            this.canvasPane.add(scroll);
            this.canvasPane.revalidate();
            this.canvasPane.repaint();
        }
    }

    @Override
    public void reformView() {
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }
}

