/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.Explorer;
import edu.mit.blocks.codeblockutil.ExplorerListener;
import edu.mit.blocks.codeblockutil.GlassCard;
import edu.mit.blocks.codeblockutil.GlassExplorerEvent;
import edu.mit.blocks.workspace.Page;
import edu.mit.blocks.workspace.Workspace;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GlassExplorer
extends JPanel
implements Explorer,
FocusListener {
    private static final long serialVersionUID = 328149080292L;
    protected JPanel buttonPane;
    private CanvasPane canvasPane;
    private EnlargerTimer timer;
    private List<GlassCard> drawers;
    private JPanel retardedPane;
    private int selectedCanvasIndex;
    private static final int DEFAULT_INDEX = 1000;
    private static final int SELECTED_CANVAS_WIDTH = 225;
    private List<ExplorerListener> listeners;
    private final Workspace workspace;
    private int canvasHeight = 0;

    public GlassExplorer(Workspace workspace) {
        super(new BorderLayout());
        this.workspace = workspace;
        this.selectedCanvasIndex = 1000;
        this.drawers = new ArrayList<GlassCard>();
        this.setOpaque(true);
        this.setBackground(Color.black);
        this.timer = new EnlargerTimer();
        this.listeners = new ArrayList<ExplorerListener>();
        this.retardedPane = new JPanel();
        this.retardedPane.setBackground(Page.backgroundColor);
        this.buttonPane = new JPanel();
        this.buttonPane.setBackground(Page.backgroundColor);
        this.buttonPane.setLayout(new GridLayout(0, 1));
        this.canvasPane = new CanvasPane();
        this.canvasPane.setOpaque(false);
        workspace.add((Component)this.canvasPane, Workspace.WIDGET_LAYER);
        workspace.revalidate();
        this.add((Component)this.buttonPane, "Center");
        this.add((Component)this.retardedPane, "South");
        this.revalidate();
        this.addFocusListener(this);
    }

    @Override
    public int getSelectedCanvasWidth() {
        return this.canvasPane.getFinalWidth();
    }

    @Override
    public boolean anyCanvasSelected() {
        return this.canvasPane.getWidth() == this.canvasPane.getFinalWidth();
    }

    @Override
    public void addListener(ExplorerListener gel) {
        this.listeners.add(gel);
    }

    @Override
    public void removeListener(ExplorerListener gel) {
        if (this.listeners.contains(gel)) {
            this.listeners.remove(gel);
        }
    }

    private void notifyListeners(int event) {
        GlassExplorerEvent ge = new GlassExplorerEvent(this, event);
        for (ExplorerListener l : this.listeners) {
            l.explorerEventOccurred(ge);
        }
    }

    @Override
    public void setDrawersCard(List<? extends Canvas> items) {
        this.drawers.clear();
        this.buttonPane.removeAll();
        int i = 0;
        while (i < items.size()) {
            GlassCard card = new GlassCard(i, items.get(i), this);
            this.drawers.add(card);
            this.buttonPane.add(card.getButton());
            ++i;
        }
    }

    @Override
    public void selectCanvas(int index) {
        if (!(this.timer.timer.isRunning() && this.selectedCanvasIndex == index || index < 0 || index >= this.drawers.size())) {
            this.selectedCanvasIndex = index;
            GlassCard card = this.drawers.get(index);
            this.canvasPane.removeAll();
            this.canvasPane.add(card.getScroll());
            this.canvasPane.setBackground(card.getBackgorundColor());
            this.timer.expand();
            this.canvasPane.setBounds(this.buttonPane.getWidth(), this.buttonPane.getY(), 0, 0);
            this.requestFocus();
        }
    }

    @Override
    public void reformView() {
        this.canvasHeight = this.getHeight();
        this.canvasPane.setSize(0, this.getHeight());
        if (this.getHeight() < this.drawers.size() * 25) {
            this.retardedPane.setPreferredSize(new Dimension(0, 0));
        } else {
            this.retardedPane.setPreferredSize(new Dimension(0, this.getHeight() - this.drawers.size() * 25));
        }
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.timer.shrink();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    private class CanvasPane
    extends JPanel {
        private static final long serialVersionUID = 328149080293L;
        private int finalWidth = 20;
        private JPanel extraPanel;
        private Insets insets = new Insets(15, 5, 35, 3);

        public CanvasPane() {
            if (this.extraPanel == null) {
                this.extraPanel = new JPanel();
                this.extraPanel.setLayout(new BorderLayout());
                this.extraPanel.setBackground(new Color(0, 0, 0, 0));
                this.extraPanel.setOpaque(false);
                super.add(this.extraPanel);
            }
        }

        public int getFinalWidth() {
            return this.finalWidth;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(this.getBackground());
            g.fillRoundRect(-10, 10, w + 9, h - 40, 20, 20);
            g2.setStroke(new BasicStroke(1.0f));
            g.setColor(new Color(0, 0, 0, 100));
            g.drawRoundRect(-10, 10, w + 8, h - 41, 20, 20);
            g.setColor(this.getBackground());
            g.drawLine(-10, 10, w - 11, 10);
            g.setColor(new Color(255, 255, 255, 80));
            g.drawLine(-10, 10, w - 11, 10);
            g2.setStroke(new BasicStroke(1.0f));
            this.extraPanel.setLocation(w - this.finalWidth + this.insets.left, this.insets.top);
            super.paint(g);
        }

        @Override
        public Component add(Component comp) {
            if (comp.getPreferredSize().width != this.extraPanel.getWidth()) {
                this.finalWidth = comp.getPreferredSize().width + this.insets.right + this.insets.left;
                this.extraPanel.setSize(comp.getPreferredSize().width, this.getHeight() - this.insets.top - this.insets.bottom);
                this.extraPanel.setMaximumSize(new Dimension(comp.getPreferredSize().width, this.extraPanel.getHeight()));
                this.extraPanel.setMinimumSize(new Dimension(comp.getPreferredSize().width, this.extraPanel.getHeight()));
                this.extraPanel.setPreferredSize(new Dimension(comp.getPreferredSize().width, this.extraPanel.getHeight()));
            }
            return this.extraPanel.add(comp);
        }

        @Override
        public void remove(Component comp) {
            if (this.extraPanel != null && !comp.equals(this.extraPanel)) {
                this.extraPanel.remove(comp);
            }
        }

        @Override
        public void removeAll() {
            if (this.extraPanel != null) {
                this.extraPanel.removeAll();
            }
        }
    }

    private class EnlargerTimer
    implements ActionListener {
        private Timer timer = new Timer(50, this);
        private boolean expand = true;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.expand) {
                if (GlassExplorer.this.canvasPane.getWidth() < GlassExplorer.this.canvasPane.getFinalWidth()) {
                    GlassExplorer.this.canvasPane.setSize(GlassExplorer.this.canvasPane.getWidth() + (GlassExplorer.this.canvasPane.getFinalWidth() - GlassExplorer.this.canvasPane.getWidth()) / 3 + 1, GlassExplorer.this.canvasHeight);
                    GlassExplorer.this.canvasPane.revalidate();
                    GlassExplorer.this.canvasPane.repaint();
                } else {
                    this.timer.stop();
                    GlassExplorer.this.notifyListeners(1);
                    GlassExplorer.this.canvasPane.setSize(GlassExplorer.this.canvasPane.getFinalWidth(), GlassExplorer.this.canvasHeight);
                    GlassExplorer.this.canvasPane.revalidate();
                    GlassExplorer.this.canvasPane.repaint();
                }
            } else if (GlassExplorer.this.canvasPane.getWidth() > 3) {
                GlassExplorer.this.canvasPane.setSize(GlassExplorer.this.canvasPane.getWidth() / 3, GlassExplorer.this.canvasHeight);
                GlassExplorer.this.canvasPane.revalidate();
                GlassExplorer.this.canvasPane.repaint();
            } else {
                this.timer.stop();
                GlassExplorer.this.notifyListeners(2);
                GlassExplorer.this.canvasPane.setSize(0, GlassExplorer.this.canvasHeight);
                GlassExplorer.this.canvasPane.revalidate();
                GlassExplorer.this.canvasPane.repaint();
            }
        }

        public void expand() {
            this.expand = true;
            this.timer.start();
        }

        public void shrink() {
            this.expand = false;
            this.timer.start();
        }
    }
}

