/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CSlider;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CSliderPane
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 328149080253L;
    public static final String VALUE_CHANGED = "VALUE_CHANGED";
    private static float ratio = 1000.0f;
    private static int margin = 10;
    private static int header = 20;
    private CSlider slider;
    private JTextField valueLabel;
    private JTextField leftLabel;
    private JTextField rightLabel;

    public CSliderPane(float min, float max, float value) {
        super(null);
        this.setOpaque(false);
        this.slider = new CSlider((int)(min * ratio), (int)(max * ratio), (int)(value * ratio));
        this.slider.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                CSliderPane.this.sliderValueChanged(e);
            }
        });
        this.valueLabel = new CNumberTextField(this, String.valueOf(value)){
            private static final long serialVersionUID = 328149080254L;

            @Override
            public void evaluateTextFieldData() {
                try {
                    int newvalue = Math.round(Float.parseFloat(this.getText()) * ratio);
                    slider.setValue(newvalue);
                    this.notifyValueChanged();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.valueLabel.setHorizontalAlignment(11);
        this.leftLabel = new CNumberTextField(this, String.valueOf(min)){
            private static final long serialVersionUID = 328149080256L;

            @Override
            public void evaluateTextFieldData() {
                try {
                    int newvalue = Math.round(Float.parseFloat(this.getText()) * ratio);
                    slider.setLeft(newvalue);
                    this.notifyValueChanged();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.leftLabel.setHorizontalAlignment(10);
        this.rightLabel = new CNumberTextField(this, String.valueOf(max)){
            private static final long serialVersionUID = 328149080255L;

            @Override
            public void evaluateTextFieldData() {
                try {
                    int newvalue = Math.round(Float.parseFloat(this.getText()) * ratio);
                    slider.setRight(newvalue);
                    this.notifyValueChanged();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.rightLabel.setHorizontalAlignment(11);
        this.add(this.valueLabel);
        this.add(this.leftLabel);
        this.add(this.rightLabel);
        this.add(this.slider);
        this.addComponentListener(this);
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CSliderPane.this.notifyValueChanged();
            }
        });
        this.slider.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                CSliderPane.this.notifyValueChanged();
            }
        });
    }

    public float getMinimum() {
        float rawMin = Math.min(this.slider.getLeft(), this.slider.getRight());
        return rawMin / ratio;
    }

    public float getMaximum() {
        float rawMax = Math.max(this.slider.getLeft(), this.slider.getRight());
        return rawMax / ratio;
    }

    public float getValue() {
        return (float)this.slider.getValue() / ratio;
    }

    public void setMinimum(float min) {
        if (this.slider.getLeft() < this.slider.getRight()) {
            this.slider.setLeft((int)(min * ratio));
        } else {
            this.slider.setRight((int)(min * ratio));
        }
    }

    public void setMaximum(float max) {
        if (this.slider.getLeft() > this.slider.getRight()) {
            this.slider.setLeft((int)(max * ratio));
        } else {
            this.slider.setRight((int)(max * ratio));
        }
    }

    public void setValue(float value) {
        this.slider.setValue((int)(value * ratio));
        this.valueLabel.setText(String.valueOf((float)this.slider.getValue() / ratio));
    }

    private void notifyValueChanged() {
        this.valueLabel.setText(String.valueOf((float)this.slider.getValue() / ratio));
        this.repositionComponent();
        this.firePropertyChange(VALUE_CHANGED, -1, 1);
    }

    private void sliderValueChanged(PropertyChangeEvent e) {
        this.firePropertyChange(VALUE_CHANGED, e.getOldValue(), e.getNewValue());
    }

    private void repositionComponent() {
        this.valueLabel.setBounds(this.getWidth() - margin - this.valueLabel.getPreferredSize().width - 1, header, this.valueLabel.getPreferredSize().width + 1, 10);
        this.slider.setBounds(margin, header + 10, this.getWidth() - 2 * margin, 20);
        this.leftLabel.setBounds(margin, header + 30, this.leftLabel.getPreferredSize().width + 1, 10);
        this.rightLabel.setBounds(this.getWidth() - margin - this.rightLabel.getPreferredSize().width - 1, header + 30, this.rightLabel.getPreferredSize().width + 1, 10);
        this.revalidate();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.repositionComponent();
        this.revalidate();
    }

    private abstract class CNumberTextField
    extends JTextField
    implements KeyListener,
    FocusListener,
    MouseListener {
        private final int[] validKeyCodes;

        public CNumberTextField(String text) {
            super(text);
            this.validKeyCodes = new int[]{8, 38, 40, 37, 39, 35, 36};
            this.setOpaque(false);
            this.setFont(new Font("Dialog", 0, 12));
            this.setForeground(Color.white);
            this.setBorder(null);
            this.addFocusListener(this);
            this.addMouseListener(this);
            this.addKeyListener(this);
        }

        public abstract void evaluateTextFieldData();

        @Override
        public void mouseClicked(MouseEvent e) {
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setBorder(BorderFactory.createLineBorder(Color.white));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setBorder(null);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.evaluateTextFieldData();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            CSliderPane.this.repositionComponent();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            CSliderPane.this.repositionComponent();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            CSliderPane.this.repositionComponent();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            int[] nArray = this.validKeyCodes;
            int n = this.validKeyCodes.length;
            int n2 = 0;
            while (n2 < n) {
                int validKeyCode = nArray[n2];
                if (e.getKeyCode() == validKeyCode) {
                    return super.processKeyBinding(ks, e, condition, pressed);
                }
                ++n2;
            }
            if (e.getKeyChar() == '.' && !this.getText().contains(".")) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            if (!(e.getKeyChar() != '-' || this.getCaretPosition() != 0 && this.getSelectionStart() != 0 || this.getText().contains("-"))) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            if (Character.isDigit(e.getKeyChar())) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            if (e.getKeyCode() == 10) {
                CSliderPane.this.slider.requestFocus();
                return false;
            }
            if (e.getKeyCode() == 27) {
                CSliderPane.this.slider.requestFocus();
                return false;
            }
            return false;
        }
    }
}

