/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.Explorer;
import edu.mit.blocks.codeblockutil.ExplorerListener;
import edu.mit.blocks.codeblockutil.StackCard;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.Timer;

public class StackExplorer
extends JLayeredPane
implements Explorer,
ActionListener {
    private static final long serialVersionUID = 328149080301L;
    private static final int buttonHeight = 20;
    private List<StackCard> drawers;
    Timer timer;
    private int count = 5;

    public StackExplorer() {
        this.setLayout(null);
        this.setOpaque(false);
        this.drawers = new ArrayList<StackCard>();
        this.timer = new Timer(35, this);
    }

    @Override
    public boolean anyCanvasSelected() {
        return false;
    }

    @Override
    public int getSelectedCanvasWidth() {
        return this.getJComponent().getWidth();
    }

    @Override
    public void addListener(ExplorerListener gel) {
    }

    @Override
    public void removeListener(ExplorerListener gel) {
    }

    @Override
    public void setDrawersCard(List<? extends Canvas> items) {
        this.drawers.clear();
        this.removeAll();
        int h = this.getHeight();
        int n = items.size();
        for (int i = 0; i < n; ++i) {
            Rectangle origin = new Rectangle(0, i * 20, this.getWidth(), this.getHeight() - n * 20);
            Rectangle destination = new Rectangle(0, i <= 0 ? 0 : h - 20 * (n - i + 1), this.getWidth(), this.getHeight() - n * 20);
            Canvas item = items.get(i);
            StackCard drawer = new StackCard(item, this);
            this.add((Component)drawer.getJComponent(), JLayeredPane.DEFAULT_LAYER);
            this.setLayer(drawer.getJComponent(), JLayeredPane.DEFAULT_LAYER, 0);
            drawer.setBounds(origin);
            drawer.reformDrawer(origin, destination);
            if (this.drawers.add(drawer)) continue;
            throw new RuntimeException("Counldn't add drawer");
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void selectCanvas(int index) {
        if (index >= 0 && index < this.drawers.size()) {
            this.notifySelection(this.drawers.get(index), !this.drawers.get(index).isDirectedToDestination());
        }
    }

    public void notifySelection(StackCard selectedDrawer, boolean directedToDestination) {
        if (!this.drawers.contains(selectedDrawer)) {
            throw new RuntimeException("Cannot select a drawer not contained in this Drawer Pane");
        }
        int index = this.drawers.indexOf(selectedDrawer);
        if (directedToDestination) {
            for (int i = index + 1; i < this.drawers.size(); ++i) {
                this.drawers.get(i).goToDestination();
            }
        } else {
            for (int i = 0; i < index + 1; ++i) {
                this.drawers.get(i).goToOrigin();
            }
        }
        this.timer.start();
    }

    @Override
    public void reformView() {
        int h = this.getHeight();
        int n = this.drawers.size() - 1;
        for (int i = 0; i <= n; ++i) {
            StackCard drawer = this.drawers.get(i);
            Rectangle origin = new Rectangle(0, i * 20, this.getWidth(), this.getHeight() - n * 20);
            Rectangle destination = new Rectangle(0, i <= 0 ? 0 : h - 20 * (n - i + 1), this.getWidth(), this.getHeight() - n * 20);
            if (drawer.isDirectedToDestination()) {
                drawer.setBounds(destination);
            } else {
                drawer.setBounds(origin);
            }
            drawer.reformDrawer(origin, destination);
        }
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.count < 0) {
            this.timer.stop();
            this.count = 5;
        } else {
            for (StackCard d : this.drawers) {
                d.animate();
            }
            --this.count;
        }
    }
}

