/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.HoverHorizontalBar;
import edu.mit.blocks.codeblockutil.HoverVerticalBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class CHoverScrollPane
extends CScrollPane
implements KeyListener {
    private static final long serialVersionUID = 328149080214L;
    private static Color defaultTrackColor = new Color(50, 50, 50, 175);
    private int SCROLLINGUNIT = 3;
    private HoverVerticalBar verticalbar;
    private HoverHorizontalBar horizontalbar;
    private JScrollPane scrollviewport;
    private CScrollPane.ScrollPolicy vpolicy;
    private CScrollPane.ScrollPolicy hpolicy;
    private int thumbWidth;

    public CHoverScrollPane(JComponent view) {
        this(view, CScrollPane.ScrollPolicy.VERTICAL_BAR_ALWAYS, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_ALWAYS);
    }

    public CHoverScrollPane(JComponent view, CScrollPane.ScrollPolicy verticalPolicy, CScrollPane.ScrollPolicy horizontalPolicy) {
        this(view, verticalPolicy, horizontalPolicy, 10, Color.darkGray, null);
    }

    public CHoverScrollPane(JComponent view, int thumbWidth, Color thumbColor, Color trackColor) {
        this(view, CScrollPane.ScrollPolicy.VERTICAL_BAR_ALWAYS, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_ALWAYS, thumbWidth, thumbColor, trackColor);
    }

    public CHoverScrollPane(JComponent view, CScrollPane.ScrollPolicy verticalPolicy, CScrollPane.ScrollPolicy horizontalPolicy, int thumbWidth, Color thumbColor, Color trackColor) {
        this.setLayout(null);
        this.vpolicy = verticalPolicy;
        this.hpolicy = horizontalPolicy;
        this.thumbWidth = thumbWidth;
        this.setOpaque(true);
        this.scrollviewport = new JScrollPane(view, 21, 31){
            private static final long serialVersionUID = 328149080215L;

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                switch (e.getKeyCode()) {
                    case 38: {
                        return false;
                    }
                    case 40: {
                        return false;
                    }
                    case 37: {
                        return false;
                    }
                    case 39: {
                        return false;
                    }
                    case 9: {
                        System.out.println("bl.enter tab");
                        return false;
                    }
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.scrollviewport.setBorder(null);
        this.scrollviewport.setWheelScrollingEnabled(true);
        if (thumbWidth < 0) {
            thumbWidth = 0;
        }
        if (thumbColor == null) {
            thumbColor = Color.black;
        }
        if (trackColor == null) {
            trackColor = defaultTrackColor;
        }
        this.verticalbar = new HoverVerticalBar(thumbWidth, thumbColor, trackColor, this.scrollviewport.getVerticalScrollBar().getModel(), verticalPolicy);
        this.horizontalbar = new HoverHorizontalBar(thumbWidth, thumbColor, trackColor, this.scrollviewport.getHorizontalScrollBar().getModel());
        view.addKeyListener(this);
        this.scrollviewport.addMouseWheelListener(this);
        this.add((Component)this.scrollviewport, JLayeredPane.DEFAULT_LAYER);
        if (verticalPolicy.equals((Object)CScrollPane.ScrollPolicy.VERTICAL_BAR_ALWAYS) || verticalPolicy.equals((Object)CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED)) {
            this.add((Component)this.verticalbar, JLayeredPane.PALETTE_LAYER);
        }
        if (horizontalPolicy.equals((Object)CScrollPane.ScrollPolicy.HORIZONTAL_BAR_ALWAYS) || horizontalPolicy.equals((Object)CScrollPane.ScrollPolicy.HORIZONTAL_BAR_AS_NEEDED)) {
            this.add((Component)this.horizontalbar, JLayeredPane.PALETTE_LAYER);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CHoverScrollPane.this.repositionComponents();
            }
        });
        this.repositionComponents();
        this.revalidate();
    }

    public void repositionComponents() {
        this.scrollviewport.setBounds(0, 0, this.getWidth(), this.getHeight());
        if (this.vpolicy.equals((Object)CScrollPane.ScrollPolicy.VERTICAL_BAR_ALWAYS) || this.vpolicy.equals((Object)CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED)) {
            this.verticalbar.setBounds(this.getWidth() - this.thumbWidth, 7, this.thumbWidth, this.getHeight() - this.thumbWidth - 7);
        } else {
            this.verticalbar.setBounds(this.getWidth() - this.thumbWidth, 7, 0, 0);
        }
        if (this.hpolicy.equals((Object)CScrollPane.ScrollPolicy.HORIZONTAL_BAR_ALWAYS)) {
            this.horizontalbar.setBounds(7, this.getHeight() - this.thumbWidth, this.getWidth() - this.thumbWidth - 7, this.thumbWidth);
        } else if (this.hpolicy.equals((Object)CScrollPane.ScrollPolicy.HORIZONTAL_BAR_AS_NEEDED)) {
            if (this.getWidth() < this.scrollviewport.getViewport().getView().getWidth() - 2) {
                this.horizontalbar.setBounds(7, this.getHeight() - this.thumbWidth, this.getWidth() - this.thumbWidth - 7, this.thumbWidth);
            } else {
                this.horizontalbar.setBounds(7, this.getHeight() - this.thumbWidth, 0, 0);
            }
        }
        this.revalidate();
    }

    @Override
    public BoundedRangeModel getVerticalModel() {
        return this.scrollviewport.getVerticalScrollBar().getModel();
    }

    @Override
    public BoundedRangeModel getHorizontalModel() {
        return this.scrollviewport.getHorizontalScrollBar().getModel();
    }

    @Override
    public void scrollRectToVisible(Rectangle contentRect) {
        this.scrollviewport.getViewport().scrollRectToVisible(contentRect);
    }

    @Override
    public void setScrollingUnit(int x) {
        this.SCROLLINGUNIT = x;
        this.verticalbar.setScrollingUnit(x);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isShiftDown()) {
            this.scrollviewport.getHorizontalScrollBar().getModel().setValue(this.scrollviewport.getHorizontalScrollBar().getModel().getValue() + e.getUnitsToScroll() * e.getScrollAmount() * this.SCROLLINGUNIT);
            this.horizontalbar.repaint();
        } else {
            this.scrollviewport.getVerticalScrollBar().getModel().setValue(this.scrollviewport.getVerticalScrollBar().getModel().getValue() + e.getUnitsToScroll() * e.getScrollAmount() * this.SCROLLINGUNIT);
            this.verticalbar.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.verticalbar.repaint();
        this.horizontalbar.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.verticalbar.repaint();
        this.horizontalbar.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.verticalbar.repaint();
        this.horizontalbar.repaint();
    }
}

