/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.ui.listener;

import com.ardublock.core.Context;
import com.ardublock.translator.Translator;
import com.ardublock.translator.block.exception.BlockException;
import com.ardublock.translator.block.exception.SocketNullException;
import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GenerateCodeButtonListener
implements ActionListener {
    private JFrame parentFrame;
    private Context context;
    private Workspace workspace;

    public GenerateCodeButtonListener(JFrame frame, Context context) {
        this.parentFrame = frame;
        this.context = context;
        this.workspace = context.getWorkspaceController().getWorkspace();
    }

    public void actionPerformed(ActionEvent e) {
        boolean success = true;
        Translator translator = new Translator(this.workspace);
        Iterable<RenderableBlock> renderableBlocks = this.workspace.getRenderableBlocks();
        HashSet<RenderableBlock> loopBlockSet = new HashSet<RenderableBlock>();
        String code = null;
        for (RenderableBlock renderableBlock : renderableBlocks) {
            Block block = renderableBlock.getBlock();
            if (block.hasPlug() || !Block.NULL.equals(block.getBeforeBlockID()) || !block.getGenusName().equals("loop")) continue;
            loopBlockSet.add(renderableBlock);
        }
        if (loopBlockSet.size() == 0) {
            JOptionPane.showOptionDialog(this.parentFrame, "No loop found!", "Error", 0, 0, null, null, 0);
            return;
        }
        if (loopBlockSet.size() > 1) {
            for (RenderableBlock rb : loopBlockSet) {
                this.context.highlightBlock(rb);
            }
            JOptionPane.showOptionDialog(this.parentFrame, "multiple loop block found!", "Error", 0, 0, null, null, 0);
            return;
        }
        for (RenderableBlock renderableBlock : loopBlockSet) {
            Block block2;
            Iterable<RenderableBlock> blocks;
            Long blockId;
            Block loopBlock = renderableBlock.getBlock();
            try {
                code = translator.translate(loopBlock.getBlockID());
            }
            catch (SocketNullException e1) {
                e1.printStackTrace();
                success = false;
                blockId = e1.getBlockId();
                blocks = this.workspace.getRenderableBlocks();
                for (RenderableBlock renderableBlock2 : blocks) {
                    block2 = renderableBlock2.getBlock();
                    if (!block2.getBlockID().equals(blockId)) continue;
                    this.context.highlightBlock(renderableBlock2);
                    break;
                }
                JOptionPane.showOptionDialog(this.parentFrame, "socket null", "Error", 0, 0, null, null, 0);
            }
            catch (BlockException e2) {
                e2.printStackTrace();
                success = false;
                blockId = e2.getBlockId();
                blocks = this.workspace.getRenderableBlocks();
                for (RenderableBlock renderableBlock2 : blocks) {
                    block2 = renderableBlock2.getBlock();
                    if (!block2.getBlockID().equals(blockId)) continue;
                    this.context.highlightBlock(renderableBlock2);
                    break;
                }
                JOptionPane.showOptionDialog(this.parentFrame, e2.getMessage(), "Error", 0, 0, null, null, 0);
            }
        }
        if (success) {
            this.context.didGenerate(code);
        }
    }
}

