/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.ui;

import com.ardublock.core.Context;
import com.ardublock.ui.listener.ArdublockWorkspaceListener;
import com.ardublock.ui.listener.GenerateCodeButtonListener;
import com.ardublock.ui.listener.OpenButtonListener;
import com.ardublock.ui.listener.OpenblocksFrameListener;
import com.ardublock.ui.listener.SaveButtonListener;
import edu.mit.blocks.controller.WorkspaceController;
import edu.mit.blocks.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class OpenblocksFrame
extends JFrame {
    private static final long serialVersionUID = 2841155965906223806L;
    private Context context = Context.getContext();
    private String saveFilePath = null;
    private String saveFileName = "untitled";
    private JFileChooser fileChooser;
    private FileFilter ffilter;
    private ResourceBundle uiMessageBundle;

    public void addListener(OpenblocksFrameListener ofl) {
        this.context.registerOpenblocksFrameListener(ofl);
    }

    public String makeFrameTitle() {
        String title = "ArduBlock " + this.saveFileName;
        if (this.context.isWorkspaceChanged()) {
            title = title + " *";
        }
        return title;
    }

    public OpenblocksFrame() {
        this.setTitle(this.makeFrameTitle());
        this.setSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(null);
        this.uiMessageBundle = ResourceBundle.getBundle("com/ardublock/block/ardublock");
        this.fileChooser = new JFileChooser();
        this.ffilter = new FileNameExtensionFilter(this.uiMessageBundle.getString("ardublock.file.suffix"), "abp");
        this.fileChooser.setFileFilter(this.ffilter);
        this.fileChooser.addChoosableFileFilter(this.ffilter);
        this.initOpenBlocks();
    }

    private void initOpenBlocks() {
        Context context = Context.getContext();
        Workspace workspace = context.getWorkspace();
        workspace.addWorkspaceListener(new ArdublockWorkspaceListener(this));
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        JButton saveButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.save"));
        saveButton.addActionListener(new SaveButtonListener(this));
        JButton openButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.load"));
        openButton.addActionListener(new OpenButtonListener(this));
        JButton generateButton = new JButton(this.uiMessageBundle.getString("ardublock.ui.upload"));
        generateButton.addActionListener(new GenerateCodeButtonListener(this, context));
        buttons.add(saveButton);
        buttons.add(openButton);
        buttons.add(generateButton);
        this.add((Component)buttons, "North");
        this.add((Component)workspace, "Center");
    }

    public void doOpenArduBlockFile() {
        if (this.context.isWorkspaceChanged()) {
            int optionValue = JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.content.open_unsaved"), this.uiMessageBundle.getString("message.title.question"), 1, 3, null, null, 0);
            if (optionValue == 0) {
                this.doSaveArduBlockFile();
                this.loadFile();
            } else if (optionValue == 1) {
                this.loadFile();
            }
        } else {
            this.loadFile();
        }
        this.setTitle(this.makeFrameTitle());
    }

    private void loadFile() {
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            File savedFile = this.fileChooser.getSelectedFile();
            if (!savedFile.exists()) {
                JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.file_not_found"), this.uiMessageBundle.getString("message.title.error"), 0, 0, null, null, 0);
                return;
            }
            this.saveFilePath = savedFile.getAbsolutePath();
            this.saveFileName = savedFile.getName();
            try {
                this.context.loadArduBlockFile(savedFile);
                this.context.setWorkspaceChanged(false);
            }
            catch (IOException e) {
                JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.file_not_found"), this.uiMessageBundle.getString("message.title.error"), 0, 0, null, null, 0);
                e.printStackTrace();
            }
        }
    }

    public void doSaveArduBlockFile() {
        if (this.context.isWorkspaceChanged()) {
            try {
                WorkspaceController workspaceController = this.context.getWorkspaceController();
                String saveString = workspaceController.getSaveString();
                if (this.saveFilePath == null) {
                    int chooseResult = this.fileChooser.showSaveDialog(this);
                    if (chooseResult == 0) {
                        File saveFile = this.fileChooser.getSelectedFile();
                        if ((saveFile = this.checkFileSuffix(saveFile)) != null) {
                            int optionValue;
                            if (saveFile.exists() && (optionValue = JOptionPane.showOptionDialog(this, this.uiMessageBundle.getString("message.content.overwrite"), this.uiMessageBundle.getString("message.title.question"), 1, 3, null, null, 0)) != 0) {
                                return;
                            }
                            this.context.saveArduBlockFile(saveFile, saveString);
                            this.saveFilePath = saveFile.getAbsolutePath();
                            this.saveFileName = saveFile.getName();
                            this.context.setWorkspaceChanged(false);
                            this.setTitle(this.makeFrameTitle());
                        }
                    }
                } else {
                    File saveFile = new File(this.saveFilePath);
                    this.context.saveArduBlockFile(saveFile, saveString);
                    this.saveFilePath = saveFile.getAbsolutePath();
                    this.saveFileName = saveFile.getName();
                    this.context.setWorkspaceChanged(false);
                    this.setTitle(this.makeFrameTitle());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private File checkFileSuffix(File saveFile) {
        String filePath = saveFile.getAbsolutePath();
        if (filePath.endsWith(".abp")) {
            return saveFile;
        }
        return new File(filePath + ".abp");
    }
}

