/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.tinker;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.NumberBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.tinker.TinkerOutputPortBlock;

public abstract class AbstractTinkerWriteDigitalBlock
extends TranslatorBlock {
    AbstractTinkerWriteDigitalBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
        translator.addHeaderFile("TinkerKit.h");
    }

    public String toCode() throws SocketNullException {
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        String ret = "";
        if (translatorBlock instanceof NumberBlock || translatorBlock instanceof TinkerOutputPortBlock) {
            String number = translatorBlock.toCode();
            String setupCode = "pinMode( " + number + " , OUTPUT);";
            this.translator.addSetupCommand(setupCode);
            ret = "digitalWrite( ";
            ret = ret + number;
        } else {
            this.translator.addDefinitionCommand("void __ardublockDigitalWrite(int pinNumber, boolean status)\n{\npinMode(pinNumber, OUTPUT);\ndigitalWrite(pinNumber, status);\n}\n");
            ret = "__ardublockDigitalWrite(";
            ret = ret + translatorBlock.toCode();
        }
        ret = ret + " , ";
        translatorBlock = this.getRequiredTranslatorBlockAtSocket(1);
        ret = ret + translatorBlock.toCode();
        ret = ret + " );\n";
        return ret;
    }
}

