/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.core;

import com.ardublock.ui.listener.OpenblocksFrameListener;
import edu.mit.blocks.controller.WorkspaceController;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

public class Context {
    public static final String LANG_DTD_PATH = "/com/ardublock/block/lang_def.dtd";
    public static final String ARDUBLOCK_LANG_PATH = "/com/ardublock/block/ardublock.xml";
    private static Context singletonContext;
    private boolean workspaceChanged;
    private Set<RenderableBlock> highlightBlockSet;
    private Set<OpenblocksFrameListener> ofls;
    public static final String APP_NAME = "ArduBlock";
    private WorkspaceController workspaceController;
    private Workspace workspace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Context getContext() {
        if (singletonContext != null) return singletonContext;
        Class<Context> clazz = Context.class;
        synchronized (Context.class) {
            if (singletonContext != null) return singletonContext;
            singletonContext = new Context();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonContext;
        }
    }

    private Context() {
        String[][] styles;
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (String[] style : styles = new String[0][]) {
            list.add(style);
        }
        this.workspaceController = new WorkspaceController();
        this.workspaceController.resetWorkspace();
        this.workspaceController.resetLanguage();
        this.workspaceController.setLangResourceBundle(ResourceBundle.getBundle("com/ardublock/block/ardublock"));
        this.workspaceController.setStyleList(list);
        this.workspaceController.setLangDefDtd(this.getClass().getResourceAsStream(LANG_DTD_PATH));
        this.workspaceController.setLangDefStream(this.getClass().getResourceAsStream(ARDUBLOCK_LANG_PATH));
        this.workspaceController.loadFreshWorkspace();
        this.workspace = this.workspaceController.getWorkspace();
        this.workspaceChanged = false;
        this.highlightBlockSet = new HashSet<RenderableBlock>();
        this.ofls = new HashSet<OpenblocksFrameListener>();
        this.workspace = this.workspaceController.getWorkspace();
    }

    public WorkspaceController getWorkspaceController() {
        return this.workspaceController;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean isWorkspaceChanged() {
        return this.workspaceChanged;
    }

    public void setWorkspaceChanged(boolean workspaceChanged) {
        this.workspaceChanged = workspaceChanged;
    }

    public void highlightBlock(RenderableBlock block) {
        block.updateInSearchResults(true);
        this.highlightBlockSet.add(block);
    }

    public void cancelHighlightBlock(RenderableBlock block) {
        block.updateInSearchResults(false);
        this.highlightBlockSet.remove(block);
    }

    public void resetHightlightBlock() {
        for (RenderableBlock rb : this.highlightBlockSet) {
            rb.updateInSearchResults(false);
        }
        this.highlightBlockSet.clear();
    }

    public void saveArduBlockFile(File saveFile, String saveString) throws IOException {
        if (!saveFile.exists()) {
            saveFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(saveFile, false);
        fos.write(saveString.getBytes("UTF8"));
        fos.flush();
        fos.close();
        this.didSave();
    }

    public void loadArduBlockFile(File savedFile) throws IOException {
        if (savedFile != null) {
            String saveFilePath = savedFile.getAbsolutePath();
            this.workspaceController.resetWorkspace();
            this.workspaceController.loadProjectFromPath(saveFilePath);
            this.didLoad();
        }
    }

    public void registerOpenblocksFrameListener(OpenblocksFrameListener ofl) {
        this.ofls.add(ofl);
    }

    public void didSave() {
        for (OpenblocksFrameListener ofl : this.ofls) {
            ofl.didSave();
        }
    }

    public void didLoad() {
        for (OpenblocksFrameListener ofl : this.ofls) {
            ofl.didLoad();
        }
    }

    public void didGenerate(String sourcecode) {
        for (OpenblocksFrameListener ofl : this.ofls) {
            ofl.didGenerate(sourcecode);
        }
    }
}

