/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.videosurface;

import com.sun.jna.Native;
import java.awt.Component;
import uk.co.caprica.vlcj.binding.OsxComponentId;
import uk.co.caprica.vlcj.binding.RuntimeUtil;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;

public class ComponentVideoSurface
extends VideoSurface {
    private final Component component;

    public ComponentVideoSurface(Component component, VideoSurfaceAdapter videoSurfaceAdapter) {
        super(videoSurfaceAdapter);
        this.component = component;
    }

    public final Component component() {
        return this.component;
    }

    @Override
    public void attach(MediaPlayer mediaPlayer) {
        if (!this.component.isDisplayable()) {
            throw new IllegalStateException("The video surface component must be displayable");
        }
        long componentId = this.getComponentId(this.component);
        this.videoSurfaceAdapter.attach(mediaPlayer, componentId);
    }

    private long getComponentId(Component component) {
        if (!RuntimeUtil.isMac()) {
            return Native.getComponentID(component);
        }
        return OsxComponentId.getOsxComponentId(component);
    }
}

