/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.component;

import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.component.AudioPlayerComponentBase;
import uk.co.caprica.vlcj.player.component.MediaPlayerComponent;
import uk.co.caprica.vlcj.player.component.MediaPlayerComponentDefaults;
import uk.co.caprica.vlcj.player.component.MediaPlayerSpecs;

public class AudioPlayerComponent
extends AudioPlayerComponentBase
implements MediaPlayerComponent {
    static final String[] DEFAULT_FACTORY_ARGUMENTS = MediaPlayerComponentDefaults.AUDIO_MEDIA_PLAYER_ARGS;
    private final boolean ownFactory;
    private final MediaPlayerFactory mediaPlayerFactory;
    private final MediaPlayer mediaPlayer;

    public AudioPlayerComponent(MediaPlayerFactory mediaPlayerFactory) {
        this.ownFactory = mediaPlayerFactory == null;
        this.mediaPlayerFactory = this.initMediaPlayerFactory(mediaPlayerFactory);
        this.mediaPlayer = this.mediaPlayerFactory.mediaPlayers().newMediaPlayer();
        this.mediaPlayer.events().addMediaPlayerEventListener(this);
        this.mediaPlayer.events().addMediaEventListener(this);
        this.onAfterConstruct();
    }

    public AudioPlayerComponent(MediaPlayerSpecs.AudioPlayerSpec spec) {
        this(spec.factory);
    }

    public AudioPlayerComponent() {
        this((MediaPlayerFactory)null);
    }

    private MediaPlayerFactory initMediaPlayerFactory(MediaPlayerFactory mediaPlayerFactory) {
        if (mediaPlayerFactory == null) {
            mediaPlayerFactory = new MediaPlayerFactory(DEFAULT_FACTORY_ARGUMENTS);
        }
        return mediaPlayerFactory;
    }

    public final MediaPlayer mediaPlayer() {
        return this.mediaPlayer;
    }

    public final void release() {
        this.onBeforeRelease();
        this.mediaPlayer.release();
        if (this.ownFactory) {
            this.mediaPlayerFactory.release();
        }
        this.onAfterRelease();
    }

    @Override
    public final MediaPlayerFactory mediaPlayerFactory() {
        return this.mediaPlayerFactory;
    }

    protected void onAfterConstruct() {
    }

    protected void onBeforeRelease() {
    }

    protected void onAfterRelease() {
    }
}

