/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_t;
import uk.co.caprica.vlcj.media.EventApi;
import uk.co.caprica.vlcj.media.InfoApi;
import uk.co.caprica.vlcj.media.Media;
import uk.co.caprica.vlcj.media.MediaEventListener;
import uk.co.caprica.vlcj.media.MediaFactory;
import uk.co.caprica.vlcj.media.MediaRef;
import uk.co.caprica.vlcj.media.MediaSlaveType;
import uk.co.caprica.vlcj.media.MetaApi;
import uk.co.caprica.vlcj.media.OptionsApi;
import uk.co.caprica.vlcj.media.ParseApi;
import uk.co.caprica.vlcj.media.SlaveApi;
import uk.co.caprica.vlcj.media.SubitemApi;
import uk.co.caprica.vlcj.media.callback.CallbackMedia;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;

public final class MediaApi
extends BaseApi {
    private final List<MediaEventListener> persistentMediaEventListeners = new ArrayList<MediaEventListener>();
    private Media media;

    MediaApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public boolean prepare(String mrl, String ... options) {
        return this.changeMedia(MediaFactory.newMedia(this.libvlcInstance, mrl, options));
    }

    public boolean play(String mrl, String ... options) {
        if (this.prepare(mrl, options)) {
            return this.play();
        }
        return false;
    }

    public boolean start(String mrl, String ... options) {
        if (this.prepare(mrl, options)) {
            return this.start();
        }
        return false;
    }

    public boolean prepare(CallbackMedia callbackMedia, String ... options) {
        return this.changeMedia(MediaFactory.newMedia(this.libvlcInstance, callbackMedia, options));
    }

    public boolean play(CallbackMedia callbackMedia, String ... options) {
        if (this.prepare(callbackMedia, options)) {
            return this.play();
        }
        return false;
    }

    public boolean start(CallbackMedia callbackMedia, String ... options) {
        if (this.prepare(callbackMedia, options)) {
            return this.start();
        }
        return false;
    }

    public boolean prepare(MediaRef mediaRef, String ... options) {
        return this.changeMedia(MediaFactory.newMedia(this.libvlcInstance, mediaRef, options));
    }

    public boolean play(MediaRef mediaRef, String ... options) {
        if (this.prepare(mediaRef, options)) {
            return this.play();
        }
        return false;
    }

    public boolean start(MediaRef mediaRef, String ... options) {
        if (this.prepare(mediaRef, options)) {
            return this.start();
        }
        return false;
    }

    public boolean addSlave(MediaSlaveType type, String uri, boolean select) {
        return LibVlc.libvlc_media_player_add_slave(this.mediaPlayerInstance, type.intValue(), uri, select ? 1 : 0) == 0;
    }

    public Media newMedia() {
        return this.media != null ? this.media.newMedia() : null;
    }

    public MediaRef newMediaRef() {
        return this.media != null ? this.media.newMediaRef() : null;
    }

    public boolean isValid() {
        return this.media != null;
    }

    public EventApi events() {
        return this.media != null ? this.media.events() : null;
    }

    public InfoApi info() {
        return this.media != null ? this.media.info() : null;
    }

    public MetaApi meta() {
        return this.media != null ? this.media.meta() : null;
    }

    public OptionsApi options() {
        return this.media != null ? this.media.options() : null;
    }

    public ParseApi parsing() {
        return this.media != null ? this.media.parsing() : null;
    }

    public SlaveApi slaves() {
        return this.media != null ? this.media.slaves() : null;
    }

    public SubitemApi subitems() {
        return this.media != null ? this.media.subitems() : null;
    }

    private boolean changeMedia(Media newMedia) {
        if (this.media != null) {
            this.media.release();
        }
        if (newMedia != null) {
            this.media = newMedia;
            this.setPersistentEventListeners();
            this.applyMedia();
            return true;
        }
        this.media = null;
        return false;
    }

    private boolean play() {
        this.mediaPlayer.controls().play();
        return true;
    }

    private boolean start() {
        return this.mediaPlayer.controls().start();
    }

    private void applyMedia() {
        libvlc_media_t mediaInstance = this.media.mediaInstance();
        LibVlc.libvlc_media_player_set_media(this.mediaPlayerInstance, mediaInstance);
        this.mediaPlayer.subitems().changeMedia(mediaInstance);
    }

    void addPersistentMediaEventListener(MediaEventListener listener) {
        this.persistentMediaEventListeners.add(listener);
        if (this.media != null) {
            this.media.events().addMediaEventListener(listener);
        }
    }

    void removePersistentMediaEventListener(MediaEventListener listener) {
        this.persistentMediaEventListeners.remove(listener);
        if (this.media != null) {
            this.media.events().removeMediaEventListener(listener);
        }
    }

    private void setPersistentEventListeners() {
        if (this.media != null) {
            for (MediaEventListener listener : this.persistentMediaEventListeners) {
                this.media.events().addMediaEventListener(listener);
            }
        }
    }

    @Override
    protected void release() {
        if (this.media != null) {
            this.media.release();
        }
    }
}

