/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.base;

import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.NativeString;
import uk.co.caprica.vlcj.binding.internal.libvlc_audio_output_device_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_equalizer_t;
import uk.co.caprica.vlcj.player.base.AudioCallbacks;
import uk.co.caprica.vlcj.player.base.AudioChannel;
import uk.co.caprica.vlcj.player.base.AudioDevice;
import uk.co.caprica.vlcj.player.base.BaseApi;
import uk.co.caprica.vlcj.player.base.Descriptions;
import uk.co.caprica.vlcj.player.base.Equalizer;
import uk.co.caprica.vlcj.player.base.EqualizerListener;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.TrackDescription;
import uk.co.caprica.vlcj.player.base.callback.AudioCallback;

public final class AudioApi
extends BaseApi
implements EqualizerListener {
    private final AudioCallbacks audioCallbacks;
    private Equalizer equalizer;
    private libvlc_equalizer_t equalizerInstance;

    AudioApi(MediaPlayer mediaPlayer) {
        super(mediaPlayer);
        this.audioCallbacks = new AudioCallbacks(mediaPlayer);
    }

    public boolean setOutput(String output) {
        return 0 == LibVlc.libvlc_audio_output_set(this.mediaPlayerInstance, output);
    }

    public String outputDevice() {
        return NativeString.copyAndFreeNativeString(LibVlc.libvlc_audio_output_device_get(this.mediaPlayerInstance));
    }

    public void setOutputDevice(String output, String outputDeviceId) {
        LibVlc.libvlc_audio_output_device_set(this.mediaPlayerInstance, output, outputDeviceId);
    }

    public List<AudioDevice> outputDevices() {
        ArrayList<AudioDevice> result = new ArrayList<AudioDevice>();
        libvlc_audio_output_device_t audioDevices = LibVlc.libvlc_audio_output_device_enum(this.mediaPlayerInstance);
        if (audioDevices != null) {
            libvlc_audio_output_device_t audioDevice = audioDevices;
            while (audioDevice != null) {
                String device = NativeString.copyNativeString(audioDevice.psz_device);
                String description = NativeString.copyNativeString(audioDevice.psz_description);
                result.add(new AudioDevice(device, description));
                audioDevice = audioDevice.p_next;
            }
            LibVlc.libvlc_audio_output_device_list_release(audioDevices.getPointer());
        }
        return result;
    }

    public boolean mute() {
        LibVlc.libvlc_audio_toggle_mute(this.mediaPlayerInstance);
        return this.isMute();
    }

    public void setMute(boolean mute) {
        LibVlc.libvlc_audio_set_mute(this.mediaPlayerInstance, mute ? 1 : 0);
    }

    public boolean isMute() {
        return LibVlc.libvlc_audio_get_mute(this.mediaPlayerInstance) != 0;
    }

    public int volume() {
        return LibVlc.libvlc_audio_get_volume(this.mediaPlayerInstance);
    }

    public void setVolume(int volume) {
        LibVlc.libvlc_audio_set_volume(this.mediaPlayerInstance, volume);
    }

    public AudioChannel channel() {
        return AudioChannel.audioChannel(LibVlc.libvlc_audio_get_channel(this.mediaPlayerInstance));
    }

    public boolean setChannel(AudioChannel channel) {
        return LibVlc.libvlc_audio_set_channel(this.mediaPlayerInstance, channel.intValue()) == 0;
    }

    public long delay() {
        return LibVlc.libvlc_audio_get_delay(this.mediaPlayerInstance);
    }

    public void setDelay(long delay) {
        LibVlc.libvlc_audio_set_delay(this.mediaPlayerInstance, delay);
    }

    public Equalizer equalizer() {
        return this.equalizer;
    }

    public void setEqualizer(Equalizer equalizer) {
        if (this.equalizer != null) {
            this.equalizer.removeEqualizerListener(this);
            LibVlc.libvlc_audio_equalizer_release(this.equalizerInstance);
            this.equalizerInstance = null;
        }
        this.equalizer = equalizer;
        if (this.equalizer != null) {
            this.equalizerInstance = LibVlc.libvlc_audio_equalizer_new();
            this.equalizer.addEqualizerListener(this);
        }
        this.applyEqualizer();
    }

    @Override
    public final void equalizerChanged(Equalizer equalizer) {
        this.applyEqualizer();
    }

    private void applyEqualizer() {
        if (this.equalizerInstance != null) {
            LibVlc.libvlc_audio_equalizer_set_preamp(this.equalizerInstance, this.equalizer.preamp());
            for (int i = 0; i < LibVlc.libvlc_audio_equalizer_get_band_count(); ++i) {
                LibVlc.libvlc_audio_equalizer_set_amp_at_index(this.equalizerInstance, this.equalizer.amp(i), i);
            }
            LibVlc.libvlc_media_player_set_equalizer(this.mediaPlayerInstance, this.equalizerInstance);
        } else {
            LibVlc.libvlc_media_player_set_equalizer(this.mediaPlayerInstance, null);
        }
    }

    public int trackCount() {
        return LibVlc.libvlc_audio_get_track_count(this.mediaPlayerInstance);
    }

    public int track() {
        return LibVlc.libvlc_audio_get_track(this.mediaPlayerInstance);
    }

    public int setTrack(int track) {
        LibVlc.libvlc_audio_set_track(this.mediaPlayerInstance, track);
        return this.track();
    }

    public List<TrackDescription> trackDescriptions() {
        return Descriptions.audioTrackDescriptions(this.mediaPlayerInstance);
    }

    public void callback(String format, int rate, int channels, AudioCallback audioCallback) {
        this.callback(format, rate, channels, audioCallback, false);
    }

    public void callback(String format, int rate, int channels, AudioCallback audioCallback, boolean manageVolume) {
        this.audioCallbacks.callback(format, rate, channels, audioCallback, manageVolume);
    }

    @Override
    protected void release() {
        this.setEqualizer(null);
    }
}

