/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.dom;

import com.sun.org.apache.xalan.internal.xsltc.DOM;
import com.sun.org.apache.xalan.internal.xsltc.DOMCache;
import com.sun.org.apache.xalan.internal.xsltc.DOMEnhancedForDTM;
import com.sun.org.apache.xalan.internal.xsltc.Translet;
import com.sun.org.apache.xalan.internal.xsltc.dom.XSLTCDTMManager;
import com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet;
import com.sun.org.apache.xalan.internal.xsltc.runtime.BasisLibrary;
import com.sun.org.apache.xml.internal.utils.SystemIDResolver;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class DocumentCache
implements DOMCache {
    private int _size;
    private Map<String, CachedDocument> _references;
    private String[] _URIs;
    private int _count;
    private int _current;
    private SAXParser _parser;
    private XMLReader _reader;
    private XSLTCDTMManager _dtmManager;
    private static final int REFRESH_INTERVAL = 1000;

    public DocumentCache(int n) throws SAXException {
        this(n, null);
        try {
            this._dtmManager = XSLTCDTMManager.createNewDTMManagerInstance();
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public DocumentCache(int n, XSLTCDTMManager xSLTCDTMManager) throws SAXException {
        this._dtmManager = xSLTCDTMManager;
        this._count = 0;
        this._current = 0;
        this._size = n;
        this._references = new HashMap<String, CachedDocument>(this._size + 2);
        this._URIs = new String[this._size];
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            try {
                sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (Exception exception) {
                sAXParserFactory.setNamespaceAware(true);
            }
            this._parser = sAXParserFactory.newSAXParser();
            this._reader = this._parser.getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            BasisLibrary.runTimeError("NAMESPACES_SUPPORT_ERR");
        }
    }

    private final long getLastModified(String string) {
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            long l = uRLConnection.getLastModified();
            if (l == 0L && "file".equals(uRL.getProtocol())) {
                File file = new File(URLDecoder.decode(uRL.getFile()));
                l = file.lastModified();
            }
            return l;
        }
        catch (Exception exception) {
            return System.currentTimeMillis();
        }
    }

    private CachedDocument lookupDocument(String string) {
        return this._references.get(string);
    }

    private synchronized void insertDocument(String string, CachedDocument cachedDocument) {
        if (this._count < this._size) {
            this._URIs[this._count++] = string;
            this._current = 0;
        } else {
            this._references.remove(this._URIs[this._current]);
            this._URIs[this._current] = string;
            if (++this._current >= this._size) {
                this._current = 0;
            }
        }
        this._references.put(string, cachedDocument);
    }

    private synchronized void replaceDocument(String string, CachedDocument cachedDocument) {
        if (cachedDocument == null) {
            this.insertDocument(string, cachedDocument);
        } else {
            this._references.put(string, cachedDocument);
        }
    }

    @Override
    public DOM retrieveDocument(String string, String string2, Translet translet) {
        CachedDocument cachedDocument;
        String string3 = string2;
        if (string != null && !string.equals("")) {
            try {
                string3 = SystemIDResolver.getAbsoluteURI(string3, string);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
        if ((cachedDocument = this.lookupDocument(string3)) == null) {
            cachedDocument = new CachedDocument(string3);
            if (cachedDocument == null) {
                return null;
            }
            cachedDocument.setLastModified(this.getLastModified(string3));
            this.insertDocument(string3, cachedDocument);
        } else {
            long l = System.currentTimeMillis();
            long l2 = cachedDocument.getLastChecked();
            cachedDocument.setLastChecked(l);
            if (l > l2 + 1000L) {
                cachedDocument.setLastChecked(l);
                long l3 = this.getLastModified(string3);
                if (l3 > cachedDocument.getLastModified()) {
                    cachedDocument = new CachedDocument(string3);
                    if (cachedDocument == null) {
                        return null;
                    }
                    cachedDocument.setLastModified(this.getLastModified(string3));
                    this.replaceDocument(string3, cachedDocument);
                }
            }
        }
        DOM dOM = cachedDocument.getDocument();
        if (dOM == null) {
            return null;
        }
        cachedDocument.incAccessCount();
        AbstractTranslet abstractTranslet = (AbstractTranslet)translet;
        abstractTranslet.prepassDocument(dOM);
        return cachedDocument.getDocument();
    }

    public void getStatistics(PrintWriter printWriter) {
        printWriter.println("<h2>DOM cache statistics</h2><center><table border=\"2\"><tr><td><b>Document URI</b></td><td><center><b>Build time</b></center></td><td><center><b>Access count</b></center></td><td><center><b>Last accessed</b></center></td><td><center><b>Last modified</b></center></td></tr>");
        for (int i = 0; i < this._count; ++i) {
            CachedDocument cachedDocument = this._references.get(this._URIs[i]);
            printWriter.print("<tr><td><a href=\"" + this._URIs[i] + "\">" + "<font size=-1>" + this._URIs[i] + "</font></a></td>");
            printWriter.print("<td><center>" + cachedDocument.getLatency() + "ms</center></td>");
            printWriter.print("<td><center>" + cachedDocument.getAccessCount() + "</center></td>");
            printWriter.print("<td><center>" + new Date(cachedDocument.getLastReferenced()) + "</center></td>");
            printWriter.print("<td><center>" + new Date(cachedDocument.getLastModified()) + "</center></td>");
            printWriter.println("</tr>");
        }
        printWriter.println("</table></center>");
    }

    public final class CachedDocument {
        private long _firstReferenced;
        private long _lastReferenced;
        private long _accessCount;
        private long _lastModified;
        private long _lastChecked;
        private long _buildTime;
        private DOMEnhancedForDTM _dom = null;

        public CachedDocument(String string) {
            long l;
            this._firstReferenced = l = System.currentTimeMillis();
            this._lastReferenced = l;
            this._accessCount = 0L;
            this.loadDocument(string);
            this._buildTime = System.currentTimeMillis() - l;
        }

        public void loadDocument(String string) {
            try {
                long l = System.currentTimeMillis();
                this._dom = (DOMEnhancedForDTM)((Object)DocumentCache.this._dtmManager.getDTM(new SAXSource(DocumentCache.this._reader, new InputSource(string)), false, null, true, false));
                this._dom.setDocumentURI(string);
                long l2 = System.currentTimeMillis() - l;
                this._buildTime = this._buildTime > 0L ? this._buildTime + l2 >>> 1 : l2;
            }
            catch (Exception exception) {
                this._dom = null;
            }
        }

        public DOM getDocument() {
            return this._dom;
        }

        public long getFirstReferenced() {
            return this._firstReferenced;
        }

        public long getLastReferenced() {
            return this._lastReferenced;
        }

        public long getAccessCount() {
            return this._accessCount;
        }

        public void incAccessCount() {
            ++this._accessCount;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public void setLastModified(long l) {
            this._lastModified = l;
        }

        public long getLatency() {
            return this._buildTime;
        }

        public long getLastChecked() {
            return this._lastChecked;
        }

        public void setLastChecked(long l) {
            this._lastChecked = l;
        }

        public long getEstimatedSize() {
            if (this._dom != null) {
                return this._dom.getSize() << 5;
            }
            return 0L;
        }
    }
}

