/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import org.jfugue.MicrotoneNotation;
import org.jfugue.Note;
import org.jfugue.Pattern;

public class MusicalEffects {
    public static Pattern hammerOn(Note note1, Note note2, double duration, int numHammers) {
        StringBuilder buddy = new StringBuilder();
        double durationPerHammer = duration / (double)numHammers;
        buddy.append("[");
        buddy.append(note1.getValue());
        buddy.append("]/");
        buddy.append(durationPerHammer / 2.0);
        buddy.append(" [");
        buddy.append(note2.getValue());
        buddy.append("]/");
        buddy.append(durationPerHammer / 2.0);
        Pattern pattern = new Pattern(buddy.toString());
        pattern.repeat(numHammers);
        return pattern;
    }

    public static Pattern slide(Note note1, Note note2, double duration, int numSteps) {
        StringBuilder buddy = new StringBuilder();
        double durationPerStep = duration / (double)numSteps;
        double freq1 = Note.getFrequencyForNote(note1.getValue());
        double freq2 = Note.getFrequencyForNote(note2.getValue());
        double differencePerStep = (freq2 - freq1) / (double)numSteps;
        int i = 0;
        while (i < numSteps) {
            buddy.append(MicrotoneNotation.convertFrequencyToMusicString(freq1));
            buddy.append("/");
            buddy.append(durationPerStep);
            buddy.append(MicrotoneNotation.getResetPitchWheelString());
            buddy.append(" ");
            freq1 += differencePerStep;
            ++i;
        }
        Pattern pattern = new Pattern(buddy.toString());
        return pattern;
    }

    public static Pattern trill(Note note1, Note note2, double duration, int numSteps) {
        return MusicalEffects.hammerOn(note1, note2, duration, numSteps);
    }
}

