/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import java.util.HashMap;
import java.util.Map;
import org.jfugue.ChannelPressure;
import org.jfugue.CollatedParserListener;
import org.jfugue.Controller;
import org.jfugue.Instrument;
import org.jfugue.JFugueDefinitions;
import org.jfugue.JFugueElement;
import org.jfugue.JFugueException;
import org.jfugue.KeySignature;
import org.jfugue.Layer;
import org.jfugue.Measure;
import org.jfugue.Note;
import org.jfugue.Parser;
import org.jfugue.ParserListenerAdapter;
import org.jfugue.Pattern;
import org.jfugue.PitchBend;
import org.jfugue.PolyphonicPressure;
import org.jfugue.Tempo;
import org.jfugue.Time;
import org.jfugue.Voice;

public final class MusicStringParser
extends Parser {
    private Map<String, Object> dictionaryMap = new HashMap<String, Object>();
    private byte keySig = 0;

    public MusicStringParser() {
        JFugueDefinitions.populateDictionary(this.dictionaryMap);
    }

    public void parse(Pattern pattern) throws JFugueException {
        String[] tokens = pattern.getTokens();
        if (tokens.length > 0 && tokens[0].toUpperCase().charAt(0) != 'T') {
            this.parseTempoElement("T120");
        }
        int counter = 0;
        int t = 0;
        while (t < tokens.length) {
            this.parseToken(tokens[t]);
            this.fireProgressReported("Parsing music string...", ++counter, tokens.length);
            ++t;
        }
    }

    private void parseToken(String s) throws JFugueException {
        if (s.indexOf(" ") != -1) {
            throw new JFugueException("The token * sent to Parser.parse() contains spaces.  A token is one unit of musical data, and should not contain a space.", s, s);
        }
        s = s.toUpperCase();
        this.trace("--------Processing Token: ", s);
        switch (s.charAt(0)) {
            case 'V': {
                this.parseVoiceElement(s);
                break;
            }
            case 'T': {
                this.parseTempoElement(s);
                break;
            }
            case 'I': {
                this.parseInstrumentElement(s);
                break;
            }
            case 'L': {
                this.parseLayerElement(s);
                break;
            }
            case 'K': {
                this.parseKeySignatureElement(s);
                break;
            }
            case 'X': {
                this.parseControllerElement(s);
                break;
            }
            case '@': {
                this.parseTimeElement(s);
                break;
            }
            case '*': {
                this.parsePolyPressureElement(s);
                break;
            }
            case '+': {
                this.parseChannelPressureElement(s);
                break;
            }
            case '&': {
                this.parsePitchBendElement(s);
                break;
            }
            case '|': {
                this.parseMeasureElement(s);
                break;
            }
            case '$': {
                this.parseDictionaryElement(s);
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'R': 
            case '[': {
                this.parseNoteElement(s);
                break;
            }
        }
    }

    private void parseVoiceElement(String s) throws JFugueException {
        String voiceNumberString = s.substring(1, s.length());
        byte voiceNumber = this.getByteFromDictionary(voiceNumberString);
        if (voiceNumber > 15) {
            return;
        }
        this.trace("Voice element: voice = ", voiceNumber);
        this.fireVoiceEvent(new Voice(voiceNumber));
    }

    private void parseTempoElement(String s) throws JFugueException {
        String tempoNumberString = s.substring(1, s.length());
        int tempoNumber = this.getIntFromDictionary(tempoNumberString);
        this.trace("Tempo element: tempo = ", tempoNumber);
        this.fireTempoEvent(new Tempo(tempoNumber));
    }

    private void parseInstrumentElement(String s) throws JFugueException {
        String instrumentNumberString = s.substring(1, s.length());
        byte instrumentNumber = this.getByteFromDictionary(instrumentNumberString);
        this.trace("Instrument element: instrument = ", instrumentNumber);
        this.fireInstrumentEvent(new Instrument(instrumentNumber));
    }

    private void parseLayerElement(String s) throws JFugueException {
        String layerNumberString = s.substring(1, s.length());
        byte layerNumber = this.getByteFromDictionary(layerNumberString);
        this.trace("Layer element: layer = ", layerNumber);
        this.fireLayerEvent(new Layer(layerNumber));
    }

    private void parseTimeElement(String s) throws JFugueException {
        String timeNumberString = s.substring(1, s.length());
        long timeNumber = this.getLongFromDictionary(timeNumberString);
        this.trace("Time element: time = ", timeNumber);
        this.fireTimeEvent(new Time(timeNumber));
    }

    private void parseKeySignatureElement(String s) throws JFugueException {
        String rootNote = null;
        String majOrMin = null;
        if (s.length() == 5) {
            rootNote = s.substring(1, 5);
            majOrMin = s.substring(2, 5);
        } else {
            rootNote = s.substring(1, 6);
            majOrMin = s.substring(3, 6);
        }
        this.trace("Key signature element: root=", rootNote, " majOrMin=", majOrMin);
        if (!majOrMin.equalsIgnoreCase("MAJ") && !majOrMin.equalsIgnoreCase("MIN")) {
            throw new JFugueException(" * is not a proper key signature; should be like KC#maj or KAbmin.", majOrMin, s);
        }
        int scale = majOrMin.equalsIgnoreCase("MAJ") ? 0 : 1;
        int keySig = 0;
        if (rootNote.equalsIgnoreCase("CBMAJ") || rootNote.equalsIgnoreCase("ABMIN")) {
            keySig = -7;
        } else if (rootNote.equalsIgnoreCase("GBMAJ") || rootNote.equalsIgnoreCase("EBMIN")) {
            keySig = -6;
        } else if (rootNote.equalsIgnoreCase("DBMAJ") || rootNote.equalsIgnoreCase("BBMIN")) {
            keySig = -5;
        } else if (rootNote.equalsIgnoreCase("ABMAJ") || rootNote.equalsIgnoreCase("FMIN")) {
            keySig = -4;
        } else if (rootNote.equalsIgnoreCase("EBMAJ") || rootNote.equalsIgnoreCase("CMIN")) {
            keySig = -3;
        } else if (rootNote.equalsIgnoreCase("BBMAJ") || rootNote.equalsIgnoreCase("GMIN")) {
            keySig = -2;
        } else if (rootNote.equalsIgnoreCase("FMAJ") || rootNote.equalsIgnoreCase("DMIN")) {
            keySig = -1;
        } else if (rootNote.equalsIgnoreCase("CMAJ") || rootNote.equalsIgnoreCase("AMIN")) {
            keySig = 0;
        } else if (rootNote.equalsIgnoreCase("GMAJ") || rootNote.equalsIgnoreCase("EMIN")) {
            keySig = 1;
        } else if (rootNote.equalsIgnoreCase("DMAJ") || rootNote.equalsIgnoreCase("BMIN")) {
            keySig = 2;
        } else if (rootNote.equalsIgnoreCase("AMAJ") || rootNote.equalsIgnoreCase("F#MIN")) {
            keySig = 3;
        } else if (rootNote.equalsIgnoreCase("EMAJ") || rootNote.equalsIgnoreCase("C#MIN")) {
            keySig = 4;
        } else if (rootNote.equalsIgnoreCase("BMAJ") || rootNote.equalsIgnoreCase("G#MIN")) {
            keySig = 5;
        } else if (rootNote.equalsIgnoreCase("F#MAJ") || rootNote.equalsIgnoreCase("D#MIN")) {
            keySig = 6;
        } else if (rootNote.equalsIgnoreCase("C#MAJ") || rootNote.equalsIgnoreCase("A#MIN")) {
            keySig = 7;
        } else {
            throw new JFugueException(" * is not a proper key signature; should be like KC#maj or KAbmin.", s);
        }
        this.trace("Key signature: sig=", keySig, " scale=", scale);
        this.fireKeySignatureEvent(new KeySignature((byte)keySig, (byte)scale));
        this.keySig = (byte)keySig;
    }

    private void parseMeasureElement(String s) throws JFugueException {
        this.trace("Measure element.");
        this.fireMeasureEvent(new Measure());
    }

    private void parseControllerElement(String s) throws JFugueException {
        int indexOfEquals = s.indexOf("=");
        if (-1 == indexOfEquals) {
            throw new JFugueException("The controller token * is missing an equals sign.  See the JFugue Instruction Manual for information on using the Controller token.", s, s);
        }
        String controlIndexString = s.substring(1, indexOfEquals);
        byte controlIndex = 0;
        int controlIndexInt = -1;
        try {
            controlIndex = this.getByteFromDictionary(controlIndexString);
        }
        catch (JFugueException e) {
            controlIndexInt = this.getIntFromDictionary(controlIndexString);
        }
        String controlValueString = s.substring(indexOfEquals + 1, s.length());
        if (-1 != controlIndexInt) {
            int controlValue = this.getIntFromDictionary(controlValueString);
            byte coarseIndex = (byte)(controlIndexInt / 128);
            byte fineIndex = (byte)(controlIndexInt % 128);
            if (16383 == controlValue) {
                coarseIndex = 0;
                fineIndex = 32;
            }
            byte coarseValue = (byte)(controlValue / 128);
            byte fineValue = (byte)(controlValue % 128);
            this.trace("Combined controller element: coarse-index = ", coarseIndex, ", coarse-value = ", coarseValue, "; fine-index = ", fineIndex, ", fine-value = ", fineValue);
            this.fireControllerEvent(new Controller(coarseIndex, coarseValue));
            this.fireControllerEvent(new Controller(fineIndex, fineValue));
        } else {
            byte controlValue = this.getByteFromDictionary(controlValueString);
            this.trace("Controller element: index = ", controlIndex, ", value = ", controlValue);
            this.fireControllerEvent(new Controller(controlIndex, controlValue));
        }
    }

    private void parseChannelPressureElement(String s) throws JFugueException {
        String pressureString = s.substring(1, s.length());
        byte pressureNumber = this.getByteFromDictionary(pressureString);
        this.trace("ChannelPressure element: pressure = ", pressureNumber);
        this.fireChannelPressureEvent(new ChannelPressure(pressureNumber));
    }

    private void parsePolyPressureElement(String s) throws JFugueException {
        String keyString = s.substring(1, s.indexOf(44));
        byte keyNumber = this.getByteFromDictionary(keyString);
        String pressureString = s.substring(s.indexOf(44) + 1, s.length());
        byte pressureNumber = this.getByteFromDictionary(pressureString);
        this.trace("PolyphonicPressure element: key = ", keyNumber, ", pressure = ", pressureNumber);
        this.firePolyphonicPressureEvent(new PolyphonicPressure(keyNumber, pressureNumber));
    }

    private void parsePitchBendElement(String s) throws JFugueException {
        byte lsb = 0;
        byte msb = 0;
        if (s.indexOf(44) > -1) {
            String b1String = s.substring(1, s.indexOf(44));
            lsb = this.getByteFromDictionary(b1String);
            String b2String = s.substring(s.indexOf(44) + 1, s.length());
            msb = this.getByteFromDictionary(b2String);
        } else {
            String valueString = s.substring(1, s.length());
            int value = this.getIntFromDictionary(valueString);
            lsb = (byte)(value % 128);
            msb = (byte)(value / 128);
        }
        this.trace("PitchBend element: byte1 = ", lsb, ", byte2 = ", msb);
        this.firePitchBendEvent(new PitchBend(lsb, msb));
    }

    private void parseDictionaryElement(String s) throws JFugueException {
        int indexOfEquals = s.indexOf("=");
        String word = s.substring(1, indexOfEquals);
        String definition = s.substring(indexOfEquals + 1, s.length());
        definition.replace('~', ' ');
        word = word.toUpperCase();
        this.trace("Dictionary Definition element: word = ", word, ", value = ", definition);
        this.dictionaryMap.put(word, definition);
    }

    private void parseNoteElement(String s) throws JFugueException {
        NoteContext context = new NoteContext();
        while (context.existAnotherNote) {
            this.trace("--Parsing note from token " + s);
            this.decideSequentialOrParallel(context);
            int index = 0;
            int slen = s.length();
            index = this.parseNoteRoot(s, slen, index, context);
            index = this.parseNoteOctave(s, slen, index, context);
            index = this.parseNoteChord(s, slen, index, context);
            this.computeNoteValue(context);
            index = this.parseNoteChordInversion(s, slen, index, context);
            index = this.parseNoteDuration(s, slen, index, context);
            index = this.parseNoteVelocity(s, slen, index, context);
            s = this.parseNoteConnector(s, slen, index, context);
            this.fireNoteEvents(context);
        }
    }

    private void decideSequentialOrParallel(NoteContext context) {
        context.isSequentialNote = false;
        if (context.anotherNoteIsSequential) {
            context.isSequentialNote = true;
            context.anotherNoteIsSequential = false;
            this.trace("This note is sequential");
        }
        context.isParallelNote = false;
        if (context.anotherNoteIsParallel) {
            context.isParallelNote = true;
            context.anotherNoteIsParallel = false;
            this.trace("This note is parallel");
        }
    }

    private int parseNoteRoot(String s, int slen, int index, NoteContext context) {
        switch (s.charAt(index)) {
            case '[': {
                return this.parseNumericNote(s, slen, index, context);
            }
            case 'R': {
                return this.parseRest(s, slen, index, context);
            }
        }
        return this.parseLetterNote(s, slen, index, context);
    }

    private int parseNumericNote(String s, int slen, int index, NoteContext context) {
        int indexOfEndBracket = s.indexOf(93, index);
        String stringInBrackets = s.substring(1, indexOfEndBracket);
        context.noteNumber = this.getByteFromDictionary(stringInBrackets);
        context.isNumericNote = true;
        this.trace("This note is a numeric note with value ", context.noteNumber);
        return indexOfEndBracket + 1;
    }

    private int parseRest(String s, int slen, int index, NoteContext context) {
        context.isRest = true;
        this.trace("This note is a Rest");
        return index + 1;
    }

    private int parseLetterNote(String s, int slen, int index, NoteContext context) {
        switch (s.charAt(index)) {
            case 'C': {
                context.noteNumber = 0;
                break;
            }
            case 'D': {
                context.noteNumber = (byte)2;
                break;
            }
            case 'E': {
                context.noteNumber = (byte)4;
                break;
            }
            case 'F': {
                context.noteNumber = (byte)5;
                break;
            }
            case 'G': {
                context.noteNumber = (byte)7;
                break;
            }
            case 'A': {
                context.noteNumber = (byte)9;
                break;
            }
            case 'B': {
                context.noteNumber = (byte)11;
                break;
            }
            default: {
                throw new JFugueException("Note * is not a valid drum sound name, or is not in the range 0 - 127.", s);
            }
        }
        ++index;
        boolean checkForModifiers = true;
        while (checkForModifiers) {
            if (index < slen) {
                switch (s.charAt(index)) {
                    case '#': {
                        ++index;
                        context.noteNumber = (byte)(context.noteNumber + 1);
                        break;
                    }
                    case 'B': {
                        ++index;
                        context.noteNumber = (byte)(context.noteNumber - 1);
                        break;
                    }
                    case 'N': {
                        ++index;
                        context.isNatural = true;
                        checkForModifiers = false;
                        break;
                    }
                    default: {
                        checkForModifiers = false;
                        break;
                    }
                }
                continue;
            }
            checkForModifiers = false;
        }
        this.trace("Note number within an octave (C=0, B=11): ", context.noteNumber);
        return index;
    }

    private int parseNoteOctave(String s, int slen, int index, NoteContext context) {
        if (context.isRest || context.isNumericNote) {
            return index;
        }
        int possibleOctave1 = 46;
        int possibleOctave2 = 46;
        if (index < slen) {
            possibleOctave1 = s.charAt(index);
        }
        if (index + 1 < slen) {
            possibleOctave2 = s.charAt(index + 1);
        }
        int definiteOctaveLength = 0;
        if (possibleOctave1 >= 48 && possibleOctave1 <= 57) {
            definiteOctaveLength = 1;
            if (possibleOctave2 >= 48 && possibleOctave2 <= 57) {
                definiteOctaveLength = 2;
            }
            String octaveNumberString = s.substring(index, index + definiteOctaveLength);
            try {
                context.octaveNumber = Byte.parseByte(octaveNumberString);
            }
            catch (NumberFormatException e) {
                throw new JFugueException("Octave * is not a number, or is not in the range 0 - 10.", octaveNumberString, s);
            }
            if (context.octaveNumber > 10) {
                throw new JFugueException("Octave * is not a number, or is not in the range 0 - 10.", octaveNumberString, s);
            }
        }
        return index + definiteOctaveLength;
    }

    private int parseNoteChord(String s, int slen, int index, NoteContext context) {
        if (context.isRest) {
            return index;
        }
        String possibleChord3 = null;
        String possibleChord4 = null;
        String possibleChord5 = null;
        String possibleChord6 = null;
        String possibleChord7 = null;
        String possibleChord8 = null;
        try {
            possibleChord3 = s.substring(index, index + 3);
            possibleChord4 = s.substring(index, index + 4);
            possibleChord5 = s.substring(index, index + 5);
            possibleChord6 = s.substring(index, index + 6);
            possibleChord7 = s.substring(index, index + 7);
            possibleChord8 = s.substring(index, index + 8);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int lengthOfChordString = 0;
        if (possibleChord3 != null) {
            if (possibleChord3.equals("MAJ")) {
                lengthOfChordString = 3;
                context.numHalfsteps = (byte)2;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 7;
            } else if (possibleChord3.equals("MIN")) {
                lengthOfChordString = 3;
                context.numHalfsteps = (byte)2;
                context.halfsteps[0] = 3;
                context.halfsteps[1] = 7;
            } else if (possibleChord3.equals("AUG")) {
                lengthOfChordString = 3;
                context.numHalfsteps = (byte)2;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 8;
            } else if (possibleChord3.equals("DIM")) {
                lengthOfChordString = 3;
                context.numHalfsteps = (byte)2;
                context.halfsteps[0] = 3;
                context.halfsteps[1] = 6;
            }
        }
        if (possibleChord4 != null) {
            if (possibleChord4.equalsIgnoreCase("DOM7")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 7;
                context.halfsteps[2] = 10;
            } else if (possibleChord4.equalsIgnoreCase("MAJ7")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 7;
                context.halfsteps[2] = 11;
            } else if (possibleChord4.equalsIgnoreCase("MIN7")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 3;
                context.halfsteps[1] = 7;
                context.halfsteps[2] = 10;
            } else if (possibleChord4.equalsIgnoreCase("SUS4")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)2;
                context.halfsteps[0] = 5;
                context.halfsteps[1] = 7;
            } else if (possibleChord4.equalsIgnoreCase("SUS2")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)2;
                context.halfsteps[0] = 2;
                context.halfsteps[1] = 7;
            } else if (possibleChord4.equalsIgnoreCase("MAJ6")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 7;
                context.halfsteps[2] = 9;
            } else if (possibleChord4.equalsIgnoreCase("MIN6")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 3;
                context.halfsteps[1] = 7;
                context.halfsteps[2] = 9;
            } else if (possibleChord4.equalsIgnoreCase("DOM9")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)4;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 7;
                context.halfsteps[2] = 10;
                context.halfsteps[3] = 14;
            } else if (possibleChord4.equalsIgnoreCase("MAJ9")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)4;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 7;
                context.halfsteps[2] = 11;
                context.halfsteps[3] = 14;
            } else if (possibleChord4.equalsIgnoreCase("MIN9")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)4;
                context.halfsteps[0] = 3;
                context.halfsteps[1] = 7;
                context.halfsteps[2] = 10;
                context.halfsteps[3] = 14;
            } else if (possibleChord4.equalsIgnoreCase("DIM7")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 3;
                context.halfsteps[1] = 6;
                context.halfsteps[2] = 9;
            } else if (possibleChord4.equalsIgnoreCase("ADD9")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 7;
                context.halfsteps[2] = 14;
            } else if (possibleChord4.equalsIgnoreCase("DAVE")) {
                lengthOfChordString = 4;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 7;
                context.halfsteps[1] = 14;
                context.halfsteps[2] = 21;
            }
        }
        if (possibleChord5 != null) {
            if (possibleChord5.equalsIgnoreCase("MIN11")) {
                lengthOfChordString = 5;
                context.numHalfsteps = (byte)5;
                context.halfsteps[0] = 7;
                context.halfsteps[1] = 10;
                context.halfsteps[2] = 14;
                context.halfsteps[3] = 15;
                context.halfsteps[4] = 17;
            } else if (possibleChord5.equalsIgnoreCase("DOM11")) {
                lengthOfChordString = 5;
                context.numHalfsteps = (byte)4;
                context.halfsteps[0] = 7;
                context.halfsteps[1] = 10;
                context.halfsteps[2] = 14;
                context.halfsteps[3] = 17;
            } else if (possibleChord5.equalsIgnoreCase("DOM13")) {
                lengthOfChordString = 5;
                context.numHalfsteps = (byte)5;
                context.halfsteps[0] = 7;
                context.halfsteps[1] = 10;
                context.halfsteps[2] = 14;
                context.halfsteps[3] = 16;
                context.halfsteps[4] = 21;
            } else if (possibleChord5.equalsIgnoreCase("MIN13")) {
                lengthOfChordString = 5;
                context.numHalfsteps = (byte)5;
                context.halfsteps[0] = 7;
                context.halfsteps[1] = 10;
                context.halfsteps[2] = 14;
                context.halfsteps[3] = 15;
                context.halfsteps[4] = 21;
            } else if (possibleChord5.equalsIgnoreCase("MAJ13")) {
                lengthOfChordString = 5;
                context.numHalfsteps = (byte)5;
                context.halfsteps[0] = 7;
                context.halfsteps[1] = 11;
                context.halfsteps[2] = 14;
                context.halfsteps[3] = 16;
                context.halfsteps[4] = 21;
            }
        }
        if (possibleChord6 != null) {
            if (possibleChord6.equalsIgnoreCase("DOM7<5")) {
                lengthOfChordString = 6;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 6;
                context.halfsteps[2] = 10;
            } else if (possibleChord6.equalsIgnoreCase("DOM7>5")) {
                lengthOfChordString = 6;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 8;
                context.halfsteps[2] = 10;
            } else if (possibleChord6.equalsIgnoreCase("MAJ7<5")) {
                lengthOfChordString = 6;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 6;
                context.halfsteps[2] = 11;
            } else if (possibleChord6.equalsIgnoreCase("MAJ7>5")) {
                lengthOfChordString = 6;
                context.numHalfsteps = (byte)3;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 8;
                context.halfsteps[2] = 11;
            }
        }
        if (possibleChord7 != null && possibleChord7.equalsIgnoreCase("minmaj7")) {
            lengthOfChordString = 7;
            context.numHalfsteps = (byte)3;
            context.halfsteps[0] = 3;
            context.halfsteps[1] = 7;
            context.halfsteps[2] = 11;
        }
        if (possibleChord8 != null) {
            if (possibleChord8.equalsIgnoreCase("DOM7<5<9")) {
                lengthOfChordString = 8;
                context.numHalfsteps = (byte)4;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 6;
                context.halfsteps[2] = 10;
                context.halfsteps[3] = 13;
            } else if (possibleChord8.equalsIgnoreCase("DOM7<5>9")) {
                lengthOfChordString = 8;
                context.numHalfsteps = (byte)4;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 6;
                context.halfsteps[2] = 10;
                context.halfsteps[3] = 15;
            } else if (possibleChord8.equalsIgnoreCase("DOM7>5<9")) {
                lengthOfChordString = 8;
                context.numHalfsteps = (byte)4;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 8;
                context.halfsteps[2] = 10;
                context.halfsteps[3] = 13;
            } else if (possibleChord8.equalsIgnoreCase("DOM7>5>9")) {
                lengthOfChordString = 8;
                context.numHalfsteps = (byte)4;
                context.halfsteps[0] = 4;
                context.halfsteps[1] = 8;
                context.halfsteps[2] = 10;
                context.halfsteps[3] = 15;
            }
        }
        if (lengthOfChordString > 0) {
            context.isChord = true;
            this.trace("Chord: chordLength=", lengthOfChordString, ", so chord is one of the following: [ 3=", possibleChord3, " 4=", possibleChord4, " 5=", possibleChord5, " 6=", possibleChord6, " 7=", possibleChord7, " 8=", possibleChord8, " ]");
        }
        return index + lengthOfChordString;
    }

    private void computeNoteValue(NoteContext context) {
        if (context.isRest) {
            return;
        }
        if (context.octaveNumber == 0 && !context.isNumericNote) {
            context.octaveNumber = context.isChord ? 3 : 5;
        }
        this.trace("Octave: ", context.octaveNumber);
        if (this.keySig != 0 && !context.isNatural) {
            if (this.keySig <= -1 && context.noteNumber == 11) {
                context.noteNumber = (byte)10;
            }
            if (this.keySig <= -2 && context.noteNumber == 4) {
                context.noteNumber = (byte)3;
            }
            if (this.keySig <= -3 && context.noteNumber == 9) {
                context.noteNumber = (byte)8;
            }
            if (this.keySig <= -4 && context.noteNumber == 2) {
                context.noteNumber = 1;
            }
            if (this.keySig <= -5 && context.noteNumber == 7) {
                context.noteNumber = (byte)6;
            }
            if (this.keySig <= -6 && context.noteNumber == 0) {
                context.noteNumber = (byte)11;
                --context.octaveNumber;
            }
            if (this.keySig <= -7 && context.noteNumber == 5) {
                context.noteNumber = (byte)4;
            }
            if (this.keySig >= 1 && context.noteNumber == 5) {
                context.noteNumber = (byte)6;
            }
            if (this.keySig >= 2 && context.noteNumber == 0) {
                context.noteNumber = 1;
            }
            if (this.keySig >= 3 && context.noteNumber == 7) {
                context.noteNumber = (byte)8;
            }
            if (this.keySig >= 4 && context.noteNumber == 2) {
                context.noteNumber = (byte)3;
            }
            if (this.keySig >= 5 && context.noteNumber == 9) {
                context.noteNumber = (byte)10;
            }
            if (this.keySig >= 6 && context.noteNumber == 4) {
                context.noteNumber = (byte)5;
            }
            if (this.keySig >= 7 && context.noteNumber == 11) {
                context.noteNumber = 0;
                ++context.octaveNumber;
            }
            this.trace("After adjusting for Key Signature, noteNumber=", context.noteNumber, " octave=", context.octaveNumber);
        }
        if (!context.isNumericNote) {
            int intNoteNumber = context.octaveNumber * 12 + context.noteNumber;
            if (intNoteNumber > 127) {
                throw new JFugueException("The note value *, calculated by computing (octave*12)+noteValue, is not in the range 0 - 127.", Integer.toString(intNoteNumber), "");
            }
            context.noteNumber = (byte)intNoteNumber;
            this.trace("Computed note number: ", context.noteNumber);
        }
    }

    private int parseNoteChordInversion(String s, int slen, int index, NoteContext context) {
        block36: {
            int i;
            if (!context.isChord) {
                return index;
            }
            int inversionCount = 0;
            int inversionRootNote = -1;
            int inversionOctave = -1;
            boolean checkForInversion = true;
            while (checkForInversion) {
                if (index < slen) {
                    switch (s.charAt(index)) {
                        case '^': {
                            ++index;
                            ++inversionCount;
                            break;
                        }
                        case 'C': {
                            ++index;
                            inversionRootNote = 0;
                            break;
                        }
                        case 'D': {
                            ++index;
                            inversionRootNote = 2;
                            break;
                        }
                        case 'E': {
                            ++index;
                            inversionRootNote = 4;
                            break;
                        }
                        case 'F': {
                            ++index;
                            inversionRootNote = 5;
                            break;
                        }
                        case 'G': {
                            ++index;
                            inversionRootNote = 7;
                            break;
                        }
                        case 'A': {
                            ++index;
                            inversionRootNote = 9;
                            break;
                        }
                        case 'B': {
                            ++index;
                            if (inversionRootNote == -1) {
                                inversionRootNote = 11;
                                break;
                            }
                            --inversionRootNote;
                            break;
                        }
                        case '#': {
                            ++index;
                            ++inversionRootNote;
                            break;
                        }
                        case '0': {
                            ++index;
                            if (inversionOctave == -1) {
                                inversionOctave = 0;
                                break;
                            }
                            inversionOctave *= 10;
                            break;
                        }
                        case '1': {
                            ++index;
                            inversionOctave = 1;
                            break;
                        }
                        case '2': {
                            ++index;
                            inversionOctave = 2;
                            break;
                        }
                        case '3': {
                            ++index;
                            inversionOctave = 3;
                            break;
                        }
                        case '4': {
                            ++index;
                            inversionOctave = 4;
                            break;
                        }
                        case '5': {
                            ++index;
                            inversionOctave = 5;
                            break;
                        }
                        case '6': {
                            ++index;
                            inversionOctave = 6;
                            break;
                        }
                        case '7': {
                            ++index;
                            inversionOctave = 7;
                            break;
                        }
                        case '8': {
                            ++index;
                            inversionOctave = 8;
                            break;
                        }
                        case '9': {
                            ++index;
                            inversionOctave = 9;
                            break;
                        }
                        case '[': {
                            int indexEndBracket = s.indexOf(93, index);
                            inversionRootNote = Integer.parseInt(s.substring(index + 1, indexEndBracket - 1));
                            index = indexEndBracket + 1;
                            break;
                        }
                        default: {
                            checkForInversion = false;
                            break;
                        }
                    }
                    continue;
                }
                checkForInversion = false;
            }
            if (inversionCount <= 0) break block36;
            if (inversionRootNote == -1) {
                this.trace("Inversion is base on count: " + inversionCount);
                this.trace("Inverting " + context.noteNumber + " to be " + (context.noteNumber + 12));
                context.noteNumber = (byte)(context.noteNumber + 12);
                i = inversionCount - 1;
                while (i < context.numHalfsteps) {
                    this.trace("Inverting " + context.halfsteps[i] + " to be " + (context.halfsteps[i] - 12));
                    int n = i++;
                    context.halfsteps[n] = (byte)(context.halfsteps[n] - 12);
                }
            } else {
                if (inversionOctave != -1) {
                    inversionRootNote += inversionOctave * 12;
                } else if (inversionRootNote < 12) {
                    int currentOctave = context.noteNumber / 12;
                    inversionRootNote += currentOctave * 12;
                }
                this.trace("Inversion is base on note: " + inversionRootNote);
                if (inversionRootNote > context.noteNumber + context.halfsteps[context.numHalfsteps - 1] || inversionRootNote < context.noteNumber) {
                    throw new JFugueException("The root given for a chord inversion is less than the initial chord root, or greater than the range of the chord.");
                }
                this.trace("Inverting " + context.noteNumber + " to be " + (context.noteNumber + 12));
                context.noteNumber = (byte)(context.noteNumber + 12);
                i = 0;
                while (i < context.numHalfsteps) {
                    if (context.noteNumber + context.halfsteps[i] >= inversionRootNote + 12) {
                        this.trace("Inverting " + context.halfsteps[i] + " to be " + (context.halfsteps[i] - 12));
                        int n = i;
                        context.halfsteps[n] = (byte)(context.halfsteps[n] - 12);
                    }
                    ++i;
                }
            }
        }
        return index;
    }

    private int parseNoteDuration(String s, int slen, int index, NoteContext context) {
        context.decimalDuration = 0.0;
        if (index < slen) {
            switch (s.charAt(index)) {
                case '/': {
                    index = this.parseNumericDuration(s, slen, index, context);
                    break;
                }
                case '-': 
                case 'H': 
                case 'I': 
                case 'O': 
                case 'Q': 
                case 'S': 
                case 'T': 
                case 'W': 
                case 'X': {
                    index = this.parseLetterDuration(s, slen, index, context);
                    break;
                }
            }
            index = this.parseTuplet(s, slen, index, context);
        } else {
            context.decimalDuration = 0.25;
        }
        context.duration = (long)(120.0 * context.decimalDuration);
        this.trace("Decimal duration is ", context.decimalDuration);
        this.trace("Actual duration is ", context.duration);
        return index;
    }

    private int parseLetterDuration(String s, int slen, int index, NoteContext context) {
        boolean durationExists = true;
        boolean isDotted = false;
        while (durationExists) {
            int durationNumber = 0;
            if (index < slen) {
                char durationChar = s.charAt(index);
                switch (durationChar) {
                    case '-': {
                        if (context.decimalDuration == 0.0 && !context.isEndOfTie) {
                            context.isEndOfTie = true;
                            this.trace("Note is end of tie");
                            break;
                        }
                        context.isStartOfTie = true;
                        this.trace("Note is start of tie");
                        break;
                    }
                    case 'W': {
                        durationNumber = 1;
                        break;
                    }
                    case 'H': {
                        durationNumber = 2;
                        break;
                    }
                    case 'Q': {
                        durationNumber = 4;
                        break;
                    }
                    case 'I': {
                        durationNumber = 8;
                        break;
                    }
                    case 'S': {
                        durationNumber = 16;
                        break;
                    }
                    case 'T': {
                        durationNumber = 32;
                        break;
                    }
                    case 'X': {
                        durationNumber = 64;
                        break;
                    }
                    case 'O': {
                        durationNumber = 128;
                        break;
                    }
                    default: {
                        --index;
                        durationExists = false;
                    }
                }
                if (++index < slen && s.charAt(index) == '.') {
                    isDotted = true;
                    ++index;
                }
                if (durationNumber <= 0) continue;
                double d = 1.0 / (double)durationNumber;
                if (isDotted) {
                    context.decimalDuration += d + d / 2.0;
                    continue;
                }
                context.decimalDuration += d;
                continue;
            }
            durationExists = false;
        }
        return index;
    }

    private int parseNumericDuration(String s, int slen, int index, NoteContext context) {
        if ('[' == s.charAt(++index)) {
            int indexOfEndingBracket = s.indexOf(93, index);
            context.decimalDuration += this.getDoubleFromDictionary(s.substring(index + 1, indexOfEndingBracket));
            index = indexOfEndingBracket + 1;
        } else {
            int endingIndex = index;
            boolean keepAdvancingPointer = true;
            while (keepAdvancingPointer) {
                try {
                    char numericDurationChar = s.charAt(endingIndex);
                    if (numericDurationChar >= '0' && numericDurationChar <= '9' || numericDurationChar == '.') {
                        ++endingIndex;
                        continue;
                    }
                    keepAdvancingPointer = false;
                }
                catch (IndexOutOfBoundsException e) {
                    keepAdvancingPointer = false;
                }
            }
            String durationNumberString = s.substring(index, endingIndex);
            context.decimalDuration += Double.parseDouble(durationNumberString);
            index = endingIndex;
        }
        this.trace("Decimal duration is ", context.decimalDuration);
        return index;
    }

    private int parseTuplet(String s, int slen, int index, NoteContext context) {
        if (index < slen && s.charAt(index) == '*') {
            this.trace("Note is a tuplet");
            ++index;
            boolean stopTupletParsing = false;
            int indexOfUnitsToMatch = 0;
            int indexOfNumNotes = 0;
            int counter = -1;
            while (!stopTupletParsing) {
                if (slen > index + ++counter) {
                    if (s.charAt(index + counter) == ':') {
                        indexOfNumNotes = index + counter + 1;
                        continue;
                    }
                    if (s.charAt(index + counter) >= '0' && s.charAt(index + counter) <= '9') {
                        if (indexOfUnitsToMatch != 0) continue;
                        indexOfUnitsToMatch = index + counter;
                        continue;
                    }
                    if (s.charAt(index + counter) == '*') continue;
                    stopTupletParsing = true;
                    continue;
                }
                stopTupletParsing = true;
            }
            index += counter;
            double numerator = 2.0;
            double denominator = 3.0;
            if (indexOfUnitsToMatch > 0 && indexOfNumNotes > 0) {
                numerator = Double.parseDouble(s.substring(indexOfUnitsToMatch, indexOfNumNotes - 1));
                denominator = Double.parseDouble(s.substring(indexOfNumNotes, index));
            }
            this.trace("Tuplet ratio is " + numerator + ":" + denominator);
            double tupletRatio = numerator / denominator;
            context.decimalDuration *= tupletRatio;
            this.trace("Decimal duration after tuplet is ", context.decimalDuration);
        }
        return index;
    }

    /*
     * Unable to fully structure code
     */
    private int parseNoteVelocity(String s, int slen, int index, NoteContext context) {
        if (!context.isRest) ** GOTO lbl30
        return index;
lbl-1000:
        // 1 sources

        {
            endPoint = startPoint = index + 1;
            velocityChar = s.charAt(index);
            lengthOfByte = 0;
            if (velocityChar == '+' || velocityChar == '_') break;
            this.trace(new Object[]{"Identified Velocity character ", Character.valueOf(velocityChar)});
            byteDone = false;
            while (!byteDone && index + lengthOfByte + 1 < slen) {
                possibleByteChar = s.charAt(index + lengthOfByte + 1);
                if (possibleByteChar >= '0' && possibleByteChar <= '9') {
                    ++lengthOfByte;
                    continue;
                }
                byteDone = true;
            }
            endPoint = index + lengthOfByte + 1;
            if (index + 1 < slen && s.charAt(index + 1) == '[') {
                endPoint = s.indexOf(93, startPoint) + 1;
            }
            velocityNumber = this.getByteFromDictionary(s.substring(startPoint, endPoint));
            switch (velocityChar) {
                case 'A': {
                    context.attackVelocity = velocityNumber;
                    break;
                }
                case 'D': {
                    context.decayVelocity = velocityNumber;
                    break;
                }
                default: {
                    throw new JFugueException("The velocity character in * is unknown.", s.substring(startPoint, endPoint), s);
                }
            }
            index = endPoint;
lbl30:
            // 2 sources

            ** while (index < slen)
        }
lbl31:
        // 2 sources

        this.trace(new Object[]{"Attack velocity = ", context.attackVelocity, "; Decay velocity = ", context.decayVelocity});
        return index;
    }

    private String parseNoteConnector(String s, int slen, int index, NoteContext context) {
        context.existAnotherNote = false;
        if (index < slen && (s.charAt(index) == '+' || s.charAt(index) == '_')) {
            this.trace("Another note: string = ", s.substring(index, s.length() - 1));
            if (s.charAt(index) == '_') {
                context.anotherNoteIsSequential = true;
                this.trace("Next note will be sequential");
            } else {
                context.anotherNoteIsParallel = true;
                this.trace("Next note will be parallel");
            }
            context.existAnotherNote = true;
            return s.substring(++index, slen);
        }
        return null;
    }

    private void fireNoteEvents(NoteContext context) {
        Note note = new Note();
        if (context.isRest) {
            note.setRest(true);
            note.setDuration(context.duration);
            note.setDecimalDuration(context.decimalDuration);
            note.setAttackVelocity((byte)0);
            note.setDecayVelocity((byte)0);
        } else {
            note.setValue(context.noteNumber);
            note.setDuration(context.duration);
            note.setStartOfTie(context.isStartOfTie);
            note.setEndOfTie(context.isEndOfTie);
            note.setDecimalDuration(context.decimalDuration);
            note.setAttackVelocity(context.attackVelocity);
            note.setDecayVelocity(context.decayVelocity);
        }
        note.setHasAccompanyingNotes(context.existAnotherNote || context.isChord);
        if (context.isFirstNote) {
            note.setType((byte)0);
            this.trace("Firing first note event");
            this.fireNoteEvent(note);
        } else if (context.isSequentialNote) {
            note.setType((byte)1);
            this.trace("Firing sequential note event");
            this.fireSequentialNoteEvent(note);
        } else if (context.isParallelNote) {
            note.setType((byte)2);
            this.trace("Firing parallel note event");
            this.fireParallelNoteEvent(note);
        }
        if (context.isChord) {
            int i = 0;
            while (i < context.numHalfsteps) {
                Note chordNote = new Note((byte)(context.noteNumber + context.halfsteps[i]), context.duration);
                chordNote.setDecimalDuration(context.decimalDuration);
                chordNote.setType((byte)2);
                this.trace("Chord note number: ", context.noteNumber + context.halfsteps[i]);
                if (i == context.numHalfsteps - 1) {
                    chordNote.setHasAccompanyingNotes(context.existAnotherNote);
                } else {
                    chordNote.setHasAccompanyingNotes(context.existAnotherNote || context.isChord);
                }
                this.fireParallelNoteEvent(chordNote);
                ++i;
            }
        }
        context.isFirstNote = false;
    }

    private String dictionaryLookup(String bracketedString) throws JFugueException {
        int indexOfOpeningBracket = bracketedString.indexOf("[");
        int indexOfClosingBracket = bracketedString.indexOf("]");
        String word = null;
        word = indexOfOpeningBracket != -1 && indexOfClosingBracket != -1 ? bracketedString.substring(indexOfOpeningBracket + 1, indexOfClosingBracket) : bracketedString;
        word = word.toUpperCase();
        String definition = (String)this.dictionaryMap.get(word);
        while (definition != null && this.dictionaryMap.containsKey(definition.toUpperCase())) {
            definition = (String)this.dictionaryMap.get(definition.toUpperCase());
        }
        if (definition == null) {
            char ch = '\u0000';
            boolean isNumber = true;
            int i = 0;
            while (i < word.length()) {
                ch = word.charAt(i);
                if (!Character.isDigit(ch) && ch != '.') {
                    isNumber = false;
                }
                ++i;
            }
            if (isNumber) {
                this.trace("Dictionary lookup returning the number ", word);
                return word;
            }
            throw new JFugueException("The word * has no definition.  Check the spelling, or define the word before using it.  See the JFugue Instruction Manual for information on defining words.", word, bracketedString);
        }
        this.trace("Word ", word, " is defined as ", definition);
        return definition;
    }

    private byte getByteFromDictionary(String bracketedString) throws JFugueException {
        String definition = this.dictionaryLookup(bracketedString);
        Byte newbyte = null;
        try {
            newbyte = new Byte(definition);
        }
        catch (NumberFormatException e) {
            throw new JFugueException("The JFugue Parser expected a byte, but encountered the value * which is not a byte.", definition, bracketedString);
        }
        return newbyte;
    }

    private long getLongFromDictionary(String bracketedString) throws JFugueException {
        String definition = this.dictionaryLookup(bracketedString);
        Long newlong = null;
        try {
            newlong = new Long(definition);
        }
        catch (NumberFormatException e) {
            throw new JFugueException("The JFugue Parser expected a long, but encountered the value * which is not a long.", definition, bracketedString);
        }
        return newlong;
    }

    private int getIntFromDictionary(String bracketedString) throws JFugueException {
        String definition = this.dictionaryLookup(bracketedString);
        Integer newint = null;
        try {
            newint = new Integer(definition);
        }
        catch (NumberFormatException e) {
            throw new JFugueException("The JFugue Parser expected an int, but encountered the value * which is not an int.", definition, bracketedString);
        }
        return newint;
    }

    private double getDoubleFromDictionary(String bracketedString) throws JFugueException {
        String definition = this.dictionaryLookup(bracketedString);
        Double newdouble = null;
        try {
            newdouble = new Double(definition);
        }
        catch (NumberFormatException e) {
            throw new JFugueException("The JFugue Parser expected a double, but encountered the value * which is not a double.", definition, bracketedString);
        }
        return newdouble;
    }

    public boolean isValidToken(String token) {
        boolean valid = true;
        try {
            this.parseToken(token);
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    public void verifyToken(String token, final String verifyString) {
        CollatedParserListener listener = new CollatedParserListener(){
            private StringBuilder results = new StringBuilder();

            public void jfugueEvent(JFugueElement e) {
                this.results.append(e.getVerifyString());
                if (!verifyString.startsWith(this.results.toString())) {
                    throw new JFugueException("The result of parsing, '*', was not expected.", this.results.toString(), verifyString);
                }
                this.results.append("; ");
            }
        };
        this.addParserListener(listener);
        this.parseToken(token);
        this.removeParserListener(listener);
    }

    public static Note getNote(String string) {
        return MusicStringParser.getNote(new Pattern(string));
    }

    public static Note getNote(Pattern pattern) {
        final Note rootNote = new Note();
        MusicStringParser parser = new MusicStringParser();
        ParserListenerAdapter renderer = new ParserListenerAdapter(){

            public void noteEvent(Note note) {
                rootNote.setValue(note.getValue());
                rootNote.setDuration(note.getDuration());
                rootNote.setDecimalDuration(note.getDecimalDuration());
                rootNote.setStartOfTie(note.isStartOfTie());
                rootNote.setEndOfTie(note.isEndOfTie());
                rootNote.setAttackVelocity(note.getAttackVelocity());
                rootNote.setDecayVelocity(note.getDecayVelocity());
                rootNote.setRest(note.isRest());
            }
        };
        parser.addParserListener(renderer);
        parser.parse(pattern);
        return rootNote;
    }

    public static void main(String[] args) {
        MusicStringParser.verifyTokenParsing();
    }

    private static void verifyTokenParsing() {
        MusicStringParser parser = new MusicStringParser();
        parser.setTracing(1);
        try {
            long startTime = System.currentTimeMillis();
            parser.verifyToken("C", Note.createVerifyString(60, 0.25));
            parser.verifyToken("C3", Note.createVerifyString(36, 0.25));
            parser.verifyToken("Cb3", Note.createVerifyString(35, 0.25));
            parser.verifyToken("B#3", Note.createVerifyString(48, 0.25));
            parser.verifyToken("C#3q", Note.createVerifyString(37, 0.25));
            parser.verifyToken("C3i", Note.createVerifyString(36, 0.125));
            parser.verifyToken("C3qh", Note.createVerifyString(36, 0.75));
            parser.verifyToken("C5minw", Note.createCompoundVerifyString(Note.createVerifyString(60, 1.0), Note.createVerifyString(63, 1.0, false, true, false), Note.createVerifyString(67, 1.0, false, true, false)));
            parser.verifyToken("Cmaj", Note.createCompoundVerifyString(Note.createVerifyString(36, 0.25), Note.createVerifyString(40, 0.25, false, true, false), Note.createVerifyString(43, 0.25, false, true, false)));
            parser.parseToken("Cdom9");
            parser.parseToken("Cmin11");
            parser.parseToken("Cdom7<5");
            parser.parseToken("Cminmaj7");
            parser.parseToken("Cdom7<5<9");
            parser.parseToken("Cwhqistxo");
            parser.parseToken("C10");
            parser.parseToken("V0");
            parser.parseToken("V15");
            parser.parseToken("I0");
            parser.parseToken("I[13]");
            parser.parseToken("I[Acoustic_Grand]");
            parser.parseToken("IFlute");
            parser.parseToken("Cmaj7W");
            parser.parseToken("C#5Q");
            parser.parseToken("eb3Q.");
            parser.parseToken("[Cowbell]O");
            parser.parseToken("P50");
            parser.parseToken("A");
            parser.parseToken("A+B+C");
            parser.parseToken("A_B_C");
            parser.parseToken("RW");
            parser.parseToken("[105]X");
            parser.parseToken("[105]Xa20+[98]X+[78]X");
            parser.parseToken("AW+[18]X+[cabasa]Q+Dmin");
            parser.parseToken("A/0.25");
            parser.parseToken("[70]o");
            parser.parseToken("$UKELE=72");
            parser.parseToken("IUKELE");
            parser.parseToken("$Volume=43");
            parser.parseToken("X[Volume]=10");
            parser.parseToken("X[PORTAMENTO_TIME]=777");
            parser.parseToken("XVolume=ON");
            parser.parseToken("[Ukele]q");
            parser.parseToken("$number1=1");
            parser.parseToken("$quarter=0.25");
            parser.parseToken("C4/[quarter]");
            parser.parseToken("C4q");
            parser.parseToken("[Number1]/[Quarter]");
            parser.parseToken("Cb4qa45");
            parser.parseToken("Gb4qd67");
            parser.parseToken("F#4qa55d77");
            parser.parseToken("B4qa[Volume]d[Number1]");
            parser.parseToken("L8");
            parser.parseToken("$number1=1");
            parser.parseToken("L[Number1]");
            parser.parseToken("@100002");
            parser.parseToken("|");
            parser.parseToken("Cq-");
            parser.parseToken("C5q-");
            parser.parseToken("C5q.-");
            parser.parseToken("C5qh-");
            parser.parseToken("C-q");
            parser.parseToken("C5-q");
            parser.parseToken("C5-q.");
            parser.parseToken("C5-qh");
            parser.parseToken("C-q-");
            parser.parseToken("C--");
            parser.parseToken("&100,50");
            parser.parseToken("&512");
            parser.parseToken("$number110=110");
            parser.parseToken("&[number110],50");
            parser.parseToken("&[number110],[number110]");
            parser.parseToken("$number1010=1010");
            parser.parseToken("&[number1010]");
            parser.parseToken("+100");
            parser.parseToken("$number110=110");
            parser.parseToken("+[number110]");
            parser.parseToken("+[number110]");
            parser.parseToken("*100,20");
            parser.parseToken("$number110=110");
            parser.parseToken("*[number110],50");
            parser.parseToken("*[number110],[number110]");
            parser.parseToken("Cmaj");
            parser.parseToken("C7maj");
            parser.parseToken("C7maj^");
            parser.parseToken("C7maj^^");
            parser.parseToken("C7maj^^^");
            parser.parseToken("C7maj^E");
            parser.parseToken("C7maj^G");
            parser.parseToken("C7maj^E7");
            parser.parseToken("C7maj^G7");
            parser.parseToken("[60]maj^");
            parser.parseToken("[60]maj^^");
            parser.parseToken("[60]maj^^^");
            parser.parseToken("[60]maj^E");
            parser.parseToken("[60]maj^[67]");
            parser.parseToken("Bb6min13^^^^^^");
            parser.parseToken("Cq*");
            parser.parseToken("Ci*5:4");
            parser.parseToken("Cs.*7:8");
            parser.parseToken("Chx.*10:11");
            parser.parseToken("KC#maj");
            parser.parseToken("KAbmin");
            parser.parseToken("Cn");
            parser.parseToken("Cn6");
            parser.parseToken("D3");
            parser.parseToken("C##3");
            long endTime = System.currentTimeMillis();
            System.out.println("Time taken: " + (endTime - startTime) + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class NoteContext {
        boolean isRest = false;
        boolean isNumericNote = false;
        boolean isChord = false;
        boolean isFirstNote = true;
        boolean isSequentialNote = false;
        boolean isParallelNote = false;
        boolean isNatural = false;
        boolean existAnotherNote = true;
        boolean anotherNoteIsSequential = false;
        boolean anotherNoteIsParallel = false;
        boolean isStartOfTie = false;
        boolean isEndOfTie = false;
        byte[] halfsteps = new byte[5];
        byte numHalfsteps = 0;
        byte noteNumber = 0;
        int octaveNumber = 0;
        double decimalDuration = 0.0;
        long duration = 0L;
        byte attackVelocity = (byte)64;
        byte decayVelocity = (byte)64;

        public NoteContext() {
            int i = 0;
            while (i < 5) {
                this.halfsteps[i] = 0;
                ++i;
            }
        }
    }
}

