/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import javax.sound.midi.Sequence;
import org.jfugue.ChannelPressure;
import org.jfugue.Controller;
import org.jfugue.Instrument;
import org.jfugue.KeySignature;
import org.jfugue.Layer;
import org.jfugue.Measure;
import org.jfugue.MidiEventManager;
import org.jfugue.Note;
import org.jfugue.ParserListenerAdapter;
import org.jfugue.PitchBend;
import org.jfugue.PolyphonicPressure;
import org.jfugue.Tempo;
import org.jfugue.Time;
import org.jfugue.TimeFactor;
import org.jfugue.Voice;

public final class MidiRenderer
extends ParserListenerAdapter {
    private MidiEventManager eventManager;
    long initialNoteTime = 0L;
    private float sequenceTiming;
    private int resolution;

    public MidiRenderer(float sequenceTiming, int resolution) {
        this.reset(sequenceTiming, resolution);
    }

    public void reset(float sequenceTiming, int resolution) {
        this.sequenceTiming = sequenceTiming;
        this.resolution = resolution;
        this.eventManager = new MidiEventManager(sequenceTiming, resolution);
    }

    public void reset() {
        this.eventManager = new MidiEventManager(this.sequenceTiming, this.resolution);
    }

    public Sequence getSequence() {
        return this.eventManager.getSequence();
    }

    public void voiceEvent(Voice voice) {
        this.eventManager.setCurrentTrack(voice.getVoice());
    }

    public void tempoEvent(Tempo tempo) {
        byte[] threeTempoBytes = TimeFactor.convertToThreeTempoBytes(tempo.getTempo());
        this.eventManager.addMetaMessage(81, threeTempoBytes);
    }

    public void instrumentEvent(Instrument instrument) {
        this.eventManager.addEvent(192, instrument.getInstrument(), 0);
    }

    public void layerEvent(Layer layer) {
        this.eventManager.setCurrentLayer(layer.getLayer());
    }

    public void timeEvent(Time time) {
        this.eventManager.setTrackTimer(time.getTime());
    }

    public void measureEvent(Measure measure) {
    }

    public void keySignatureEvent(KeySignature keySig) {
        this.eventManager.addMetaMessage(89, new byte[]{keySig.getKeySig(), keySig.getScale()});
    }

    public void controllerEvent(Controller controller) {
        this.eventManager.addEvent(176, controller.getIndex(), controller.getValue());
    }

    public void channelPressureEvent(ChannelPressure channelPressure) {
        this.eventManager.addEvent(208, channelPressure.getPressure());
    }

    public void polyphonicPressureEvent(PolyphonicPressure polyphonicPressure) {
        this.eventManager.addEvent(160, polyphonicPressure.getKey(), polyphonicPressure.getPressure());
    }

    public void pitchBendEvent(PitchBend pitchBend) {
        this.eventManager.addEvent(224, pitchBend.getBend()[0], pitchBend.getBend()[1]);
    }

    public void noteEvent(Note note) {
        this.initialNoteTime = this.eventManager.getTrackTimer();
        long duration = note.getDuration();
        if (duration == 0L) {
            return;
        }
        if (note.isRest()) {
            this.eventManager.advanceTrackTimer(duration);
        } else {
            this.initialNoteTime = this.eventManager.getTrackTimer();
            byte attackVelocity = note.getAttackVelocity();
            byte decayVelocity = note.getDecayVelocity();
            this.eventManager.addNoteEvent(note.getValue(), attackVelocity, decayVelocity, duration, !note.isEndOfTie(), !note.isStartOfTie());
        }
    }

    public void sequentialNoteEvent(Note note) {
        long duration = note.getDuration();
        if (note.isRest()) {
            this.eventManager.advanceTrackTimer(duration);
        } else {
            byte attackVelocity = note.getAttackVelocity();
            byte decayVelocity = note.getDecayVelocity();
            this.eventManager.addNoteEvent(note.getValue(), attackVelocity, decayVelocity, duration, !note.isEndOfTie(), !note.isStartOfTie());
        }
    }

    public void parallelNoteEvent(Note note) {
        long duration = note.getDuration();
        this.eventManager.setTrackTimer(this.initialNoteTime);
        if (note.isRest()) {
            this.eventManager.advanceTrackTimer(duration);
        } else {
            byte attackVelocity = note.getAttackVelocity();
            byte decayVelocity = note.getDecayVelocity();
            this.eventManager.addNoteEvent(note.getValue(), attackVelocity, decayVelocity, duration, !note.isEndOfTie(), !note.isStartOfTie());
        }
    }
}

