/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import org.jfugue.JFugueException;
import org.jfugue.MusicStringParser;
import org.jfugue.Note;
import org.jfugue.Pattern;

public class IntervalNotation {
    private String musicStringWithIntervals;

    public IntervalNotation(String musicStringWithIntervals) {
        this.setMusicStringWithIntervals(musicStringWithIntervals);
    }

    public void setMusicStringWithIntervals(String musicStringWithIntervals) {
        this.musicStringWithIntervals = musicStringWithIntervals;
    }

    public String getMusicStringWithIntervals() {
        return this.musicStringWithIntervals;
    }

    public Pattern getPatternForRootNote(String musicString) {
        return this.getPatternForRootNote(new Pattern(musicString));
    }

    public Pattern getPatternForRootNote(Pattern pattern) {
        Note rootNote = MusicStringParser.getNote(pattern);
        return this.getPatternForRootNote(rootNote);
    }

    public Pattern getPatternForRootNote(Note rootNote) {
        StringBuilder buddy = new StringBuilder();
        String[] tokens = this.getMusicStringWithIntervals().split(" ");
        byte rootNoteValue = rootNote.getValue();
        int i = 0;
        while (i < tokens.length) {
            boolean leftAngleBracketExists;
            int lastAngleBracketPosition = -1;
            boolean bl = leftAngleBracketExists = tokens[i].indexOf(60) != -1;
            if (leftAngleBracketExists) {
                while (leftAngleBracketExists) {
                    int start = tokens[i].indexOf(60, lastAngleBracketPosition);
                    int end = tokens[i].indexOf(62, start);
                    String intervalString = tokens[i].substring(start + 1, end);
                    byte intervalValue = 0;
                    try {
                        intervalValue = Byte.valueOf(intervalString);
                    }
                    catch (NumberFormatException e) {
                        throw new JFugueException("The JFugue Parser expected a byte, but encountered the value * which is not a byte.", intervalString, tokens[i]);
                    }
                    buddy.append("[");
                    buddy.append(rootNoteValue + intervalValue - 1);
                    buddy.append("]");
                    lastAngleBracketPosition = end;
                    int nextLeftAngleBracketPosition = tokens[i].indexOf(60, lastAngleBracketPosition - 1);
                    if (nextLeftAngleBracketPosition == -1) {
                        buddy.append(tokens[i].substring(end + 1, tokens[i].length()));
                        leftAngleBracketExists = false;
                        continue;
                    }
                    buddy.append(tokens[i].substring(end + 1, nextLeftAngleBracketPosition));
                    leftAngleBracketExists = true;
                }
            } else {
                buddy.append(tokens[i]);
            }
            buddy.append(" ");
            ++i;
        }
        return new Pattern(buddy.toString());
    }
}

