/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import org.jfugue.IntelligentDeviceResolver;
import org.jfugue.JFugueException;
import org.jfugue.MidiMessageRecipient;
import org.jfugue.TimeFactor;

public class DeviceThatWillReceiveMidi {
    private MidiDevice device;
    private Receiver receiver;

    public DeviceThatWillReceiveMidi() throws MidiUnavailableException {
        this.device = IntelligentDeviceResolver.selectReceiverDevice();
        this.init();
    }

    public DeviceThatWillReceiveMidi(MidiDevice.Info info) throws MidiUnavailableException {
        this.device = MidiSystem.getMidiDevice(info);
        this.init();
    }

    private void init() throws MidiUnavailableException {
        if (!this.device.isOpen()) {
            this.device.open();
        }
        this.receiver = this.device.getReceiver();
    }

    public void sendSequence(Sequence sequence) {
        TimeFactor.sortAndDeliverMidiMessages(sequence, new MidiMessageRecipient(){

            public void messageReady(MidiMessage message, long timestamp) {
                DeviceThatWillReceiveMidi.this.receiver.send(message, -1L);
            }
        });
        ShortMessage allControllersOff = new ShortMessage();
        ShortMessage allNotesOff = new ShortMessage();
        int track = 0;
        while (track < 16) {
            try {
                allControllersOff.setMessage(176, track, 121, 0);
                this.receiver.send(allControllersOff, -1L);
                allNotesOff.setMessage(176, track, 123, 0);
                this.receiver.send(allNotesOff, -1L);
            }
            catch (InvalidMidiDataException e) {
                throw new JFugueException("Error playing music: " + e);
            }
            track = (byte)(track + 1);
        }
    }

    public void close() {
        this.receiver.close();
        this.device.close();
    }

    public Receiver getReceiver() {
        return this.receiver;
    }
}

