/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.tiff;

import java.util.HashMap;
import org.monte.media.tiff.TIFFTag;

public abstract class TagSet {
    private HashMap<Integer, TIFFTag> tagsByNumber = new HashMap();
    private String name;

    public TagSet(String name, TIFFTag[] tags) {
        this.name = name;
        TIFFTag[] tIFFTagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            TIFFTag tag = tIFFTagArray[n2];
            tag.setTagSet(this);
            this.tagsByNumber.put(tag.getNumber(), tag);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TIFFTag getTag(int tagNumber) {
        TIFFTag tag = this.tagsByNumber.get(tagNumber);
        if (tag == null) {
            TagSet tagSet = this;
            synchronized (tagSet) {
                tag = this.tagsByNumber.get(tagNumber);
                if (tag == null) {
                    tag = new TIFFTag("unknown", tagNumber, -1, null);
                    this.tagsByNumber.put(tagNumber, tag);
                }
            }
        }
        return tag;
    }

    public String getName() {
        return this.name;
    }
}

