/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.ilbm;

import java.awt.image.DirectColorModel;

public class HAMColorModel
extends DirectColorModel {
    public static final int HAM6 = 6;
    public static final int HAM8 = 8;
    protected int HAMType;
    protected int map_size;
    protected boolean opaque;
    protected int[] rgb;

    public HAMColorModel(int aHAMType, int size, byte[] r, byte[] g, byte[] b, boolean isOCS) {
        super(24, 0xFF0000, 65280, 255);
        if (aHAMType != 6 && aHAMType != 8) {
            throw new IllegalArgumentException("Unknown HAM Type: " + aHAMType);
        }
        this.HAMType = aHAMType;
        if (isOCS) {
            byte[] r8 = new byte[size];
            byte[] g8 = new byte[size];
            byte[] b8 = new byte[size];
            int i = 0;
            while (i < size) {
                r8[i] = (byte)((r[i] & 0xF) << 4 | r[i] & 0xF);
                g8[i] = (byte)((g[i] & 0xF) << 4 | g[i] & 0xF);
                b8[i] = (byte)((b[i] & 0xF) << 4 | b[i] & 0xF);
                ++i;
            }
            this.setRGBs(size, r8, g8, b8, null);
        } else {
            this.setRGBs(size, r, g, b, null);
        }
    }

    public HAMColorModel(int aHAMType, int size, int[] rgb, boolean isOCS) {
        super(24, 0xFF0000, 65280, 255);
        if (aHAMType != 6 && aHAMType != 8) {
            throw new IllegalArgumentException("Unknown HAM Type: " + aHAMType);
        }
        this.HAMType = aHAMType;
        if (isOCS) {
            byte[] r = new byte[rgb.length];
            byte[] g = new byte[rgb.length];
            byte[] b = new byte[rgb.length];
            int i = 0;
            while (i < rgb.length) {
                r[i] = (byte)((rgb[i] & 0xF00) >>> 8 | (rgb[i] & 0xF00) >>> 4);
                g[i] = (byte)((rgb[i] & 0xF0) >>> 4 | rgb[i] & 0xF0);
                b[i] = (byte)(rgb[i] & 0xF | (rgb[i] & 0xF) << 4);
                ++i;
            }
            this.setRGBs(size, r, g, b, null);
        } else {
            byte[] r = new byte[size];
            byte[] g = new byte[size];
            byte[] b = new byte[size];
            int i = 0;
            while (i < size) {
                r[i] = (byte)((rgb[i] & 0xFF0000) >>> 16);
                g[i] = (byte)((rgb[i] & 0xFF00) >>> 8);
                b[i] = (byte)(rgb[i] & 0xFF);
                ++i;
            }
            this.setRGBs(size, r, g, b, null);
        }
    }

    public int getHAMType() {
        return this.HAMType;
    }

    public int getDepth() {
        return this.HAMType;
    }

    protected void setRGBs(int size, byte[] r, byte[] g, byte[] b, byte[] a) {
        if (size > 256) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.map_size = size;
        this.rgb = new int[256];
        int alpha = 255;
        this.opaque = true;
        int i = 0;
        while (i < size) {
            if (a != null && (alpha = a[i] & 0xFF) != 255) {
                this.opaque = false;
            }
            this.rgb[i] = alpha << 24 | (r[i] & 0xFF) << 16 | (g[i] & 0xFF) << 8 | b[i] & 0xFF;
            ++i;
        }
    }

    public final void getReds(byte[] r) {
        int i = 0;
        while (i < this.map_size) {
            r[i] = (byte)(this.rgb[i] >> 16);
            ++i;
        }
    }

    public final void getGreens(byte[] g) {
        int i = 0;
        while (i < this.map_size) {
            g[i] = (byte)(this.rgb[i] >> 8);
            ++i;
        }
    }

    public final void getBlues(byte[] b) {
        int i = 0;
        while (i < this.map_size) {
            b[i] = (byte)this.rgb[i];
            ++i;
        }
    }

    public final void getRGBs(int[] rgbs) {
        int i = 0;
        while (i < this.map_size) {
            rgbs[i] = this.rgb[i];
            ++i;
        }
    }

    public final int getMapSize() {
        return this.map_size;
    }
}

