/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.iff;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.monte.media.iff.IFFParser;

public class IFFChunk {
    private int id;
    private int type;
    private long size;
    private long scan;
    private byte[] data;
    private Hashtable<IFFChunk, IFFChunk> propertyChunks;
    private Vector<IFFChunk> collectionChunks;

    public IFFChunk(int type, int id) {
        this.id = id;
        this.type = type;
        this.size = -1L;
        this.scan = -1L;
    }

    public IFFChunk(int type, int id, long size, long scan) {
        this.id = id;
        this.type = type;
        this.size = size;
        this.scan = scan;
    }

    public IFFChunk(int type, int id, long size, long scan, IFFChunk propGroup) {
        this.id = id;
        this.type = type;
        this.size = size;
        this.scan = scan;
        if (propGroup != null) {
            if (propGroup.propertyChunks != null) {
                this.propertyChunks = (Hashtable)propGroup.propertyChunks.clone();
            }
            if (propGroup.collectionChunks != null) {
                this.collectionChunks = (Vector)propGroup.collectionChunks.clone();
            }
        }
    }

    public int getID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public long getScan() {
        return this.scan;
    }

    public void putPropertyChunk(IFFChunk chunk) {
        if (this.propertyChunks == null) {
            this.propertyChunks = new Hashtable();
        }
        this.propertyChunks.put(chunk, chunk);
    }

    public IFFChunk getPropertyChunk(int id) {
        if (this.propertyChunks == null) {
            return null;
        }
        IFFChunk chunk = new IFFChunk(this.type, id);
        return this.propertyChunks.get(chunk);
    }

    public Enumeration propertyChunks() {
        if (this.propertyChunks == null) {
            this.propertyChunks = new Hashtable();
        }
        return this.propertyChunks.keys();
    }

    public void addCollectionChunk(IFFChunk chunk) {
        if (this.collectionChunks == null) {
            this.collectionChunks = new Vector();
        }
        this.collectionChunks.addElement(chunk);
    }

    public IFFChunk[] getCollectionChunks(int id) {
        if (this.collectionChunks == null) {
            return new IFFChunk[0];
        }
        Enumeration<IFFChunk> enm = this.collectionChunks.elements();
        int i = 0;
        while (enm.hasMoreElements()) {
            IFFChunk chunk = enm.nextElement();
            if (chunk.id != id) continue;
            ++i;
        }
        IFFChunk[] array = new IFFChunk[i];
        i = 0;
        enm = this.collectionChunks.elements();
        while (enm.hasMoreElements()) {
            IFFChunk chunk = enm.nextElement();
            if (chunk.id != id) continue;
            array[i++] = chunk;
        }
        return array;
    }

    public Enumeration collectionChunks() {
        if (this.collectionChunks == null) {
            this.collectionChunks = new Vector();
        }
        return this.collectionChunks.elements();
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object another) {
        if (another instanceof IFFChunk) {
            IFFChunk that = (IFFChunk)another;
            return that.id == this.id && that.type == this.type;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "{" + IFFParser.idToString(this.getType()) + "," + IFFParser.idToString(this.getID()) + "}";
    }
}

