/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.exif;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.monte.media.tiff.ASCIIValueFormatter;
import org.monte.media.tiff.DateValueFormatter;
import org.monte.media.tiff.EnumValueFormatter;
import org.monte.media.tiff.SetValueFormatter;
import org.monte.media.tiff.TIFFTag;
import org.monte.media.tiff.TagSet;

public class EXIFTagSet
extends TagSet {
    public static final TIFFTag ExifVersion = new TIFFTag("ExifVersion", 36864, TIFFTag.UNDEFINED_MASK, new ASCIIValueFormatter());
    public static final TIFFTag FlashpixVersion = new TIFFTag("FlashpixVersion", 40960, TIFFTag.UNDEFINED_MASK, new ASCIIValueFormatter());
    public static final TIFFTag ColorSpace = new TIFFTag("ColorSpace", 40961, TIFFTag.SHORT_MASK, new EnumValueFormatter("sRGB", 1, "uncalibrated", 65535));
    public static final TIFFTag ComponentsConfiguration = new TIFFTag("ComponentsConfiguration", 37121, TIFFTag.UNDEFINED_MASK, new EnumValueFormatter("doesNotExist", 0, "Y", 1, "Cb", 2, "Cr", 3, "R", 4, "G", 5, "B", 6));
    public static final TIFFTag CompressedBitsPerPixel = new TIFFTag("CompressedBitsPerPixel", 37122, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag PixelXDimension = new TIFFTag("PixelXDimension", 40962, TIFFTag.SHORT_MASK | TIFFTag.LONG_MASK);
    public static final TIFFTag PixelYDimension = new TIFFTag("PixelYDimension", 40963, TIFFTag.SHORT_MASK | TIFFTag.LONG_MASK);
    public static final TIFFTag MakerNote = new TIFFTag("MakerNote", 37500, TIFFTag.UNDEFINED_MASK | TIFFTag.IFD_MASK);
    public static final TIFFTag UserComment = new TIFFTag("UserComment", 37510, TIFFTag.UNDEFINED_MASK);
    public static final TIFFTag RelatedSoundFile = new TIFFTag("RelatedSoundFile", 40964, TIFFTag.ASCII_MASK);
    public static final TIFFTag DateTimeOriginal = new TIFFTag("DateTimeOriginal", 36867, TIFFTag.ASCII_MASK, new DateValueFormatter());
    public static final TIFFTag DateTimeDigitized = new TIFFTag("DateTimeDigitized", 36868, TIFFTag.ASCII_MASK, new DateValueFormatter());
    public static final TIFFTag SubSecTime = new TIFFTag("SubSecTime", 37520, TIFFTag.ASCII_MASK);
    public static final TIFFTag SubSecTimeOriginal = new TIFFTag("SubSecTimeOriginal", 37521, TIFFTag.ASCII_MASK);
    public static final TIFFTag SubSecTimeDigitized = new TIFFTag("SubSecTimeDigitized", 37522, TIFFTag.ASCII_MASK);
    public static final TIFFTag ExposureTime = new TIFFTag("ExposureTime", 33434, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag FNumber = new TIFFTag("FNumber", 33437, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag ExposureProgram = new TIFFTag("ExposureProgram", 34850, TIFFTag.SHORT_MASK, new EnumValueFormatter("notDefined", 0, "manual", 1, "normalProgram", 2, "aperturePriority", 3, "shutterPriority", 4, "createProgram", 5, "actionProgram", 6, "portraitMode", 7, "landscapeMode", 8));
    public static final TIFFTag SpectralSensitivity = new TIFFTag("SpectralSensitivity", 34852, TIFFTag.ASCII_MASK);
    public static final TIFFTag ISOSpeedRatings = new TIFFTag("ISOSpeedRatings", 34855, TIFFTag.SHORT_MASK);
    public static final TIFFTag OECF = new TIFFTag("OECF", 34856, TIFFTag.UNDEFINED_MASK);
    public static final TIFFTag ShutterSpeedValue = new TIFFTag("ShutterSpeedValue", 37377, TIFFTag.SRATIONAL_MASK);
    public static final TIFFTag ApertureValue = new TIFFTag("ApertureValue", 37378, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag BrightnessValue = new TIFFTag("BrightnessValue", 37379, TIFFTag.SRATIONAL_MASK);
    public static final TIFFTag ExposureBiasValue = new TIFFTag("ExposureBiasValue", 37380, TIFFTag.SRATIONAL_MASK);
    public static final TIFFTag MaxApertureValue = new TIFFTag("MaxApertureValue", 37381, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag SubjectDistance = new TIFFTag("SubjectDistance", 37382, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag MeteringMode = new TIFFTag("MeteringMode", 37383, TIFFTag.SHORT_MASK, new EnumValueFormatter("unknown", 0, "average", 1, "centerWeightedAverage", 2, "spot", 3, "multiSpot", 4, "pattern", 5, "partial", 6, "other", 255));
    public static final TIFFTag LightSource = new TIFFTag("LightSource", 37384, TIFFTag.SHORT_MASK, new EnumValueFormatter("unknown", 0, "daylight", 1, "fluorescent", 2, "tungsten", 3, "flash", 4, "fineWeather", 9, "cloudyWeather", 10, "shade", 11, "daylightFluorescent", 12, "dayWhiteFluorescent", 13, "coolWhiteFluorescent", 14, "whiteFluorescent", 15, "standardLightA", 17, "standardLightB", 18, "standardLightC", 19, "D55", 20, "D65", 21, "D75", 22, "D50", 23, "ISOStudioTungsten", 24, "otherLightSource", 255));
    public static final TIFFTag Flash = new TIFFTag("Flash", 37385, TIFFTag.SHORT_MASK, new SetValueFormatter("flashDidNotFire", 0, 1, "flashFired", 1, "strobeReturnLightNotDetected", 4, "strobeReturnLightDetected", 2, "compulsoryFiring", 8, 24, "compulsorySuppression", 16, 24, "autoMode", 24, "noFlashFunction", 32, "redEyeReductionSupported", 64));
    public static final TIFFTag FocalLength = new TIFFTag("FocalLength", 37386, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag SubjectArea = new TIFFTag("SubjectArea", 37396, TIFFTag.SHORT_MASK);
    public static final TIFFTag FlashEnergy = new TIFFTag("FlashEnergy", 41483, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag SpatialFrequencyResponse = new TIFFTag("SpatialFrequencyResponse", 41483, TIFFTag.UNDEFINED_MASK);
    public static final TIFFTag FocalPlaneXResolution = new TIFFTag("FocalPlaneXResolution", 41486, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag FocalPlaneYResolution = new TIFFTag("FocalPlaneYResolution", 41487, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag FocalPlaneResolutionUnit = new TIFFTag("FocalPlaneResolutionUnit", 41488, TIFFTag.SHORT_MASK, new EnumValueFormatter("noAbsoluteUnit", 1, "inch", 2, "centimeter", 3));
    public static final TIFFTag SubjectLocation = new TIFFTag("SubjectLocation", 41492, TIFFTag.SHORT_MASK);
    public static final TIFFTag ExposureIndex = new TIFFTag("ExposureIndex", 41493, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag SensingMethod = new TIFFTag("SensingMethod", 41495, TIFFTag.SHORT_MASK, new EnumValueFormatter("notDefined", 1, "oneChipColorArea", 2, "twoChipColorArea", 3, "threeChipColorArea", 4, "colorSequentialArea", 5, "trilinear", 7, "colorSequentialLinear", 8));
    public static final TIFFTag FileSource = new TIFFTag("FileSource", 41728, TIFFTag.UNDEFINED_MASK, new EnumValueFormatter("DSC", 3));
    public static final TIFFTag SceneType = new TIFFTag("SceneType", 41729, TIFFTag.UNDEFINED_MASK, new EnumValueFormatter("directlyPhotographed", 1));
    public static final TIFFTag CFAPattern = new TIFFTag("CFAPattern", 41730, TIFFTag.UNDEFINED_MASK);
    public static final TIFFTag CustomRendered = new TIFFTag("CustomRendered", 41985, TIFFTag.SHORT_MASK, new EnumValueFormatter("normalProcess", 0, "customProcess", 1));
    public static final TIFFTag ExposureMode = new TIFFTag("ExposureMode", 41986, TIFFTag.SHORT_MASK, new EnumValueFormatter("automatic", 0, "manual", 1, "autoBracket", 2));
    public static final TIFFTag WhiteBalance = new TIFFTag("WhiteBalance", 41987, TIFFTag.SHORT_MASK, new EnumValueFormatter("automatic", 0, "manual", 1));
    public static final TIFFTag DigitalZoomRatio = new TIFFTag("DigitalZoomRatio", 41988, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag FocalLengthIn35mmFilm = new TIFFTag("FocalLengthIn35mmFilm", 41989, TIFFTag.SHORT_MASK);
    public static final TIFFTag SceneCaptureType = new TIFFTag("SceneCaptureType", 41990, TIFFTag.SHORT_MASK, new EnumValueFormatter("standard", 0, "landscape", 1, "portrait", 2, "nightScene", 3));
    public static final TIFFTag GainControl = new TIFFTag("GainControl", 41991, TIFFTag.RATIONAL_MASK);
    public static final TIFFTag Contrast = new TIFFTag("Contrast", 41992, TIFFTag.SHORT_MASK, new EnumValueFormatter("normal", 0, "soft", 1, "hard", 2));
    public static final TIFFTag Saturation = new TIFFTag("Saturation", 41993, TIFFTag.SHORT_MASK, new EnumValueFormatter("normal", 0, "low", 1, "high", 2));
    public static final TIFFTag Sharpness = new TIFFTag("Sharpness", 41994, TIFFTag.SHORT_MASK, new EnumValueFormatter("normal", 0, "soft", 1, "hard", 2));
    public static final TIFFTag DeviceSettingDescription = new TIFFTag("DeviceSettingDescription", 41995, TIFFTag.UNDEFINED_MASK);
    public static final TIFFTag SubjectDistanceRange = new TIFFTag("SubjectDistanceRange", 41996, TIFFTag.SHORT_MASK, new EnumValueFormatter("unknown", 0, "macro", 1, "closeView", 2, "distantView", 3));
    public static final TIFFTag ImageUniqueID = new TIFFTag("ImageUniqueID", 42016, TIFFTag.ASCII_MASK);
    public static final TIFFTag Interoperability = new TIFFTag("Interoperability", 40965, TIFFTag.SHORT_MASK);
    private static EXIFTagSet instance;

    private EXIFTagSet(TIFFTag[] tags) {
        super("EXIF", tags);
    }

    public static EXIFTagSet getInstance() {
        if (instance == null) {
            Field[] fields = EXIFTagSet.class.getDeclaredFields();
            ArrayList<TIFFTag> tags = new ArrayList<TIFFTag>(fields.length);
            try {
                Field[] fieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    Object value = f.get(null);
                    if (value instanceof TIFFTag) {
                        tags.add((TIFFTag)value);
                    }
                    ++n2;
                }
                instance = new EXIFTagSet(tags.toArray(new TIFFTag[tags.size()]));
            }
            catch (IllegalArgumentException ex) {
                throw new InternalError("Can't read my own fields");
            }
            catch (IllegalAccessException ex) {
                throw new InternalError("Can't read my own fields");
            }
        }
        return instance;
    }

    public static void main(String[] args) {
        EXIFTagSet.getInstance();
    }
}

