/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.concurrent;

import java.util.Vector;

public abstract class EventLoop {
    protected Thread eventProcessor;
    private int priority;
    private final Vector queue = new Vector();
    private boolean isCoalesce;
    private volatile boolean isAlive = true;

    public EventLoop() {
        this(5);
    }

    public EventLoop(int priority) {
        this.priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectEvent(Object event) {
        Vector vector = this.queue;
        synchronized (vector) {
            if (!this.isCoalesce || !this.queue.contains(event)) {
                this.queue.addElement(event);
                if (this.isAlive) {
                    this.startProcessor();
                }
            }
        }
    }

    public void setCoalesce(boolean b) {
        this.isCoalesce = b;
    }

    public boolean isCoalesce() {
        return this.isCoalesce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Vector vector = this.queue;
        synchronized (vector) {
            this.isAlive = true;
            this.startProcessor();
        }
    }

    public void stop() {
        this.isAlive = false;
    }

    public void join() throws InterruptedException {
        Thread t = this.eventProcessor;
        if (t != null) {
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Vector vector = this.queue;
        synchronized (vector) {
            this.queue.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProcessor() {
        Vector vector = this.queue;
        synchronized (vector) {
            if (this.eventProcessor == null) {
                this.eventProcessor = new Thread(this + " Event Processor"){

                    @Override
                    public void run() {
                        EventLoop.this.processEvents();
                    }
                };
                try {
                    this.eventProcessor.setDaemon(false);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    this.eventProcessor.setPriority(this.priority);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.eventProcessor.start();
            }
        }
    }

    protected abstract void processEvent(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvents() {
        while (this.isAlive) {
            Object event;
            Vector vector = this.queue;
            synchronized (vector) {
                if (this.queue.isEmpty()) {
                    this.eventProcessor = null;
                    return;
                }
                event = this.queue.elementAt(0);
                this.queue.removeElementAt(0);
            }
            try {
                this.processEvent(event);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

