/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.AudioFormatKeys;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Codec;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.MovieWriter;
import org.monte.media.Registry;
import org.monte.media.VideoFormatKeys;
import org.monte.media.avi.AVIOutputStream;
import org.monte.media.avi.AbstractAVIStream;
import org.monte.media.io.ByteArrayImageOutputStream;
import org.monte.media.math.Rational;
import org.monte.media.riff.RIFFParser;

public class AVIWriter
extends AVIOutputStream
implements MovieWriter {
    public static final Format AVI = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/avi"});
    public static final Format VIDEO_RAW = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "DIB ", VideoFormatKeys.CompressorNameKey, "NONE"});
    public static final Format VIDEO_JPEG = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "MJPG", VideoFormatKeys.CompressorNameKey, "NONE"});
    public static final Format VIDEO_PNG = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "png ", VideoFormatKeys.CompressorNameKey, "NONE"});
    public static final Format VIDEO_RLE = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "RLE ", VideoFormatKeys.CompressorNameKey, "NONE"});
    public static final Format VIDEO_SCREEN_CAPTURE = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/avi", FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "NONE"});

    public AVIWriter(File file) throws IOException {
        super(file);
    }

    public AVIWriter(ImageOutputStream out) throws IOException {
        super(out);
    }

    @Override
    public Format getFileFormat() throws IOException {
        return AVI;
    }

    @Override
    public Format getFormat(int track) {
        return ((AbstractAVIStream.Track)this.tracks.get((int)track)).format;
    }

    @Override
    public Rational getDuration(int track) {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        long duration = this.getMediaDuration(track);
        return new Rational(duration * tr.scale, tr.rate);
    }

    @Override
    public int addTrack(Format format) throws IOException {
        if (format.get(FormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
            return this.addVideoTrack(format);
        }
        return this.addAudioTrack(format);
    }

    private int addVideoTrack(Format vf) throws IOException {
        if (!vf.containsKey(FormatKeys.EncodingKey)) {
            throw new IllegalArgumentException("EncodingKey missing in " + vf);
        }
        if (!vf.containsKey(FormatKeys.FrameRateKey)) {
            throw new IllegalArgumentException("FrameRateKey missing in " + vf);
        }
        if (!vf.containsKey(VideoFormatKeys.WidthKey)) {
            throw new IllegalArgumentException("WidthKey missing in " + vf);
        }
        if (!vf.containsKey(VideoFormatKeys.HeightKey)) {
            throw new IllegalArgumentException("HeightKey missing in " + vf);
        }
        if (!vf.containsKey(VideoFormatKeys.DepthKey)) {
            throw new IllegalArgumentException("DepthKey missing in " + vf);
        }
        int tr = this.addVideoTrack(vf.get(FormatKeys.EncodingKey), vf.get(FormatKeys.FrameRateKey).getDenominator(), vf.get(FormatKeys.FrameRateKey).getNumerator(), vf.get(VideoFormatKeys.WidthKey), vf.get(VideoFormatKeys.HeightKey), vf.get(VideoFormatKeys.DepthKey), vf.get(FormatKeys.FrameRateKey).floor(1L).intValue());
        this.setCompressionQuality(tr, vf.get(VideoFormatKeys.QualityKey, Float.valueOf(1.0f)).floatValue());
        return tr;
    }

    private int addAudioTrack(Format format) throws IOException {
        int waveFormatTag = 1;
        long timeScale = 1L;
        long sampleRate = format.get(AudioFormatKeys.SampleRateKey, new Rational(41000L, 0L)).longValue();
        int numberOfChannels = format.get(AudioFormatKeys.ChannelsKey, 1);
        int sampleSizeInBits = format.get(AudioFormatKeys.SampleSizeInBitsKey, 16);
        boolean isCompressed = false;
        int frameDuration = 1;
        int frameSize = format.get(AudioFormatKeys.FrameSizeKey, (sampleSizeInBits + 7) / 8 * numberOfChannels);
        String enc = format.get(FormatKeys.EncodingKey);
        waveFormatTag = enc == null ? 1 : (enc.equals(AudioFormatKeys.ENCODING_ALAW) ? 1 : (enc.equals(AudioFormatKeys.ENCODING_PCM_SIGNED) ? 1 : (enc.equals(AudioFormatKeys.ENCODING_PCM_UNSIGNED) ? 1 : (enc.equals(AudioFormatKeys.ENCODING_ULAW) ? 1 : (enc.equals("MP3") ? 1 : RIFFParser.stringToID(format.get(FormatKeys.EncodingKey)) & 0xFFFF)))));
        return this.addAudioTrack(waveFormatTag, timeScale, sampleRate, numberOfChannels, sampleSizeInBits, isCompressed, frameDuration, frameSize);
    }

    public Codec getCodec(int track) {
        return ((AbstractAVIStream.Track)this.tracks.get((int)track)).codec;
    }

    public void setCodec(int track, Codec codec) {
        ((AbstractAVIStream.Track)this.tracks.get((int)track)).codec = codec;
    }

    @Override
    public int getTrackCount() {
        return this.tracks.size();
    }

    public void write(int track, BufferedImage image, long duration) throws IOException {
        this.ensureStarted();
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)this.tracks.get(track);
        if (vt.codec == null) {
            this.createCodec(track);
        }
        if (vt.codec == null) {
            throw new UnsupportedOperationException("No codec for this format: " + vt.format);
        }
        Format fmt = vt.format;
        if (fmt.get(VideoFormatKeys.WidthKey).intValue() != image.getWidth() || fmt.get(VideoFormatKeys.HeightKey).intValue() != image.getHeight()) {
            throw new IllegalArgumentException("Dimensions of image[" + vt.samples.size() + "] (width=" + image.getWidth() + ", height=" + image.getHeight() + ") differs from video format of track: " + fmt);
        }
        if (vt.outputBuffer == null) {
            vt.outputBuffer = new Buffer();
        }
        boolean isKeyframe = vt.syncInterval == 0 ? false : vt.samples.size() % vt.syncInterval == 0;
        Buffer inputBuffer = new Buffer();
        inputBuffer.flags = isKeyframe ? EnumSet.of(BufferFlag.KEYFRAME) : EnumSet.noneOf(BufferFlag.class);
        inputBuffer.data = image;
        vt.codec.process(inputBuffer, vt.outputBuffer);
        if (vt.outputBuffer.flags.contains((Object)BufferFlag.DISCARD)) {
            return;
        }
        isKeyframe = vt.outputBuffer.flags.contains((Object)BufferFlag.KEYFRAME);
        boolean paletteChange = this.writePalette(track, image, isKeyframe);
        this.writeSample(track, (byte[])vt.outputBuffer.data, vt.outputBuffer.offset, vt.outputBuffer.length, isKeyframe && !paletteChange);
    }

    @Override
    public void write(int track, Buffer buf) throws IOException {
        Buffer outBuf;
        this.ensureStarted();
        if (buf.flags.contains((Object)BufferFlag.DISCARD)) {
            return;
        }
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        boolean isKeyframe = buf.flags.contains((Object)BufferFlag.KEYFRAME);
        if (buf.data instanceof BufferedImage && tr.syncInterval != 0) {
            isKeyframe = buf.flags.contains((Object)BufferFlag.KEYFRAME) | tr.samples.size() % tr.syncInterval == 0;
        }
        boolean paletteChange = false;
        if (buf.data instanceof BufferedImage && tr instanceof AbstractAVIStream.VideoTrack) {
            paletteChange = this.writePalette(track, (BufferedImage)buf.data, isKeyframe);
        } else if (buf.header instanceof IndexColorModel) {
            paletteChange = this.writePalette(track, (IndexColorModel)buf.header, isKeyframe);
        }
        if (buf.format == null) {
            throw new IllegalArgumentException("Buffer.format must not be null");
        }
        if (buf.format.matchesWithout(tr.format, FormatKeys.FrameRateKey) && buf.data instanceof byte[]) {
            this.writeSamples(track, buf.sampleCount, (byte[])buf.data, buf.offset, buf.length, buf.isFlag(BufferFlag.KEYFRAME) && !paletteChange);
            return;
        }
        if (tr.codec == null) {
            this.createCodec(track);
            if (tr.codec == null) {
                throw new UnsupportedOperationException("No codec for this format " + tr.format);
            }
        }
        if (tr.outputBuffer == null) {
            tr.outputBuffer = new Buffer();
        }
        if (tr.codec.process(buf, outBuf = tr.outputBuffer) != 0) {
            throw new IOException("Codec failed or could not encode the sample in a single step.");
        }
        if (outBuf.isFlag(BufferFlag.DISCARD)) {
            return;
        }
        this.writeSamples(track, outBuf.sampleCount, (byte[])outBuf.data, outBuf.offset, outBuf.length, isKeyframe && !paletteChange);
    }

    private boolean writePalette(int track, BufferedImage image, boolean isKeyframe) throws IOException {
        if (image.getColorModel() instanceof IndexColorModel) {
            return this.writePalette(track, (IndexColorModel)image.getColorModel(), isKeyframe);
        }
        return false;
    }

    private boolean writePalette(int track, IndexColorModel imgPalette, boolean isKeyframe) throws IOException {
        this.ensureStarted();
        AbstractAVIStream.VideoTrack vt = (AbstractAVIStream.VideoTrack)this.tracks.get(track);
        int imgDepth = vt.bitCount;
        ByteArrayImageOutputStream tmp = null;
        boolean paletteChange = false;
        switch (imgDepth) {
            case 4: {
                int[] imgRGBs = new int[16];
                imgPalette.getRGBs(imgRGBs);
                int[] previousRGBs = new int[16];
                if (vt.previousPalette == null) {
                    vt.previousPalette = vt.palette;
                }
                vt.previousPalette.getRGBs(previousRGBs);
                if (!isKeyframe && Arrays.equals(imgRGBs, previousRGBs)) break;
                paletteChange = true;
                vt.previousPalette = imgPalette;
                int first = 0;
                int last = imgPalette.getMapSize() - 1;
                tmp = new ByteArrayImageOutputStream(ByteOrder.LITTLE_ENDIAN);
                tmp.writeByte(first);
                tmp.writeByte(last - first + 1);
                tmp.writeShort(0);
                int i = first;
                while (i <= last) {
                    tmp.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                    tmp.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                    tmp.writeByte(imgRGBs[i] & 0xFF);
                    tmp.writeByte(0);
                    ++i;
                }
                break;
            }
            case 8: {
                int[] imgRGBs = new int[256];
                imgPalette.getRGBs(imgRGBs);
                int[] previousRGBs = new int[256];
                if (vt.previousPalette != null) {
                    vt.previousPalette.getRGBs(previousRGBs);
                }
                if (!isKeyframe && Arrays.equals(imgRGBs, previousRGBs)) break;
                paletteChange = true;
                vt.previousPalette = imgPalette;
                int first = 0;
                int last = imgPalette.getMapSize() - 1;
                tmp = new ByteArrayImageOutputStream(ByteOrder.LITTLE_ENDIAN);
                tmp.writeByte(first);
                tmp.writeByte(last - first + 1);
                tmp.writeShort(0);
                int i = first;
                while (i <= last) {
                    tmp.writeByte(imgRGBs[i] >>> 16 & 0xFF);
                    tmp.writeByte(imgRGBs[i] >>> 8 & 0xFF);
                    tmp.writeByte(imgRGBs[i] & 0xFF);
                    tmp.writeByte(0);
                    ++i;
                }
                break;
            }
        }
        if (tmp != null) {
            tmp.close();
            this.writePalette(track, tmp.toByteArray(), 0, (int)tmp.length(), isKeyframe);
        }
        return paletteChange;
    }

    private Codec createCodec(Format fmt) {
        return Registry.getInstance().getEncoder(fmt.prepend(FormatKeys.MimeTypeKey, "video/avi"));
    }

    private void createCodec(int track) {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        Format fmt = tr.format;
        tr.codec = this.createCodec(fmt);
        String enc = fmt.get(FormatKeys.EncodingKey);
        if (tr.codec != null) {
            if (fmt.get(FormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
                tr.codec.setInputFormat(fmt.prepend(FormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class));
                if (tr.codec.setOutputFormat(fmt.prepend(VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.QualityKey, Float.valueOf(this.getCompressionQuality(track)), FormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.DataClassKey, byte[].class)) == null) {
                    throw new UnsupportedOperationException("Track " + tr + " codec does not support format " + fmt + ". codec=" + tr.codec);
                }
            } else {
                tr.codec.setInputFormat(null);
                if (tr.codec.setOutputFormat(fmt.prepend(VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.QualityKey, Float.valueOf(this.getCompressionQuality(track)), FormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.DataClassKey, byte[].class)) == null) {
                    throw new UnsupportedOperationException("Track " + tr + " codec " + tr.codec + " does not support format. " + fmt);
                }
            }
        }
    }

    public boolean isVFRSupported() {
        return false;
    }

    @Override
    public boolean isEmpty(int track) {
        return ((AbstractAVIStream.Track)this.tracks.get((int)track)).samples.isEmpty();
    }
}

