/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.monte.media.Animator;
import org.monte.media.Interpolator;

public class DefaultAnimator
implements Animator {
    protected EventListenerList listenerList = new EventListenerList();
    private Vector activeInterpolators;
    private Vector newInterpolators;
    private Thread animationThread;
    private boolean isAnimating;
    private Object lock = new Object();
    protected ChangeEvent changeEvent;
    private int sleep = 33;

    public DefaultAnimator() {
        this.activeInterpolators = new Vector();
        this.newInterpolators = new Vector();
    }

    @Override
    public void setLock(Object lock) {
        this.lock = lock;
    }

    @Override
    public boolean isActive() {
        return this.animationThread != null;
    }

    @Override
    public void start() {
        this.stop();
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    @Override
    public void stop() {
        if (this.animationThread != null) {
            Thread t = this.animationThread;
            this.animationThread = null;
            t.interrupt();
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Interpolator interpolator) {
        Vector vector = this.newInterpolators;
        synchronized (vector) {
            this.newInterpolators.addElement(interpolator);
            if (!this.isActive()) {
                this.start();
            }
        }
    }

    @Override
    public void animateStep() {
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < this.newInterpolators.size()) {
            Interpolator before;
            Interpolator candidate = (Interpolator)this.newInterpolators.elementAt(i);
            boolean isEnqueueable = true;
            int j = 0;
            while (j < i) {
                before = (Interpolator)this.newInterpolators.elementAt(j);
                if (candidate.isSequential(before)) {
                    isEnqueueable = false;
                    break;
                }
                ++j;
            }
            if (isEnqueueable) {
                j = 0;
                while (j < this.activeInterpolators.size()) {
                    before = (Interpolator)this.activeInterpolators.elementAt(j);
                    if (candidate.replaces(before)) {
                        before.finish(now);
                    }
                    if (candidate.isSequential(before)) {
                        isEnqueueable = false;
                        break;
                    }
                    ++j;
                }
            }
            if (isEnqueueable) {
                candidate.initialize(now);
                this.activeInterpolators.addElement(candidate);
                this.newInterpolators.removeElementAt(i--);
            }
            ++i;
        }
        i = 0;
        while (i < this.activeInterpolators.size()) {
            Interpolator active = (Interpolator)this.activeInterpolators.elementAt(i);
            if (active.isFinished()) {
                this.activeInterpolators.removeElementAt(i--);
            } else if (active.isElapsed(now)) {
                active.finish(now);
                this.activeInterpolators.removeElementAt(i--);
            } else {
                active.interpolate(now);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        while (Thread.currentThread() == this.animationThread) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.animateStep();
            }
            boolean hasFinished = false;
            object = this.newInterpolators;
            synchronized (object) {
                if (this.activeInterpolators.size() == 0 && this.newInterpolators.size() == 0) {
                    this.animationThread = null;
                    hasFinished = true;
                }
            }
            if (hasFinished) {
                this.fireStateChanged();
                return;
            }
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Vector vector = this.newInterpolators;
        synchronized (vector) {
            object = this.lock;
            synchronized (object) {
                long now = System.currentTimeMillis();
                int i = 0;
                while (i < this.activeInterpolators.size()) {
                    Interpolator active = (Interpolator)this.activeInterpolators.elementAt(i);
                    active.finish(now);
                    ++i;
                }
                i = 0;
                while (i < this.newInterpolators.size()) {
                    Interpolator candidate = (Interpolator)this.newInterpolators.elementAt(i);
                    candidate.initialize(now);
                    candidate.finish(now);
                    ++i;
                }
                this.activeInterpolators.removeAllElements();
                this.newInterpolators.removeAllElements();
            }
        }
        this.fireStateChanged();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

