/*
 * Decompiled with CFR 0.152.
 */
package org.monte.avidemo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.avi.AVIReader;
import org.monte.media.avi.AVIWriter;
import org.monte.media.math.Rational;

public class Main {
    public static void main(String[] args) {
        System.out.println("AVIDemo " + Main.class.getPackage().getImplementationVersion());
        System.out.println("This is a demo of the Monte Media library.");
        System.out.println("Copyright \u00a9 Werner Randelshofer. All Rights Reserved.");
        System.out.println("License: Creative Commons Attribution 3.0.");
        System.out.println();
        try {
            Main.test(new File("avidemo-jpg.avi"), new Format(FormatKeys.EncodingKey, "MJPG", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.QualityKey, Float.valueOf(1.0f)));
            Main.test(new File("avidemo-jpg-q0.5.avi"), new Format(FormatKeys.EncodingKey, "MJPG", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.QualityKey, Float.valueOf(0.5f)));
            Main.test(new File("avidemo-png.avi"), new Format(FormatKeys.EncodingKey, "png ", VideoFormatKeys.DepthKey, 24));
            Main.test(new File("avidemo-raw24.avi"), new Format(FormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DepthKey, 24));
            Main.test(new File("avidemo-raw8.avi"), new Format(FormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DepthKey, 8));
            Main.test(new File("avidemo-rle8.avi"), new Format(FormatKeys.EncodingKey, "RLE ", VideoFormatKeys.DepthKey, 8));
            Main.test(new File("avidemo-tscc8.avi"), new Format(FormatKeys.EncodingKey, "tscc", VideoFormatKeys.DepthKey, 8));
            Main.test(new File("avidemo-tscc24.avi"), new Format(FormatKeys.EncodingKey, "tscc", VideoFormatKeys.DepthKey, 24));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void test(File file, Format format) throws IOException {
        Main.testWriting(file, format);
        try {
            Main.testReading(file);
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }

    private static void testWriting(File file, Format format) throws IOException {
        System.out.println("Writing " + file);
        format = format.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.FrameRateKey, new Rational(30L, 1L), VideoFormatKeys.WidthKey, 320, VideoFormatKeys.HeightKey, 160});
        BufferedImage img = Main.createImage(format);
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AVIWriter out = null;
        try {
            out = new AVIWriter(file);
            out.addTrack(format);
            out.setPalette(0, img.getColorModel());
            Random rnd = new Random(0L);
            g.setBackground(Color.WHITE);
            g.clearRect(0, 0, img.getWidth(), img.getHeight());
            int i = 0;
            while (i < 100) {
                g.setColor(new Color(rnd.nextInt()));
                g.fillOval(rnd.nextInt(img.getWidth() - 30), rnd.nextInt(img.getHeight() - 30), 30, 30);
                out.write(0, img, 1L);
                ++i;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            g.dispose();
        }
    }

    private static void testReading(File file) throws IOException {
        System.out.println("Reading " + file);
        AVIReader in = null;
        try {
            in = new AVIReader(file);
            int track = 0;
            while (track < in.getTrackCount() && in.getFormat(track).get(FormatKeys.MediaTypeKey) != FormatKeys.MediaType.VIDEO) {
                ++track;
            }
            BufferedImage img = null;
            while ((img = in.read(track, img)) != null) {
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static BufferedImage createImage(Format format) {
        BufferedImage img;
        int depth = format.get(VideoFormatKeys.DepthKey);
        int width = format.get(VideoFormatKeys.WidthKey);
        int height = format.get(VideoFormatKeys.HeightKey);
        Random rnd = new Random(0L);
        switch (depth) {
            default: {
                img = new BufferedImage(width, height, 1);
                break;
            }
            case 8: {
                byte[] red = new byte[256];
                byte[] green = new byte[256];
                byte[] blue = new byte[256];
                int i = 0;
                while (i < 255) {
                    red[i] = (byte)rnd.nextInt(256);
                    green[i] = (byte)rnd.nextInt(256);
                    blue[i] = (byte)rnd.nextInt(256);
                    ++i;
                }
                rnd.setSeed(0L);
                IndexColorModel palette = new IndexColorModel(8, 256, red, green, blue);
                img = new BufferedImage(width, height, 13, palette);
                break;
            }
            case 4: {
                byte[] red = new byte[16];
                byte[] green = new byte[16];
                byte[] blue = new byte[16];
                int i = 0;
                while (i < 15) {
                    red[i] = (byte)rnd.nextInt(16);
                    green[i] = (byte)rnd.nextInt(16);
                    blue[i] = (byte)rnd.nextInt(16);
                    ++i;
                }
                rnd.setSeed(0L);
                IndexColorModel palette = new IndexColorModel(4, 16, red, green, blue);
                img = new BufferedImage(width, height, 13, palette);
            }
        }
        return img;
    }
}

