/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util.props.tools;

import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.PropertyType;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;

public class GDLDumper {
    public static void dumpComponentAsGDL(ConfigurationManager cm, PrintStream out, String name) {
        out.println("node: {title: \"" + name + "\" color: " + GDLDumper.getColor(cm, name) + '}');
        PropertySheet ps = cm.getPropertySheet(name);
        Collection<String> propertyNames = ps.getRegisteredProperties();
        for (String propertyName : propertyNames) {
            PropertyType propType = ps.getType(propertyName);
            Object val = ps.getRaw(propertyName);
            if (val == null) continue;
            if (propType == PropertyType.COMPONENT) {
                out.println("edge: {source: \"" + name + "\" target: \"" + val + "\"}");
                continue;
            }
            if (propType != PropertyType.COMPONENT_LIST) continue;
            List list = (List)val;
            for (Object listElement : list) {
                out.println("edge: {source: \"" + name + "\" target: \"" + listElement + "\"}");
            }
        }
    }

    public static void showConfigAsGDL(ConfigurationManager ConfigurationManager2, String path) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(path));
        GDLDumper.dumpGDLHeader(out);
        for (String componentName : ConfigurationManager2.getInstanceNames(Configurable.class)) {
            GDLDumper.dumpComponentAsGDL(ConfigurationManager2, out, componentName);
        }
        GDLDumper.dumpGDLFooter(out);
        out.close();
    }

    public static void dumpGDLHeader(PrintStream out) {
        out.println(" graph: {title: \"unix evolution\" ");
        out.println("         layoutalgorithm: tree");
        out.println("          scaling        : 2.0");
        out.println("          colorentry 42  : 152 222 255");
        out.println("     node.shape     : ellipse");
        out.println("      node.color     : 42 ");
        out.println("node.height    : 32  ");
        out.println("node.fontname  : \"helvB08\"");
        out.println("edge.color     : darkred");
        out.println("edge.arrowsize :  6    ");
        out.println("node.textcolor : darkblue ");
        out.println("splines        : yes");
    }

    public static String getColor(ConfigurationManager ConfigurationManager2, String componentName) {
        Class<?> cls;
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    try {
                                        Object c = ConfigurationManager2.lookup(componentName);
                                        cls = c.getClass();
                                        if (cls.getName().indexOf(".recognizer") <= 1) break block10;
                                        return "cyan";
                                    }
                                    catch (PropertyException e) {
                                        return "black";
                                    }
                                }
                                if (cls.getName().indexOf(".tools") <= 1) break block11;
                                return "darkcyan";
                            }
                            if (cls.getName().indexOf(".decoder") <= 1) break block12;
                            return "green";
                        }
                        if (cls.getName().indexOf(".frontend") <= 1) break block13;
                        return "orange";
                    }
                    if (cls.getName().indexOf(".acoustic") <= 1) break block14;
                    return "turquoise";
                }
                if (cls.getName().indexOf(".linguist") <= 1) break block15;
                return "lightblue";
            }
            if (cls.getName().indexOf(".instrumentation") <= 1) break block16;
            return "lightgrey";
        }
        if (cls.getName().indexOf(".util") > 1) {
            return "lightgrey";
        }
        return "darkgrey";
    }

    public static void dumpGDLFooter(PrintStream out) {
        out.println("}");
    }
}

