/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class Utilities {
    private static final boolean TRACKING_OBJECTS = false;
    static long maxUsed;

    private Utilities() {
    }

    public static String pad(int padding) {
        if (padding > 0) {
            StringBuilder sb = new StringBuilder(padding);
            int i = 0;
            while (i < padding) {
                sb.append(' ');
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    public static String pad(String string, int minLength) {
        String result = string;
        int pad = minLength - string.length();
        if (pad > 0) {
            result = String.valueOf(string) + Utilities.pad(minLength - string.length());
        } else if (pad < 0) {
            result = string.substring(0, minLength);
        }
        return result;
    }

    public static String pad(int val, int minLength) {
        return Utilities.pad(String.valueOf(val), minLength);
    }

    public static String pad(double val, int minLength) {
        return Utilities.pad(String.valueOf(val), minLength);
    }

    public static void dump(PrintWriter pw, int padding, String string) {
        pw.print(Utilities.pad(padding));
        pw.println(string);
    }

    public static void objectTracker(String name, int count) {
    }

    public static void dumpMemoryInfo(String msg) {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        rt.gc();
        long reclaimedMemory = (rt.freeMemory() - free) / 0x100000L;
        long freeMemory = rt.freeMemory() / 0x100000L;
        long totalMemory = rt.totalMemory() / 0x100000L;
        long usedMemory = rt.totalMemory() - rt.freeMemory();
        if (usedMemory > maxUsed) {
            maxUsed = usedMemory;
        }
        System.out.println("Memory (mb)  total: " + totalMemory + " reclaimed: " + reclaimedMemory + " free: " + freeMemory + " Max Used: " + maxUsed / 0x100000L + " -- " + msg);
    }

    public static String doubleToScientificString(double number, int fractionDigits) {
        DecimalFormat format = new DecimalFormat();
        StringBuilder formatter = new StringBuilder(5 + fractionDigits).append("0.");
        int i = 0;
        while (i < fractionDigits) {
            formatter.append('0');
            ++i;
        }
        formatter.append("E00");
        format.applyPattern(formatter.toString());
        String formatted = format.format(number);
        int index = formatted.indexOf(69);
        if (formatted.charAt(index + 1) != '-') {
            return String.valueOf(formatted.substring(0, index + 1)) + '+' + formatted.substring(index + 1);
        }
        return formatted;
    }

    public static boolean isCepstraFileBigEndian(String filename) throws IOException {
        File cepstraFile = new File(filename);
        int fileSize = (int)cepstraFile.length();
        DataInputStream stream = new DataInputStream(new FileInputStream(filename));
        int numberBytes = stream.readInt() * 4 + 4;
        stream.close();
        return fileSize == numberBytes;
    }

    public static float readLittleEndianFloat(DataInputStream dataStream) throws IOException {
        return Float.intBitsToFloat(Utilities.readLittleEndianInt(dataStream));
    }

    public static int readLittleEndianInt(DataInputStream dataStream) throws IOException {
        return dataStream.readUnsignedByte() | dataStream.readUnsignedByte() << 8 | dataStream.readUnsignedByte() << 16 | dataStream.readUnsignedByte() << 24;
    }

    public static int swapInteger(int integer) {
        return (0xFF & integer) << 24 | (0xFF00 & integer) << 8 | (0xFF0000 & integer) >> 8 | (0xFF000000 & integer) >> 24;
    }

    public static float swapFloat(float floatValue) {
        return Float.intBitsToFloat(Utilities.swapInteger(Float.floatToRawIntBits(floatValue)));
    }

    public static void floorData(float[] data, float floor) {
        int i = 0;
        while (i < data.length) {
            if (data[i] < floor) {
                data[i] = floor;
            }
            ++i;
        }
    }

    public static void nonZeroFloor(float[] data, float floor) {
        int i = 0;
        while (i < data.length) {
            if ((double)data[i] != 0.0 && data[i] < floor) {
                data[i] = floor;
            }
            ++i;
        }
    }

    public static void normalize(float[] data) {
        float sum = 0.0f;
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float val = fArray[n2];
            sum += val;
            ++n2;
        }
        if (sum != 0.0f) {
            int i = 0;
            while (i < data.length) {
                data[i] = data[i] / sum;
                ++i;
            }
        }
    }

    public static String join(List<String> tokens) {
        StringBuilder builder = new StringBuilder();
        for (String token : tokens) {
            builder.append(token);
            builder.append(' ');
        }
        return builder.toString().trim();
    }

    public static List<Integer> asList(int[] align) {
        ArrayList<Integer> result = new ArrayList<Integer>(align.length);
        int[] nArray = align;
        int n = align.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            result.add(i);
            ++n2;
        }
        return result;
    }

    public static String pathJoin(String path1, String path2) {
        if (path1.length() > 0 && path1.charAt(path1.length() - 1) == '/') {
            path1 = path1.substring(0, path1.length() - 1);
        }
        if (path2.length() > 0 && path2.charAt(0) == '/') {
            path2 = path2.substring(1);
        }
        return String.valueOf(path1) + "/" + path2;
    }
}

