/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class TimerPool {
    private static final Map<Object, List<Timer>> weakRefTimerPool = new WeakHashMap<Object, List<Timer>>();

    private TimerPool() {
    }

    public static synchronized Timer getTimer(Object owner, String timerName) {
        if (!weakRefTimerPool.containsKey(owner)) {
            weakRefTimerPool.put(owner, new ArrayList());
        }
        List<Timer> ownerTimers = weakRefTimerPool.get(owner);
        for (Timer timer : ownerTimers) {
            if (!timer.getName().equals(timerName)) continue;
            return timer;
        }
        Timer requestedTimer = new Timer(timerName);
        ownerTimers.add(requestedTimer);
        return requestedTimer;
    }

    public static int getNumCachedTimers() {
        int counter = 0;
        for (List<Timer> timers : weakRefTimerPool.values()) {
            counter += timers.size();
        }
        return counter;
    }

    public static void dumpAll(Logger logger) {
        TimerPool.showTimesShortTitle(logger);
        for (List<Timer> timers : weakRefTimerPool.values()) {
            for (Timer timer : timers) {
                timer.dump(logger);
            }
        }
    }

    private static void showTimesShortTitle(Logger logger) {
        String title = "Timers";
        String titleBar = "# ----------------------------- " + title + "----------------------------------------------------------- ";
        logger.info(Utilities.pad(titleBar, 78));
        logger.info(String.valueOf(Utilities.pad("# Name", 20)) + ' ' + Utilities.pad("Count", 8) + Utilities.pad("CurTime", 10) + Utilities.pad("MinTime", 10) + Utilities.pad("MaxTime", 10) + Utilities.pad("AvgTime", 10) + Utilities.pad("TotTime", 10));
    }

    public static void resetAll() {
        for (List<Timer> timers : weakRefTimerPool.values()) {
            for (Timer timer : timers) {
                timer.reset();
            }
        }
    }
}

