/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.CommandInterface;
import edu.cmu.sphinx.util.CommandInterpreter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;

public class SocketCommandClient {
    private String host;
    private int port;
    private Socket socket;
    private BufferedReader inReader;
    private PrintWriter outWriter;

    public SocketCommandClient(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.open();
    }

    public SocketCommandClient() {
    }

    public synchronized void open(String aHost, int aPort) throws IOException {
        this.host = aHost;
        this.port = aPort;
        this.socket = new Socket(this.host, this.port);
        this.inReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.outWriter = new PrintWriter(this.socket.getOutputStream(), true);
    }

    private synchronized void open() throws IOException {
        this.open(this.host, this.port);
    }

    public int getSoTimeout() throws SocketException {
        if (this.socket != null) {
            return this.socket.getSoTimeout();
        }
        return 0;
    }

    public void setSoTimeout(int millisecs) throws SocketException {
        if (this.socket != null) {
            this.socket.setSoTimeout(millisecs);
        } else {
            System.err.println("SocketCommandClient.setSoTimeout(): socket is null");
        }
    }

    public synchronized boolean sendCommand(String command) {
        int maxTries = 2;
        int i = 0;
        while (i < 2) {
            if (this.checkOpen()) {
                this.outWriter.println(command);
                if (this.outWriter.checkError()) {
                    this.close();
                    System.err.println("IO error while sending " + command);
                } else {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public synchronized String getResponse() {
        String response = null;
        if (!this.checkOpen()) {
            return null;
        }
        try {
            response = this.inReader.readLine();
        }
        catch (IOException ioe) {
            System.err.println("IO error while reading response");
            this.close();
        }
        return response;
    }

    public synchronized boolean isResponse() {
        boolean response = false;
        if (!this.checkOpen()) {
            return false;
        }
        try {
            response = this.inReader.ready();
        }
        catch (IOException ioe) {
            System.err.println("IO error while checking response");
            this.close();
        }
        return response;
    }

    public synchronized String sendCommandGetResponse(String command) {
        String response = null;
        if (this.sendCommand(command)) {
            response = this.getResponse();
        }
        return response;
    }

    public synchronized void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            } else {
                System.err.println("SocketCommandClient.close(): socket is null");
            }
        }
        catch (IOException ioe) {
            System.err.println("Trouble closing socket");
        }
        this.socket = null;
    }

    private synchronized boolean checkOpen() {
        try {
            if (this.socket == null) {
                this.open();
            }
        }
        catch (IOException e) {
            System.err.println("SocketCommandClient.checkOpen():could not open socket");
            this.socket = null;
        }
        return this.socket != null;
    }

    public static void main(String[] args) {
        try {
            CommandInterpreter ci = new CommandInterpreter();
            SocketCommandClient sci = new SocketCommandClient("localhost", 7890);
            ci.add("s", new CommandInterface(){

                @Override
                public String execute(CommandInterpreter ci, String[] args) {
                    StringBuilder cmd = new StringBuilder();
                    int i = 1;
                    while (i < args.length) {
                        cmd.append(args[i]).append(' ');
                        ++i;
                    }
                    SocketCommandClient.this.sendCommand(cmd.toString());
                    return "";
                }

                @Override
                public String getHelp() {
                    return "send a command";
                }
            });
            ci.add("r", new CommandInterface(){

                @Override
                public String execute(CommandInterpreter ci, String[] args) {
                    while (SocketCommandClient.this.isResponse()) {
                        ci.putResponse(SocketCommandClient.this.getResponse());
                    }
                    return "";
                }

                @Override
                public String getHelp() {
                    return "receive a response";
                }
            });
            ci.add("sr", new CommandInterface(){

                @Override
                public String execute(CommandInterpreter ci, String[] args) {
                    StringBuilder cmd = new StringBuilder();
                    int i = 1;
                    while (i < args.length) {
                        cmd.append(args[i]).append(' ');
                        ++i;
                    }
                    ci.putResponse(SocketCommandClient.this.sendCommandGetResponse(cmd.toString()));
                    while (SocketCommandClient.this.isResponse()) {
                        ci.putResponse(SocketCommandClient.this.getResponse());
                    }
                    return "";
                }

                @Override
                public String getHelp() {
                    return "send a command, receive a response";
                }
            });
            ci.setPrompt("scc-test> ");
            ci.run();
        }
        catch (Exception e) {
            System.err.println("error occured.");
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

