/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.BatchFile;
import edu.cmu.sphinx.util.BatchItem;
import edu.cmu.sphinx.util.BatchManager;
import java.io.IOException;
import java.util.List;

public class SimpleBatchManager
implements BatchManager {
    private final String batchFile;
    private final int skip;
    private int whichBatch;
    private final int totalBatches;
    private int curItem;
    private List<String> items;

    public SimpleBatchManager(String filename, int skip, int whichBatch, int totalBatches) {
        this.batchFile = filename;
        this.skip = skip;
        this.whichBatch = whichBatch;
        this.totalBatches = totalBatches;
    }

    @Override
    public void start() throws IOException {
        this.curItem = 0;
        this.items = this.getBatchItems(this.batchFile);
    }

    @Override
    public BatchItem getNextItem() throws IOException {
        if (this.curItem >= this.items.size()) {
            return null;
        }
        String line = this.items.get(this.curItem++);
        return new BatchItem(BatchFile.getFilename(line), BatchFile.getReference(line));
    }

    @Override
    public void stop() throws IOException {
    }

    @Override
    public String getFilename() {
        return this.batchFile;
    }

    private List<String> getBatchItems(String file) throws IOException {
        List<String> list = BatchFile.getLines(file, this.skip);
        if (this.totalBatches > 1) {
            int linesPerBatch = list.size() / this.totalBatches;
            if (linesPerBatch < 1) {
                linesPerBatch = 1;
            }
            if (this.whichBatch >= this.totalBatches) {
                this.whichBatch = this.totalBatches - 1;
            }
            int startLine = this.whichBatch * linesPerBatch;
            list = this.whichBatch == this.totalBatches - 1 ? list.subList(startLine, list.size()) : list.subList(startLine, startLine + linesPerBatch);
        }
        return list;
    }
}

