/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.text.DecimalFormat;

public class MatrixUtils {
    public static final DecimalFormat df = new DecimalFormat("0.00");

    public static String toString(double[][] m) {
        StringBuilder s = new StringBuilder("[");
        double[][] dArray = m;
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            s.append(MatrixUtils.toString(row));
            s.append('\n');
            ++n2;
        }
        return s.append(" ]").toString();
    }

    public static String toString(double[] m) {
        StringBuilder s = new StringBuilder("[");
        double[] dArray = m;
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            s.append(' ').append(df.format(val));
            ++n2;
        }
        return s.append(" ]").toString();
    }

    public static int numCols(double[][] m) {
        return m[0].length;
    }

    public static String toString(float[][] matrix) {
        return MatrixUtils.toString(MatrixUtils.float2double(matrix));
    }

    public static float[] double2float(double[] values) {
        float[] newVals = new float[values.length];
        int i = 0;
        while (i < newVals.length) {
            newVals[i] = (float)values[i];
            ++i;
        }
        return newVals;
    }

    public static float[][] double2float(double[][] array) {
        float[][] floatArr = new float[array.length][array[0].length];
        int i = 0;
        while (i < array.length) {
            floatArr[i] = MatrixUtils.double2float(array[i]);
            ++i;
        }
        return floatArr;
    }

    public static double[] float2double(float[] values) {
        double[] doubArr = new double[values.length];
        int i = 0;
        while (i < doubArr.length) {
            doubArr[i] = values[i];
            ++i;
        }
        return doubArr;
    }

    public static double[][] float2double(float[][] array) {
        double[][] doubArr = new double[array.length][array[0].length];
        int i = 0;
        while (i < array.length) {
            doubArr[i] = MatrixUtils.float2double(array[i]);
            ++i;
        }
        return doubArr;
    }
}

