/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

public final class LogMath {
    public static final float LOG_ZERO = -3.4028235E38f;
    public static final float LOG_ONE = 0.0f;
    private static LogMath instance;
    private static float logBase;
    private static boolean useTable;
    private float naturalLogBase = (float)Math.log(logBase);
    private float inverseNaturalLogBase = 1.0f / this.naturalLogBase;
    private float[] theAddTable;

    static {
        logBase = 1.0001f;
        useTable = true;
    }

    private LogMath() {
        if (useTable) {
            int veryLargeNumberOfEntries = 150000;
            boolean verySmallNumberOfEntries = false;
            int entriesInTheAddTable = (int)(-Math.rint(this.linearToLog(this.logToLinear(0.5f) - 1.0)));
            if (entriesInTheAddTable > 150000) {
                entriesInTheAddTable = 150000;
            }
            if (entriesInTheAddTable <= 0) {
                throw new IllegalArgumentException("The log base " + logBase + " yields a very small addTable. " + "Either choose not to use the addTable, " + "or choose a logBase closer to 1.0");
            }
            this.theAddTable = new float[entriesInTheAddTable];
            int index = 0;
            while (index < entriesInTheAddTable) {
                float innerSummation = (float)this.logToLinear(-index);
                this.theAddTable[index] = this.linearToLog(innerSummation += 1.0f);
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogMath getLogMath() {
        if (instance != null) return instance;
        Class<LogMath> clazz = LogMath.class;
        synchronized (LogMath.class) {
            if (instance != null) return instance;
            instance = new LogMath();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogBase(float logBase) {
        Class<LogMath> clazz = LogMath.class;
        synchronized (LogMath.class) {
            assert (instance == null);
            LogMath.logBase = logBase;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUseTable(boolean useTable) {
        Class<LogMath> clazz = LogMath.class;
        synchronized (LogMath.class) {
            assert (instance == null);
            LogMath.useTable = useTable;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final float addAsLinear(float logVal1, float logVal2) {
        float logHighestValue = logVal1;
        float logDifference = logVal1 - logVal2;
        if (logDifference < 0.0f) {
            logHighestValue = logVal2;
            logDifference = -logDifference;
        }
        return logHighestValue + this.addTable(logDifference);
    }

    private float addTableActualComputation(float index) {
        double logInnerSummation = this.logToLinear(-index);
        return this.linearToLog(logInnerSummation += 1.0);
    }

    private float addTable(float index) throws IllegalArgumentException {
        int intIndex = (int)((double)index + 0.5);
        if (intIndex < this.theAddTable.length) {
            return this.theAddTable[intIndex];
        }
        return 0.0f;
    }

    public final float subtractAsLinear(float logMinuend, float logSubtrahend) throws IllegalArgumentException {
        if (logMinuend < logSubtrahend) {
            throw new IllegalArgumentException("Subtraction results in log of a negative number: " + logMinuend + " - " + logSubtrahend);
        }
        double logInnerSummation = 1.0;
        return logMinuend + this.linearToLog(logInnerSummation -= this.logToLinear(logSubtrahend - logMinuend));
    }

    public static float logToLog(float logSource, float sourceBase, float resultBase) throws IllegalArgumentException {
        float lnSourceBase = (float)Math.log(sourceBase);
        float lnResultBase = (float)Math.log(resultBase);
        return logSource * lnSourceBase / lnResultBase;
    }

    public final float lnToLog(float logSource) {
        return logSource * this.inverseNaturalLogBase;
    }

    public final float log10ToLog(float logSource) {
        return LogMath.logToLog(logSource, 10.0f, logBase);
    }

    public final float logToLn(float logSource) {
        return logSource * this.naturalLogBase;
    }

    public final float linearToLog(double linearValue) throws IllegalArgumentException {
        return (float)Math.log(linearValue) * this.inverseNaturalLogBase;
    }

    public final double logToLinear(float logValue) {
        return Math.exp(this.logToLn(logValue));
    }

    public final float getLogBase() {
        return logBase;
    }

    public boolean isUseTable() {
        return useTable;
    }

    public static float log10(float value) {
        return (float)(0.4342944819 * Math.log(value));
    }

    public void linearToLog(float[] vector) {
        int nbGaussians = vector.length;
        int i = 0;
        while (i < nbGaussians) {
            vector[i] = this.linearToLog(vector[i]);
            ++i;
        }
    }

    public void logToLinear(float[] vector, float[] out) {
        int i = 0;
        while (i < vector.length) {
            out[i] = (float)this.logToLinear(vector[i]);
            ++i;
        }
    }
}

