/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class ExtendedStreamTokenizer {
    private String path;
    private final StreamTokenizer st;
    private final Reader reader;
    private boolean atEOF;
    private final List<String> putbackList;

    public ExtendedStreamTokenizer(String path) throws FileNotFoundException {
        this(path, false);
    }

    public ExtendedStreamTokenizer(String path, boolean eolIsSignificant) throws FileNotFoundException {
        this(new FileReader(path), eolIsSignificant);
        this.path = path;
    }

    public ExtendedStreamTokenizer(InputStream inputStream, int commentChar, boolean eolIsSignificant) {
        this(new InputStreamReader(inputStream), eolIsSignificant);
        this.commentChar(commentChar);
    }

    public ExtendedStreamTokenizer(InputStream inputStream, boolean eolIsSignificant) {
        this(new InputStreamReader(inputStream), eolIsSignificant);
    }

    public ExtendedStreamTokenizer(Reader reader, boolean eolIsSignificant) {
        this.reader = new BufferedReader(reader);
        this.st = new StreamTokenizer(reader);
        this.st.resetSyntax();
        this.st.whitespaceChars(0, 32);
        this.st.wordChars(33, 255);
        this.st.eolIsSignificant(eolIsSignificant);
        this.putbackList = new ArrayList<String>();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public void whitespaceChars(int low, int hi) {
        this.st.whitespaceChars(low, hi);
    }

    public void commentChar(int ch) {
        this.st.commentChar(ch);
    }

    public String getString() throws IOException {
        if (!this.putbackList.isEmpty()) {
            return this.putbackList.remove(this.putbackList.size() - 1);
        }
        this.st.nextToken();
        if (this.st.ttype == -1) {
            this.atEOF = true;
        }
        if (this.st.ttype != -3 && this.st.ttype != 10 && this.st.ttype != -1) {
            this.corrupt("word expected but not found");
        }
        if (this.st.ttype == 10 || this.st.ttype == -1) {
            return null;
        }
        return this.st.sval;
    }

    public void unget(String string) {
        this.putbackList.add(string);
    }

    public boolean isEOF() {
        return this.atEOF;
    }

    private void corrupt(String msg) throws StreamCorruptedException {
        throw new StreamCorruptedException(String.valueOf(msg) + " at line " + this.st.lineno() + " in file " + this.path);
    }

    public int getLineNumber() {
        return this.st.lineno();
    }

    public void expectString(String expecting) throws IOException {
        String line = this.getString();
        if (!line.equals(expecting)) {
            this.corrupt("error matching expected string '" + expecting + "' in line: '" + line + '\'');
        }
    }

    public void expectInt(String name, int expecting) throws IOException {
        int val = this.getInt(name);
        if (val != expecting) {
            this.corrupt("Expecting integer " + expecting);
        }
    }

    public int getInt(String name) throws IOException {
        int iVal = 0;
        try {
            String val = this.getString();
            iVal = Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            this.corrupt("while parsing int " + name);
        }
        return iVal;
    }

    public double getDouble(String name) throws IOException {
        double dVal = 0.0;
        try {
            String val = this.getString();
            dVal = val.equals("inf") ? Double.POSITIVE_INFINITY : Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            this.corrupt("while parsing double " + name);
        }
        return dVal;
    }

    public float getFloat(String name) throws IOException {
        float fVal = 0.0f;
        try {
            String val = this.getString();
            fVal = val.equals("inf") ? Float.POSITIVE_INFINITY : Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            this.corrupt("while parsing float " + name);
        }
        return fVal;
    }

    public float getFloat(String name, float defaultValue) throws IOException {
        float fVal = 0.0f;
        try {
            String val = this.getString();
            fVal = val == null ? defaultValue : (val.equals("inf") ? Float.POSITIVE_INFINITY : Float.parseFloat(val));
        }
        catch (NumberFormatException nfe) {
            this.corrupt("while parsing float " + name);
        }
        return fVal;
    }

    public void skipwhite() throws IOException {
        String next = null;
        while (!this.isEOF()) {
            next = this.getString();
            if (next == null) continue;
            this.unget(next);
            break;
        }
    }
}

