/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.util;

import edu.cmu.sphinx.util.CommandInterface;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CommandInterpreter
extends Thread {
    private Map<String, CommandInterface> commandList;
    private int totalCommands;
    private BufferedReader in;
    private PrintWriter out;
    private String prompt;
    private boolean done;
    private boolean trace;
    private final CommandHistory history = new CommandHistory();
    private Socket socket;
    private static final Pattern historyPush = Pattern.compile("(.+):p");
    private static final Pattern editPattern = Pattern.compile("\\^(.+?)\\^(.*?)\\^?");
    private static final Pattern bbPattern = Pattern.compile("(!!)");

    public CommandInterpreter(BufferedReader in, PrintWriter out) {
        this.init(in, out);
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public CommandInterpreter() {
        BufferedReader bin = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter pw = new PrintWriter(System.out);
        this.init(bin, pw);
    }

    private void init(BufferedReader in, PrintWriter out) {
        this.commandList = new HashMap<String, CommandInterface>();
        this.addStandardCommands();
        this.setStreams(in, out);
    }

    public void setStreams(BufferedReader in, PrintWriter out) {
        this.in = in;
        this.out = out;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket skt) {
        this.socket = skt;
    }

    private void addStandardCommands() {
        this.add("help", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                CommandInterpreter.this.dumpCommands();
                return "";
            }

            @Override
            public String getHelp() {
                return "lists available commands";
            }
        });
        this.add("history", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                CommandInterpreter.this.history.dump();
                return "";
            }

            @Override
            public String getHelp() {
                return "shows command history";
            }
        });
        this.add("status", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                CommandInterpreter.this.putResponse("Total number of commands: " + CommandInterpreter.this.totalCommands);
                return "";
            }

            @Override
            public String getHelp() {
                return "shows command status";
            }
        });
        this.add("echo", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                StringBuilder b = new StringBuilder(80);
                int i = 1;
                while (i < args.length) {
                    b.append(args[i]);
                    b.append(' ');
                    ++i;
                }
                CommandInterpreter.this.putResponse(b.toString());
                return "";
            }

            @Override
            public String getHelp() {
                return "display a line of text";
            }
        });
        this.add("quit", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                CommandInterpreter.this.done = true;
                return "";
            }

            @Override
            public String getHelp() {
                return "exit the shell";
            }
        });
        this.add("on_exit", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                return "";
            }

            @Override
            public String getHelp() {
                return "command executed upon exit";
            }
        });
        this.add("version", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                CommandInterpreter.this.putResponse("Command Interpreter - Version 1.1 ");
                return "";
            }

            @Override
            public String getHelp() {
                return "displays version information";
            }
        });
        this.add("gc", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                Runtime.getRuntime().gc();
                return "";
            }

            @Override
            public String getHelp() {
                return "performs garbage collection";
            }
        });
        this.add("memory", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                long totalMem = Runtime.getRuntime().totalMemory();
                long freeMem = Runtime.getRuntime().freeMemory();
                CommandInterpreter.this.putResponse("Free Memory  : " + (double)freeMem / 1048576.0 + " mbytes");
                CommandInterpreter.this.putResponse("Total Memory : " + (double)totalMem / 1048576.0 + " mbytes");
                return "";
            }

            @Override
            public String getHelp() {
                return "shows memory statistics";
            }
        });
        this.add("delay", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length == 2) {
                    try {
                        float seconds = Float.parseFloat(args[1]);
                        Thread.sleep((long)(seconds * 1000.0f));
                    }
                    catch (NumberFormatException nfe) {
                        CommandInterpreter.this.putResponse("Usage: delay time-in-seconds");
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    CommandInterpreter.this.putResponse("Usage: delay time-in-seconds");
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "pauses for a given number of seconds";
            }
        });
        this.add("repeat", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length >= 3) {
                    try {
                        int count = Integer.parseInt(args[1]);
                        String[] subargs = Arrays.copyOfRange(args, 2, args.length);
                        int i = 0;
                        while (i < count) {
                            CommandInterpreter.this.putResponse(CommandInterpreter.this.execute(subargs));
                            ++i;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        CommandInterpreter.this.putResponse("Usage: repeat count command args");
                    }
                } else {
                    CommandInterpreter.this.putResponse("Usage: repeat count command args");
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "repeatedly execute a command";
            }
        });
        this.add("load", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length == 2) {
                    if (!CommandInterpreter.this.load(args[1])) {
                        CommandInterpreter.this.putResponse("load: trouble loading " + args[1]);
                    }
                } else {
                    CommandInterpreter.this.putResponse("Usage: load filename");
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "load and execute commands from a file";
            }
        });
        this.add("chain", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length > 1) {
                    String[] subargs = new String[args.length - 1];
                    ArrayList<String[]> commands = new ArrayList<String[]>(5);
                    int count = 0;
                    int i = 1;
                    while (i < args.length) {
                        if (args[i].equals(";")) {
                            if (count > 0) {
                                commands.add(Arrays.copyOf(subargs, count));
                                count = 0;
                            }
                        } else {
                            subargs[count++] = args[i];
                        }
                        ++i;
                    }
                    if (count > 0) {
                        commands.add(Arrays.copyOf(subargs, count));
                    }
                    for (String[] command : commands) {
                        CommandInterpreter.this.putResponse(CommandInterpreter.this.execute(command));
                    }
                } else {
                    CommandInterpreter.this.putResponse("Usage: chain cmd1 ; cmd2 ; cmd3 ");
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "execute multiple commands on a single line";
            }
        });
        this.add("time", new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) {
                if (args.length > 1) {
                    String[] subargs = Arrays.copyOfRange(args, 1, args.length);
                    long startTime = System.currentTimeMillis();
                    CommandInterpreter.this.putResponse(CommandInterpreter.this.execute(subargs));
                    long endTime = System.currentTimeMillis();
                    CommandInterpreter.this.putResponse("Time: " + (double)(endTime - startTime) / 1000.0 + " seconds");
                } else {
                    CommandInterpreter.this.putResponse("Usage: time cmd [args]");
                }
                return "";
            }

            @Override
            public String getHelp() {
                return "report the time it takes to run a command";
            }
        });
    }

    private void dumpCommands() {
        for (Map.Entry<String, CommandInterface> entry : new TreeMap<String, CommandInterface>(this.commandList).entrySet()) {
            this.putResponse(String.valueOf(entry.getKey()) + " - " + entry.getValue().getHelp());
        }
    }

    public void add(String name, CommandInterface command) {
        this.commandList.put(name, command);
    }

    public void addAlias(String command, String alias) {
        this.commandList.put(alias, this.commandList.get(command));
    }

    public void add(Map<String, CommandInterface> newCommands) {
        this.commandList.putAll(newCommands);
    }

    public synchronized void putResponse(String response) {
        if (response != null && !response.isEmpty()) {
            this.out.println(response);
            this.out.flush();
            if (this.trace) {
                System.out.println("Out: " + response);
            }
        }
    }

    protected void onExit() {
        this.execute("on_exit");
        System.out.println("----------\n");
    }

    protected String execute(String[] args) {
        String response = "";
        if (args.length > 0) {
            CommandInterface ci = this.commandList.get(args[0]);
            response = ci != null ? ci.execute(this, args) : "ERR  CMD_NOT_FOUND";
            ++this.totalCommands;
        }
        return response;
    }

    public String execute(String cmdString) {
        if (this.trace) {
            System.out.println("Execute: " + cmdString);
        }
        return this.execute(this.parseMessage(cmdString));
    }

    protected String[] parseMessage(String message) {
        ArrayList<String> words = new ArrayList<String>(20);
        StreamTokenizer st = new StreamTokenizer(new StringReader(message));
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        st.quoteChar(34);
        st.quoteChar(34);
        st.commentChar(35);
        try {
            while (true) {
                int tokenType;
                if ((tokenType = st.nextToken()) == -3) {
                    words.add(st.sval);
                    continue;
                }
                if (tokenType == 39 || tokenType == 34) {
                    words.add(st.sval);
                    continue;
                }
                if (tokenType == -2) {
                    System.out.println("Unexpected numeric token!");
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return words.toArray(new String[words.size()]);
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                this.printPrompt();
                String message = this.getInputLine();
                if (message == null) break;
                if (this.trace) {
                    System.out.println("\n----------");
                    System.out.println("In : " + message);
                }
                if ((message = message.trim()).isEmpty()) continue;
                this.putResponse(this.execute(message));
            }
            catch (IOException e) {
                System.out.println("Exception: CommandInterpreter.run()");
                break;
            }
        }
        this.onExit();
    }

    private String getInputLine() throws IOException {
        boolean error;
        boolean echo;
        boolean justPush;
        String message;
        block19: {
            message = this.in.readLine();
            if (message == null) {
                return null;
            }
            justPush = false;
            echo = false;
            error = false;
            Matcher m = historyPush.matcher(message);
            if (m.matches()) {
                justPush = true;
                echo = true;
                message = m.group(1);
            }
            if (message.startsWith("^")) {
                m = editPattern.matcher(message);
                if (m.matches()) {
                    String orig = m.group(1);
                    String sub = m.group(2);
                    try {
                        Pattern pat = Pattern.compile(orig);
                        Matcher subMatcher = pat.matcher(this.history.getLast(0));
                        if (subMatcher.find()) {
                            message = subMatcher.replaceFirst(sub);
                            echo = true;
                            break block19;
                        }
                        error = true;
                        this.putResponse(String.valueOf(message) + ": substitution failed");
                    }
                    catch (PatternSyntaxException pse) {
                        error = true;
                        this.putResponse("Bad regexp: " + pse.getDescription());
                    }
                } else {
                    error = true;
                    this.putResponse("bad substitution sytax, use ^old^new^");
                }
            } else {
                m = bbPattern.matcher(message);
                if (m.find()) {
                    message = m.replaceAll(this.history.getLast(0));
                    echo = true;
                } else if (message.startsWith("!")) {
                    if (message.matches("!\\d+")) {
                        int which = Integer.parseInt(message.substring(1));
                        message = this.history.get(which);
                    } else if (message.matches("!-\\d+")) {
                        int which = Integer.parseInt(message.substring(2));
                        message = this.history.getLast(which - 1);
                    } else {
                        message = this.history.findLast(message.substring(1));
                    }
                    echo = true;
                }
            }
        }
        if (error) {
            return "";
        }
        if (!message.isEmpty()) {
            this.history.add(message);
        }
        if (echo) {
            this.putResponse(message);
        }
        return justPush ? "" : message;
    }

    public void close() {
        this.done = true;
    }

    private void printPrompt() {
        if (this.prompt != null) {
            this.out.print(this.prompt);
            this.out.flush();
        }
    }

    public boolean load(String filename) {
        try {
            String inputLine;
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            while ((inputLine = br.readLine()) != null) {
                String response = this.execute(inputLine);
                if (response.equals("OK")) continue;
                this.putResponse(response);
            }
            fr.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public PrintWriter getPrintWriter() {
        return this.out;
    }

    public static void main(String[] args) {
        CommandInterpreter ci = new CommandInterpreter();
        try {
            System.out.println("Welcome to the Command interpreter test program");
            ci.setPrompt("CI> ");
            ci.run();
            System.out.println("Goodbye!");
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    class CommandHistory {
        private final List<String> history = new ArrayList<String>(100);

        CommandHistory() {
        }

        public void add(String command) {
            this.history.add(command);
        }

        public String getLast(int offset) {
            if (this.history.size() > offset) {
                return this.history.get(this.history.size() - 1 - offset);
            }
            CommandInterpreter.this.putResponse("command not found");
            return "";
        }

        public String get(int which) {
            if (this.history.size() > which) {
                return this.history.get(which);
            }
            CommandInterpreter.this.putResponse("command not found");
            return "";
        }

        public String findLast(String match) {
            int i = this.history.size() - 1;
            while (i >= 0) {
                String cmd = this.get(i);
                if (cmd.startsWith(match)) {
                    return cmd;
                }
                --i;
            }
            CommandInterpreter.this.putResponse("command not found");
            return "";
        }

        public void dump() {
            int i = 0;
            while (i < this.history.size()) {
                String cmd = this.get(i);
                CommandInterpreter.this.putResponse(String.valueOf(i) + " " + cmd);
                ++i;
            }
        }
    }
}

