/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.trainer.SimpleTranscript;
import edu.cmu.sphinx.trainer.Transcript;
import edu.cmu.sphinx.trainer.Utterance;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;

public class SimpleUtterance
implements Utterance {
    private String utteranceID;
    private Collection<SimpleTranscript> transcriptSet;
    private Iterator<SimpleTranscript> transcriptIterator;
    private static Logger logger = Logger.getLogger("edu.cmu.sphinx.trainer.SimpleUtterance");

    public SimpleUtterance() {
        this.transcriptSet = new LinkedList<SimpleTranscript>();
    }

    public SimpleUtterance(String utteranceID) {
        logger.info("Utterance ID: " + utteranceID);
        this.utteranceID = utteranceID;
        this.transcriptSet = new LinkedList<SimpleTranscript>();
    }

    @Override
    public void add(String transcript, Dictionary dictionary, boolean isExact, String wordSeparator) {
        logger.info("Transcript: " + transcript);
        this.transcriptSet.add(new SimpleTranscript(transcript, dictionary, isExact, wordSeparator));
    }

    @Override
    public void startTranscriptIterator() {
        this.transcriptIterator = this.transcriptSet.iterator();
    }

    @Override
    public boolean hasMoreTranscripts() {
        return this.transcriptIterator.hasNext();
    }

    @Override
    public Transcript nextTranscript() {
        return this.transcriptIterator.next();
    }

    public String toString() {
        return this.utteranceID;
    }
}

