/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.trainer.Transcript;
import java.util.StringTokenizer;

public class SimpleTranscript
implements Transcript {
    private String transcript;
    private Dictionary dictionary;
    boolean isExact;
    private boolean wasInitialized;
    private StringTokenizer words;
    private String wordSeparator;

    public SimpleTranscript(String transcript) {
        if (!this.wasInitialized) {
            this.initialize(null, false);
        }
        this.transcript = transcript;
    }

    public SimpleTranscript(Dictionary dictionary, boolean isExact) {
        this.initialize(dictionary, isExact);
    }

    public SimpleTranscript(String transcript, Dictionary dictionary, boolean isExact, String wordSeparator) {
        this.transcript = transcript;
        this.dictionary = dictionary;
        this.isExact = isExact;
        this.wordSeparator = wordSeparator;
    }

    public SimpleTranscript(String transcript, Dictionary dictionary, boolean isExact) {
        this.transcript = transcript;
        this.dictionary = dictionary;
        this.isExact = isExact;
        this.wordSeparator = " \t\n\r\f";
    }

    public void initialize(Dictionary dictionary, boolean isExact) {
        this.dictionary = dictionary;
        this.isExact = isExact;
        this.wasInitialized = true;
    }

    @Override
    public String getTranscriptText() {
        return this.transcript;
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public boolean isExact() {
        return this.isExact;
    }

    @Override
    public int numberOfWords() {
        return this.words.countTokens();
    }

    @Override
    public void startWordIterator() {
        this.words = new StringTokenizer(this.transcript, this.wordSeparator);
    }

    @Override
    public boolean hasMoreWords() {
        return this.words.hasMoreTokens();
    }

    @Override
    public String nextWord() {
        return this.words.nextToken();
    }

    public String toString() {
        String result = "";
        result = "Dict: " + this.dictionary + " : transcript ";
        result = this.isExact ? String.valueOf(result) + "IS exact: " : String.valueOf(result) + "is NOT exact: ";
        result = String.valueOf(result) + this.transcript;
        return result;
    }
}

