/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.trainer.ControlFile;
import edu.cmu.sphinx.trainer.SimpleUtterance;
import edu.cmu.sphinx.trainer.TrainerDictionary;
import edu.cmu.sphinx.trainer.Utterance;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class SimpleControlFile
implements ControlFile {
    @S4Component(type=TrainerDictionary.class)
    public static final String DICTIONARY = "dictionary";
    private TrainerDictionary dictionary;
    private String audioFile;
    private String transcriptFile;
    private String wordSeparator;
    private int currentPartition;
    private int numberOfPartitions;
    private Iterator<String> audioFileIterator;
    private Iterator<String> transcriptFileIterator;
    private List<String> audioFileList;
    private List<String> transcriptFileList;
    private Logger logger;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.dictionary = (TrainerDictionary)ps.getComponent(DICTIONARY);
        try {
            this.dictionary.allocate();
        }
        catch (IOException e) {
            throw new PropertyException(e);
        }
        this.audioFile = ps.getString("audioFile");
        this.transcriptFile = ps.getString("transcriptFile");
        this.currentPartition = ps.getInt("whichBatch");
        this.numberOfPartitions = ps.getInt("totalBatches");
        this.logger.info("Audio control file: " + this.audioFile);
        this.logger.info("Transcript file: " + this.transcriptFile);
        this.wordSeparator = " \t\n\r\f";
        this.logger.info("Processing part " + this.currentPartition + " of " + this.numberOfPartitions);
        try {
            this.audioFileList = this.getLines(this.audioFile);
        }
        catch (IOException ioe) {
            throw new Error("IOE: Can't open file " + this.audioFile, ioe);
        }
        try {
            this.transcriptFileList = this.getLines(this.transcriptFile);
        }
        catch (IOException ioe) {
            throw new Error("IOE: Can't open file " + this.transcriptFile, ioe);
        }
    }

    @Override
    public void startUtteranceIterator() {
        this.audioFileIterator = this.audioFileList.iterator();
        this.transcriptFileIterator = this.transcriptFileList.iterator();
    }

    @Override
    public boolean hasMoreUtterances() {
        return this.audioFileIterator.hasNext() && this.transcriptFileIterator.hasNext();
    }

    @Override
    public Utterance nextUtterance() {
        this.logger.fine("processing ext utterance");
        String utteranceLine = String.valueOf(this.audioFileIterator.next()) + ".mfc";
        SimpleUtterance utterance = new SimpleUtterance(utteranceLine);
        String utteranceFilename = utteranceLine.replaceFirst("^.*/", "").replaceFirst("\\..*$", "");
        String transcriptLine = this.transcriptFileIterator.next();
        assert (transcriptLine.matches(".*[ \t]\\(" + utteranceFilename + "\\)$")) : "File name in transcript \"" + transcriptLine + "\" and control file \"" + utteranceFilename + "\" have to match.";
        String transcript = transcriptLine.replaceFirst("[ \t]\\(.*\\)$", "");
        utterance.add(transcript, this.dictionary, false, this.wordSeparator);
        return utterance;
    }

    private List<String> getLines(String file) throws IOException {
        List<String> list = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = reader.readLine()) != null) {
            list.add(line);
        }
        reader.close();
        if (this.numberOfPartitions > 1) {
            int linesPerBatch = list.size() / this.numberOfPartitions;
            if (linesPerBatch < 1) {
                linesPerBatch = 1;
            }
            if (this.currentPartition >= this.numberOfPartitions) {
                this.currentPartition = this.numberOfPartitions - 1;
            }
            int startLine = this.currentPartition * linesPerBatch;
            list = this.currentPartition == this.numberOfPartitions - 1 ? list.subList(startLine, list.size()) : list.subList(startLine, startLine + linesPerBatch);
        }
        return list;
    }
}

