/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.util.StreamCepstrumSource;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.TrainerScore;
import edu.cmu.sphinx.trainer.Learner;
import edu.cmu.sphinx.trainer.Utterance;
import edu.cmu.sphinx.trainer.UtteranceGraph;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.FileInputStream;
import java.io.IOException;

public class FlatInitializerLearner
implements Learner {
    @S4Component(type=FrontEnd.class)
    public static final String FRONT_END = "frontend";
    private FrontEnd frontEnd;
    @S4Component(type=StreamCepstrumSource.class)
    public static final String DATA_SOURCE = "source";
    private StreamCepstrumSource dataSource;
    private Data curFeature;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.dataSource = (StreamCepstrumSource)ps.getComponent(DATA_SOURCE);
        this.frontEnd = (FrontEnd)ps.getComponent(FRONT_END);
        this.frontEnd.setDataSource(this.dataSource);
    }

    @Override
    public void setUtterance(Utterance utterance) throws IOException {
        String file = utterance.toString();
        FileInputStream is = new FileInputStream(file);
        this.dataSource.setInputStream(is, false);
    }

    private boolean getFeature() {
        block8: {
            block7: {
                block6: {
                    try {
                        this.curFeature = this.frontEnd.getData();
                        if (this.curFeature != null) break block6;
                        return false;
                    }
                    catch (DataProcessingException dpe) {
                        System.out.println("DataProcessingException " + dpe);
                        dpe.printStackTrace();
                        return false;
                    }
                }
                if (!(this.curFeature instanceof DataStartSignal)) break block7;
                this.curFeature = this.frontEnd.getData();
                if (this.curFeature != null) break block7;
                return false;
            }
            if (!(this.curFeature instanceof DataEndSignal)) break block8;
            return false;
        }
        if (this.curFeature instanceof Signal) {
            throw new Error("Can't score non-content feature");
        }
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void initializeComputation(Utterance utterance, UtteranceGraph graph) throws IOException {
        this.setUtterance(utterance);
        this.setGraph(graph);
    }

    @Override
    public void setGraph(UtteranceGraph graph) {
        throw new Error("Flat initializer does not use a graph!");
    }

    @Override
    public TrainerScore[] getScore() {
        if (this.getFeature()) {
            TrainerScore[] score = new TrainerScore[]{new TrainerScore(this.curFeature, 0.0f, -1)};
            return score;
        }
        return null;
    }
}

