/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.linguist.acoustic.AcousticModel;
import edu.cmu.sphinx.linguist.acoustic.HMM;
import edu.cmu.sphinx.linguist.acoustic.HMMPosition;
import edu.cmu.sphinx.linguist.acoustic.Unit;
import edu.cmu.sphinx.linguist.acoustic.UnitManager;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.dictionary.Dictionary;
import edu.cmu.sphinx.linguist.dictionary.Pronunciation;
import edu.cmu.sphinx.trainer.Graph;
import edu.cmu.sphinx.trainer.Node;
import edu.cmu.sphinx.trainer.NodeType;
import edu.cmu.sphinx.trainer.TrainerDictionary;
import edu.cmu.sphinx.trainer.Transcript;

public class BuildTranscriptHMM {
    private Graph wordGraph;
    private Graph phonemeGraph;
    private Graph contextDependentPhoneGraph;
    private Graph hmmGraph;
    private TrainerDictionary dictionary;
    private AcousticModel acousticModel;
    private UnitManager unitManager;

    public BuildTranscriptHMM(String context, Transcript transcript, AcousticModel acousticModel, UnitManager unitManager) {
        this.acousticModel = acousticModel;
        this.unitManager = unitManager;
        this.wordGraph = this.buildWordGraph(transcript);
        assert (this.wordGraph.validate()) : "Word graph not validated";
        this.phonemeGraph = this.buildPhonemeGraph(this.wordGraph);
        assert (this.phonemeGraph.validate()) : "Phone graph not validated";
        this.contextDependentPhoneGraph = this.buildContextDependentPhonemeGraph(this.phonemeGraph);
        assert (this.contextDependentPhoneGraph.validate()) : "Context dependent graph not validated";
        this.hmmGraph = this.buildHMMGraph(this.contextDependentPhoneGraph);
        assert (this.hmmGraph.validate()) : "HMM graph not validated";
    }

    public Graph getGraph() {
        return this.hmmGraph;
    }

    private Graph buildWordGraph(Transcript transcript) {
        Dictionary transcriptDict = transcript.getDictionary();
        assert (transcriptDict.getClass().getName().endsWith("TrainerDictionary"));
        this.dictionary = (TrainerDictionary)transcriptDict;
        transcript.startWordIterator();
        Graph graph = new Graph();
        Node initialNode = new Node(NodeType.UTTERANCE_BEGIN);
        graph.addNode(initialNode);
        graph.setInitialNode(initialNode);
        if (transcript.isExact()) {
            Node wordNode;
            Node prevNode = initialNode;
            transcript.startWordIterator();
            while (transcript.hasMoreWords()) {
                wordNode = new Node(NodeType.WORD, transcript.nextWord());
                graph.linkNodes(prevNode, wordNode);
                prevNode = wordNode;
            }
            wordNode = new Node(NodeType.UTTERANCE_END);
            graph.linkNodes(prevNode, wordNode);
            graph.setFinalNode(wordNode);
        } else {
            Node silLoopBack = new Node(NodeType.SILENCE_WITH_LOOPBACK);
            graph.linkNodes(initialNode, silLoopBack);
            transcript.startWordIterator();
            while (transcript.hasMoreWords()) {
                String word = transcript.nextWord();
                Pronunciation[] pronunciations = this.dictionary.getWord(word).getPronunciations();
                int numberOfPronunciations = pronunciations.length;
                Node[] pronNode = new Node[numberOfPronunciations];
                Node dummyWordBeginNode = new Node(NodeType.DUMMY);
                graph.linkNodes(silLoopBack, dummyWordBeginNode);
                Node dummyWordEndNode = new Node(NodeType.DUMMY);
                int i = 0;
                while (i < numberOfPronunciations) {
                    String wordAlternate = pronunciations[i].getWord().getSpelling();
                    if (i > 0) {
                        wordAlternate = String.valueOf(wordAlternate) + "(" + i + ')';
                    }
                    pronNode[i] = new Node(NodeType.WORD, wordAlternate);
                    graph.linkNodes(dummyWordBeginNode, pronNode[i]);
                    graph.linkNodes(pronNode[i], dummyWordEndNode);
                    ++i;
                }
                silLoopBack = new Node(NodeType.SILENCE_WITH_LOOPBACK);
                graph.linkNodes(dummyWordEndNode, silLoopBack);
            }
            Node wordNode = new Node(NodeType.UTTERANCE_END);
            graph.linkNodes(silLoopBack, wordNode);
            graph.setFinalNode(wordNode);
        }
        return graph;
    }

    private Graph buildPhonemeGraph(Graph wordGraph) {
        Graph phonemeGraph = new Graph();
        phonemeGraph.copyGraph(wordGraph);
        Node[] nodeArray = phonemeGraph.nodeToArray();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node.getType().equals(NodeType.WORD)) {
                String word = node.getID();
                Graph pronunciationGraph = this.dictionary.getWordGraph(word, false);
                phonemeGraph.insertGraph(pronunciationGraph, node);
            }
            ++n2;
        }
        return phonemeGraph;
    }

    public Graph buildContextDependentPhonemeGraph(Graph phonemeGraph) {
        Graph cdGraph = new Graph();
        cdGraph.copyGraph(phonemeGraph);
        return cdGraph;
    }

    public Graph buildHMMGraph(Graph cdGraph) {
        Graph hmmGraph = new Graph();
        hmmGraph.copyGraph(cdGraph);
        Node[] nodeArray = hmmGraph.nodeToArray();
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Unit unit;
                Node node;
                block4: {
                    block3: {
                        node = nodeArray[n2];
                        unit = null;
                        if (!node.getType().equals(NodeType.PHONE)) break block3;
                        unit = this.unitManager.getUnit(node.getID());
                        break block4;
                    }
                    if (!node.getType().equals(NodeType.SILENCE_WITH_LOOPBACK)) break block5;
                    unit = this.unitManager.getUnit("SIL");
                }
                HMM hmm = this.acousticModel.lookupNearestHMM(unit, HMMPosition.UNDEFINED, false);
                Graph modelGraph = this.buildModelGraph((SenoneHMM)hmm);
                modelGraph.validate();
                hmmGraph.insertGraph(modelGraph, node);
            }
            ++n2;
        }
        return hmmGraph;
    }

    private Graph buildModelGraph(SenoneHMM hmm) {
        Graph graph = new Graph();
        Node stateNode = null;
        float[][] tmat = hmm.getTransitionMatrix();
        Node prevNode = new Node(NodeType.DUMMY);
        graph.addNode(prevNode);
        graph.setInitialNode(prevNode);
        int i = 0;
        while (i < hmm.getOrder() + 1) {
            stateNode = new Node(NodeType.STATE, hmm.getUnit().getName());
            stateNode.setObject(hmm.getState(i));
            graph.addNode(stateNode);
            if (i == 0) {
                graph.linkNodes(prevNode, stateNode);
            }
            int j = 0;
            while (j <= i) {
                if (tmat[j][i] != -3.4028235E38f) {
                    graph.linkNodes(graph.getNode(j + 1), stateNode);
                }
                ++j;
            }
            prevNode = stateNode;
            ++i;
        }
        graph.setFinalNode(stateNode);
        return graph;
    }
}

