/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.trainer;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DataProcessingException;
import edu.cmu.sphinx.frontend.DataStartSignal;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.Signal;
import edu.cmu.sphinx.frontend.util.StreamCepstrumSource;
import edu.cmu.sphinx.linguist.acoustic.HMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMM;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.SenoneHMMState;
import edu.cmu.sphinx.linguist.acoustic.tiedstate.trainer.TrainerScore;
import edu.cmu.sphinx.trainer.Edge;
import edu.cmu.sphinx.trainer.Learner;
import edu.cmu.sphinx.trainer.Node;
import edu.cmu.sphinx.trainer.Utterance;
import edu.cmu.sphinx.trainer.UtteranceGraph;
import edu.cmu.sphinx.util.LogMath;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Component;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class BaumWelchLearner
implements Learner {
    @S4Component(type=FrontEnd.class)
    public static final String FRONT_END = "frontend";
    private FrontEnd frontEnd;
    @S4Component(type=StreamCepstrumSource.class)
    public static final String DATA_SOURCE = "source";
    private StreamCepstrumSource dataSource;
    private LogMath logMath;
    private static Logger logger = Logger.getLogger("edu.cmu.sphinx.trainer.BaumWelch");
    private Data curFeature;
    private UtteranceGraph graph;
    private TrainerScore[][] scoreArray;
    private int lastFeatureIndex;
    private int currentFeatureIndex;
    private float[] betas;
    private float[] outputProbs;
    private float[] componentScores;
    private float[] probCurrentFrame;
    private float totalLogScore;

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logMath = LogMath.getLogMath();
        this.dataSource = (StreamCepstrumSource)ps.getComponent(DATA_SOURCE);
        this.frontEnd = (FrontEnd)ps.getComponent(FRONT_END);
        this.frontEnd.setDataSource(this.dataSource);
    }

    protected FrontEnd getFrontEnd() {
        return this.frontEnd;
    }

    @Override
    public void setUtterance(Utterance utterance) throws IOException {
        String file = utterance.toString();
        FileInputStream is = new FileInputStream(file);
        this.dataSource.setInputStream(is, false);
    }

    private boolean getFeature() {
        block8: {
            block7: {
                block6: {
                    try {
                        this.curFeature = this.frontEnd.getData();
                        if (this.curFeature != null) break block6;
                        return false;
                    }
                    catch (DataProcessingException dpe) {
                        System.out.println("DataProcessingException " + dpe);
                        dpe.printStackTrace();
                        return false;
                    }
                }
                if (!(this.curFeature instanceof DataStartSignal)) break block7;
                this.curFeature = this.frontEnd.getData();
                if (this.curFeature != null) break block7;
                return false;
            }
            if (!(this.curFeature instanceof DataEndSignal)) break block8;
            return false;
        }
        if (this.curFeature instanceof Signal) {
            throw new Error("Can't score non-content feature");
        }
        return true;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void initializeComputation(Utterance utterance, UtteranceGraph graph) throws IOException {
        this.setUtterance(utterance);
        this.setGraph(graph);
    }

    @Override
    public void setGraph(UtteranceGraph graph) {
        this.graph = graph;
    }

    private TrainerScore[][] prepareScore() {
        ArrayList<TrainerScore[]> scoreList = new ArrayList<TrainerScore[]>();
        int numStates = this.graph.size();
        TrainerScore[] score = new TrainerScore[numStates];
        this.betas = new float[numStates];
        this.outputProbs = new float[numStates];
        this.probCurrentFrame = new float[numStates];
        Node initialNode = this.graph.getInitialNode();
        int indexInitialNode = this.graph.indexOf(initialNode);
        int i = 0;
        while (i < numStates) {
            this.probCurrentFrame[i] = -3.4028235E38f;
            ++i;
        }
        this.probCurrentFrame[indexInitialNode] = 0.0f;
        initialNode.startOutgoingEdgeIterator();
        while (initialNode.hasMoreOutgoingEdges()) {
            Edge edge = initialNode.nextOutgoingEdge();
            Node node = edge.getDestination();
            int index = this.graph.indexOf(node);
            if (!node.isType("STATE")) {
                this.probCurrentFrame[index] = 0.0f;
                continue;
            }
            HMMState state = (HMMState)node.getObject();
            if (!state.isEmitting()) {
                this.probCurrentFrame[index] = 0.0f;
            }
            assert (false);
        }
        this.lastFeatureIndex = 0;
        while (this.getFeature()) {
            this.forwardPass(score);
            scoreList.add(score);
            ++this.lastFeatureIndex;
        }
        logger.info("Feature frames read: " + this.lastFeatureIndex);
        i = 0;
        while (i < this.probCurrentFrame.length) {
            this.probCurrentFrame[i] = -3.4028235E38f;
            ++i;
        }
        Node finalNode = this.graph.getFinalNode();
        int indexFinalNode = this.graph.indexOf(finalNode);
        this.probCurrentFrame[indexFinalNode] = 0.0f;
        finalNode.startIncomingEdgeIterator();
        while (finalNode.hasMoreIncomingEdges()) {
            Edge edge = finalNode.nextIncomingEdge();
            Node node = edge.getSource();
            int index = this.graph.indexOf(node);
            if (!node.isType("STATE")) {
                this.probCurrentFrame[index] = 0.0f;
                assert (false);
                continue;
            }
            HMMState state = (HMMState)node.getObject();
            if (state.isEmitting()) continue;
            this.probCurrentFrame[index] = 0.0f;
        }
        return (TrainerScore[][])scoreList.toArray((T[])new TrainerScore[scoreList.size()][]);
    }

    @Override
    public TrainerScore[] getScore() {
        if (this.scoreArray == null) {
            this.scoreArray = this.prepareScore();
            this.currentFeatureIndex = this.lastFeatureIndex;
        }
        --this.currentFeatureIndex;
        if (this.currentFeatureIndex >= 0) {
            float logScore = -3.4028235E38f;
            TrainerScore[] score = this.scoreArray[this.currentFeatureIndex];
            assert (score.length == this.betas.length);
            this.backwardPass(score);
            int i = 0;
            while (i < this.betas.length) {
                score[i].setGamma();
                logScore = this.logMath.addAsLinear(logScore, score[i].getGamma());
                ++i;
            }
            if (this.currentFeatureIndex == this.lastFeatureIndex - 1) {
                TrainerScore.setLogLikelihood(logScore);
                this.totalLogScore = logScore;
            } else if (Math.abs(this.totalLogScore - logScore) > Math.abs(this.totalLogScore)) {
                System.out.println("WARNING: log probabilities differ: " + this.totalLogScore + " and " + logScore);
            }
            return score;
        }
        this.scoreArray = null;
        return null;
    }

    private float calculateScores(int index) {
        float logScore;
        SenoneHMMState state = (SenoneHMMState)this.graph.getNode(index).getObject();
        if (state != null && state.isEmitting()) {
            this.componentScores = state.calculateComponentScore(this.curFeature);
            logScore = state.getScore(this.curFeature);
            assert (this.componentScores.length == 1);
        } else {
            this.componentScores = null;
            logScore = 0.0f;
        }
        return logScore;
    }

    /*
     * Unable to fully structure code
     */
    private void forwardPass(TrainerScore[] score) {
        i = 0;
        while (i < this.graph.size()) {
            this.outputProbs[i] = this.calculateScores(i);
            score[i] = new TrainerScore(this.curFeature, this.outputProbs[i], (HMMState)this.graph.getNode(i).getObject(), this.componentScores);
            score[i].setAlpha(this.probCurrentFrame[i]);
            ++i;
        }
        probPreviousFrame = this.probCurrentFrame;
        this.probCurrentFrame = new float[this.graph.size()];
        indexNode = 0;
        while (indexNode < this.graph.size()) {
            node = this.graph.getNode(indexNode);
            if (node.isType("STATE")) {
                state = (SenoneHMMState)node.getObject();
                hmm = (SenoneHMM)state.getHMM();
                if (state.isEmitting()) {
                    this.probCurrentFrame[indexNode] = -3.4028235E38f;
                    node.startIncomingEdgeIterator();
                    while (node.hasMoreIncomingEdges()) {
                        previousNode = node.nextIncomingEdge().getSource();
                        indexPreviousNode = this.graph.indexOf(previousNode);
                        previousState = (HMMState)previousNode.getObject();
                        if (previousState != null) {
                            if (!BaumWelchLearner.$assertionsDisabled && previousState.isEmitting() && previousState.getHMM() != hmm) {
                                throw new AssertionError();
                            }
                            logTransitionProbability = !previousState.isEmitting() ? 0.0f : hmm.getTransitionProbability(previousState.getState(), state.getState());
                        } else {
                            logTransitionProbability = 0.0f;
                        }
                        this.probCurrentFrame[indexNode] = this.logMath.addAsLinear(this.probCurrentFrame[indexNode], probPreviousFrame[indexPreviousNode] + logTransitionProbability);
                    }
                    v0 = indexNode;
                    this.probCurrentFrame[v0] = this.probCurrentFrame[v0] + this.outputProbs[indexNode];
                    score[indexNode].setAlpha(this.probCurrentFrame[indexNode]);
                }
            }
            ++indexNode;
        }
        indexNode = 0;
        while (indexNode < this.graph.size()) {
            block16: {
                block15: {
                    node = this.graph.getNode(indexNode);
                    state = null;
                    hmm = null;
                    if (!node.isType("STATE")) break block15;
                    state = (HMMState)node.getObject();
                    hmm = (SenoneHMM)state.getHMM();
                    if (!state.isEmitting()) ** GOTO lbl-1000
                    break block16;
                }
                if (this.graph.isInitialNode(node)) {
                    score[indexNode].setAlpha(-3.4028235E38f);
                    this.probCurrentFrame[indexNode] = -3.4028235E38f;
                } else lbl-1000:
                // 2 sources

                {
                    this.probCurrentFrame[indexNode] = -3.4028235E38f;
                    node.startIncomingEdgeIterator();
                    while (node.hasMoreIncomingEdges()) {
                        previousNode = node.nextIncomingEdge().getSource();
                        indexPreviousNode = this.graph.indexOf(previousNode);
                        if (previousNode.isType("STATE")) {
                            previousState = (HMMState)previousNode.getObject();
                            if (!BaumWelchLearner.$assertionsDisabled && previousState.isEmitting() && previousState.getHMM() != hmm) {
                                throw new AssertionError();
                            }
                            logTransitionProbability = !previousState.isEmitting() ? 0.0f : hmm.getTransitionProbability(previousState.getState(), state.getState());
                        } else {
                            logTransitionProbability = 0.0f;
                        }
                        this.probCurrentFrame[indexNode] = this.logMath.addAsLinear(this.probCurrentFrame[indexNode], this.probCurrentFrame[indexPreviousNode] + logTransitionProbability);
                    }
                    score[indexNode].setAlpha(this.probCurrentFrame[indexNode]);
                }
            }
            ++indexNode;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void backwardPass(TrainerScore[] score) {
        i = 0;
        while (i < this.graph.size()) {
            this.outputProbs[i] = score[i].getScore();
            score[i].setBeta(this.probCurrentFrame[i]);
            ++i;
        }
        probNextFrame = this.probCurrentFrame;
        this.probCurrentFrame = new float[this.graph.size()];
        indexNode = 0;
        while (indexNode < this.graph.size()) {
            node = this.graph.getNode(indexNode);
            if (node.isType("STATE")) {
                state = (HMMState)node.getObject();
                hmm = (SenoneHMM)state.getHMM();
                if (state.isEmitting()) {
                    this.probCurrentFrame[indexNode] = -3.4028235E38f;
                    node.startOutgoingEdgeIterator();
                    while (node.hasMoreOutgoingEdges()) {
                        nextNode = node.nextOutgoingEdge().getDestination();
                        indexNextNode = this.graph.indexOf(nextNode);
                        nextState = (HMMState)nextNode.getObject();
                        if (nextState != null) {
                            if (!BaumWelchLearner.$assertionsDisabled && nextState.isEmitting() && nextState.getHMM() != hmm) {
                                throw new AssertionError();
                            }
                            logTransitionProbability = nextState.getHMM() != hmm ? 0.0f : hmm.getTransitionProbability(state.getState(), nextState.getState());
                        } else {
                            logTransitionProbability = 0.0f;
                        }
                        this.probCurrentFrame[indexNode] = this.logMath.addAsLinear(this.probCurrentFrame[indexNode], probNextFrame[indexNextNode] + logTransitionProbability + this.outputProbs[indexNextNode]);
                    }
                    score[indexNode].setBeta(this.probCurrentFrame[indexNode]);
                }
            }
            ++indexNode;
        }
        indexNode = this.graph.size() - 1;
        while (indexNode >= 0) {
            block16: {
                block15: {
                    node = this.graph.getNode(indexNode);
                    state = null;
                    if (!node.isType("STATE")) break block15;
                    state = (HMMState)node.getObject();
                    if (!state.isEmitting()) ** GOTO lbl-1000
                    break block16;
                }
                if (this.graph.isFinalNode(node)) {
                    score[indexNode].setBeta(-3.4028235E38f);
                    this.probCurrentFrame[indexNode] = -3.4028235E38f;
                } else lbl-1000:
                // 2 sources

                {
                    this.probCurrentFrame[indexNode] = -3.4028235E38f;
                    node.startOutgoingEdgeIterator();
                    while (node.hasMoreOutgoingEdges()) {
                        nextNode = node.nextOutgoingEdge().getDestination();
                        indexNextNode = this.graph.indexOf(nextNode);
                        if (nextNode.isType("STATE")) {
                            nextState = (HMMState)nextNode.getObject();
                            if (!BaumWelchLearner.$assertionsDisabled && !nextState.isEmitting() && nextState != state) {
                                throw new AssertionError();
                            }
                            logTransitionProbability = 0.0f;
                        } else {
                            logTransitionProbability = 0.0f;
                        }
                        this.probCurrentFrame[indexNode] = this.logMath.addAsLinear(this.probCurrentFrame[indexNode], this.probCurrentFrame[indexNextNode] + logTransitionProbability);
                    }
                    score[indexNode].setBeta(this.probCurrentFrame[indexNode]);
                }
            }
            --indexNode;
        }
    }
}

