/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.batch;

import edu.cmu.sphinx.decoder.search.Token;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.util.StreamCepstrumSource;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.linguist.WordSearchState;
import edu.cmu.sphinx.linguist.dictionary.Word;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.tools.batch.BatchModeRecognizer;
import edu.cmu.sphinx.util.Utilities;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class BatchNISTRecognizer
extends BatchModeRecognizer {
    protected String ctlFile;
    protected String dataDir;
    protected String refFile;
    protected String ctmFile;
    protected int bitsPerSample;
    protected int samplesPerSecond;
    protected int framesPerSecond;
    protected int channelCount;
    protected int bytesPerFrame;
    @S4String(defaultValue="<raw data directory not set>")
    public static final String PROP_DATA_DIR = "dataDirectory";
    @S4String(defaultValue="<ctl file not set>")
    public static final String PROP_CTL_FILE = "ctlFile";
    @S4String(defaultValue="<ref file not set>")
    public static final String PROP_REF_FILE = "refFile";
    @S4String(defaultValue="<ctm file not set>")
    public static final String PROP_CTM_FILE = "ctmFile";
    @S4Integer(defaultValue=16)
    public static final String PROP_BITS_PER_SAMPLE = "bitsPerSample";
    @S4Integer(defaultValue=1)
    public static final String PROP_CHANNEL_COUNT = "channelCount";
    @S4Integer(defaultValue=16000)
    public static final String PROP_SAMPLES_PER_SECOND = "samplesPerSecond";
    @S4Integer(defaultValue=100)
    public static final String PROP_FRAMES_PER_SECOND = "framesPerSecond";

    public BatchNISTRecognizer(Recognizer recognizer, List<DataProcessor> inputDataProcessors, String ctlFile, String dataDir, String refFile, String ctmFile, int bitsPerSample, int samplesPerSecond, int framesPerSecond, int channelCount) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.recognizer = recognizer;
        this.inputDataProcessors = inputDataProcessors;
        this.dataDir = dataDir;
        this.ctlFile = ctlFile;
        this.refFile = refFile;
        this.ctmFile = ctmFile;
        this.bitsPerSample = bitsPerSample;
        this.channelCount = channelCount;
        this.samplesPerSecond = samplesPerSecond;
        this.framesPerSecond = framesPerSecond;
        this.bytesPerFrame = bitsPerSample / 8 * channelCount * samplesPerSecond / framesPerSecond;
        this.logger.info("BatchNISTRecognizer:\n  dataDirectory=" + dataDir + '\n' + "  ctlFile=" + ctlFile + '\n' + "  bitsPerSample=" + bitsPerSample + '\n' + "  channelCount=" + channelCount + '\n' + "  samplesPerSecond=" + samplesPerSecond + '\n' + "  framesPerSecond=" + framesPerSecond + '\n');
    }

    public BatchNISTRecognizer() {
    }

    @Override
    public void newProperties(PropertySheet ps) throws PropertyException {
        this.logger = ps.getLogger();
        this.recognizer = (Recognizer)ps.getComponent("recognizer");
        this.inputDataProcessors = ps.getComponentList("inputDataProcessors", DataProcessor.class);
        this.dataDir = ps.getString(PROP_DATA_DIR);
        this.ctlFile = ps.getString(PROP_CTL_FILE);
        this.refFile = ps.getString(PROP_REF_FILE);
        this.ctmFile = ps.getString(PROP_CTM_FILE);
        this.bitsPerSample = ps.getInt(PROP_BITS_PER_SAMPLE);
        this.channelCount = ps.getInt(PROP_CHANNEL_COUNT);
        this.samplesPerSecond = ps.getInt(PROP_SAMPLES_PER_SECOND);
        this.framesPerSecond = ps.getInt(PROP_FRAMES_PER_SECOND);
        this.bytesPerFrame = this.bitsPerSample / 8 * this.channelCount * this.samplesPerSecond / this.framesPerSecond;
        this.logger.info("BatchNISTRecognizer:\n  dataDirectory=" + this.dataDir + '\n' + "  ctlFile=" + this.ctlFile + '\n' + "  bitsPerSample=" + this.bitsPerSample + '\n' + "  channelCount=" + this.channelCount + '\n' + "  samplesPerSecond=" + this.samplesPerSecond + '\n' + "  framesPerSecond=" + this.framesPerSecond + '\n');
    }

    protected void setInputStream(CTLUtterance utt) throws IOException {
        for (DataProcessor dataSource : this.inputDataProcessors) {
            if (dataSource instanceof StreamDataSource) {
                ((StreamDataSource)dataSource).setInputStream(utt.getInputStream());
                continue;
            }
            if (!(dataSource instanceof StreamCepstrumSource)) continue;
            boolean isBigEndian = Utilities.isCepstraFileBigEndian(utt.getName());
            StreamCepstrumSource cepstrumSource = (StreamCepstrumSource)dataSource;
            cepstrumSource.setInputStream(utt.getInputStream(), isBigEndian);
        }
    }

    public void decode() {
        try {
            this.utteranceId = 0;
            DataOutputStream ctm = new DataOutputStream(new FileOutputStream(this.ctmFile));
            this.recognizer.allocate();
            CTLIterator i = new CTLIterator();
            while (i.hasNext()) {
                CTLUtterance utt = (CTLUtterance)i.next();
                this.setInputStream(utt);
                Result result = this.recognizer.recognize();
                System.out.println("Utterance " + this.utteranceId + ": " + utt.getName());
                System.out.println("Reference: " + utt.getRef());
                System.out.println("Result   : " + result);
                this.logger.info("Utterance " + this.utteranceId + ": " + utt.getName());
                this.logger.info("Result   : " + result);
                this.handleResult(ctm, utt, result);
                ++this.utteranceId;
            }
            this.recognizer.deallocate();
        }
        catch (IOException io) {
            this.logger.severe("I/O error during decoding: " + io.getMessage());
        }
        this.logger.info("BatchCTLDecoder: " + this.utteranceId + " utterances decoded");
    }

    protected void handleResult(DataOutputStream out, CTLUtterance utt, Result result) throws IOException {
        this.dumpBestPath(out, utt, result.getBestFinalToken());
    }

    private long dumpBestPath(DataOutputStream out, CTLUtterance utt, Token token) throws IOException {
        if (token == null) {
            return 0L;
        }
        Token pred = token.getPredecessor();
        long startFrame = this.dumpBestPath(out, utt, pred);
        if (token.isWord()) {
            long endFrame = token.getCollectTime();
            WordSearchState wordState = (WordSearchState)token.getSearchState();
            Word word = wordState.getPronunciation().getWord();
            String spelling = word.getSpelling();
            if (!spelling.startsWith("<")) {
                String[] names = utt.name.split("_");
                out.write((String.valueOf(names[0]) + '_' + names[1] + '_' + names[2] + " 1 " + (double)((long)utt.startOffset + startFrame) / 100.0 + ' ' + (double)(endFrame - startFrame) / 100.0 + ' ').getBytes());
                out.write(BatchNISTRecognizer.hex2Binary(spelling));
                out.write(" 0.700000\n".getBytes());
            }
            return endFrame;
        }
        return startFrame;
    }

    public static byte[] hex2Binary(String spelling) {
        byte[] bin = new byte[spelling.length() / 2];
        int i = 0;
        while (i < spelling.length()) {
            int i0 = BatchNISTRecognizer.hexToByte(spelling.charAt(i));
            int i1 = BatchNISTRecognizer.hexToByte(spelling.charAt(i + 1));
            bin[i / 2] = (byte)(i1 + 16 * i0);
            i += 2;
        }
        return bin;
    }

    private static int hexToByte(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        throw new Error("Bad hex char " + c);
    }

    public static void main(String[] argv) {
        BatchNISTRecognizer bmr;
        if (argv.length != 1) {
            System.out.println("Usage: BatchNISTRecognizer propertiesFile");
            System.exit(1);
        }
        String propertiesFile = argv[0];
        try {
            URL url = new File(propertiesFile).toURI().toURL();
            ConfigurationManager cm = new ConfigurationManager(url);
            bmr = (BatchNISTRecognizer)cm.lookup("batchNIST");
        }
        catch (IOException ioe) {
            System.err.println("I/O error during initialization: \n   " + ioe);
            return;
        }
        catch (PropertyException e) {
            System.err.println("Error during initialization: \n  " + e);
            return;
        }
        if (bmr == null) {
            System.err.println("Can't find batchNIST in " + propertiesFile);
            return;
        }
        bmr.decode();
    }

    protected class CTLException
    extends Exception {
        CTLException(String msg) {
            super(msg);
        }
    }

    protected class CTLIterator
    implements Iterator<CTLUtterance> {
        CTLUtterance utterance;
        LineNumberReader ctlReader;
        LineNumberReader refReader;

        public CTLIterator() throws IOException {
            this.ctlReader = new LineNumberReader(new FileReader(BatchNISTRecognizer.this.ctlFile));
            this.refReader = new LineNumberReader(new FileReader(BatchNISTRecognizer.this.refFile));
            this.utterance = this.nextUtterance();
        }

        private CTLUtterance nextUtterance() {
            String ref;
            String ctl;
            block3: {
                try {
                    ctl = this.ctlReader.readLine();
                    ref = this.refReader.readLine();
                    if (ctl != null && ref != null) break block3;
                    return null;
                }
                catch (Exception e) {
                    throw new Error(e.getMessage());
                }
            }
            return new CTLUtterance(ctl, ref);
        }

        @Override
        public boolean hasNext() {
            return this.utterance != null;
        }

        @Override
        public CTLUtterance next() {
            CTLUtterance u = this.utterance;
            this.utterance = this.nextUtterance();
            return u;
        }

        @Override
        public void remove() {
            throw new Error("Not implemented");
        }
    }

    public class CTLUtterance {
        int startOffset;
        int endOffset;
        String name;
        byte[] data;
        final String ref;
        String file;

        public String getFile() {
            return this.file;
        }

        CTLUtterance(String ctl, String ref) throws CTLException {
            this.ref = ref;
            String[] fields = ctl.split(" ");
            if (fields.length != 4) {
                throw new CTLException("CTL Syntax Error: " + ctl);
            }
            this.startOffset = Integer.parseInt(fields[1]);
            this.endOffset = Integer.parseInt(fields[2]);
            this.name = fields[3];
            this.data = new byte[(this.endOffset - this.startOffset) * BatchNISTRecognizer.this.bytesPerFrame];
            int i = fields[0].indexOf(46);
            this.file = fields[0];
            if (i >= 0) {
                this.file = this.file.substring(0, i);
            }
            this.file = String.valueOf(BatchNISTRecognizer.this.dataDir) + '/' + this.file + ".raw";
            try {
                FileInputStream dataStream = new FileInputStream(this.file);
                ((InputStream)dataStream).skip(this.startOffset * BatchNISTRecognizer.this.bytesPerFrame);
                if (((InputStream)dataStream).read(this.data) != this.data.length) {
                    ((InputStream)dataStream).close();
                    throw new CTLException("Unable to read " + this.data.length + " bytes of utterance " + this.name);
                }
                ((InputStream)dataStream).close();
            }
            catch (IOException e) {
                throw new CTLException("Unable to read utterance " + this.name + ": " + e.getMessage());
            }
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.data);
        }

        public String getName() {
            return this.name;
        }

        public String getRef() {
            return this.ref;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

