/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.bandwidth;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataProcessor;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.frequencywarp.MelFrequencyFilterBank;
import edu.cmu.sphinx.frontend.transform.DiscreteFourierTransform;
import edu.cmu.sphinx.frontend.util.AudioFileDataSource;
import edu.cmu.sphinx.frontend.window.RaisedCosineWindower;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;

public class BandDetector {
    static final int bands = 40;
    static final int highRangeStart = 35;
    static final int highRangeEnd = 39;
    static final int lowRangeStart = 23;
    static final int lowRangeEnd = 29;
    static final double noSignalLevel = 0.02;
    static final double signalLevel = 0.5;
    static final double lowIntensity = 100000.0;
    private FrontEnd frontend;
    private AudioFileDataSource source = new AudioFileDataSource(320, null);

    public BandDetector() {
        RaisedCosineWindower windower = new RaisedCosineWindower(0.97f, 25.625f, 10.0f);
        DiscreteFourierTransform fft = new DiscreteFourierTransform(512, false);
        MelFrequencyFilterBank filterbank = new MelFrequencyFilterBank(130.0, 6800.0, 40);
        ArrayList<DataProcessor> list = new ArrayList<DataProcessor>();
        list.add(this.source);
        list.add(windower);
        list.add(fft);
        list.add(filterbank);
        this.frontend = new FrontEnd(list);
    }

    public static void main(String[] args) throws FileNotFoundException {
        if (args.length < 1) {
            System.out.println("Usage: Detector <filename.wav> or Detector <filelist>");
            return;
        }
        if (args[0].endsWith(".wav")) {
            BandDetector detector = new BandDetector();
            System.out.println("Bandwidth for " + args[0] + " is " + detector.bandwidth(args[0]));
        } else {
            BandDetector detector = new BandDetector();
            Scanner s = new Scanner(new File(args[0]));
            while (s.hasNextLine()) {
                String line = s.nextLine().trim();
                if (!detector.bandwidth(line)) continue;
                System.out.println("Bandwidth for " + line + " is low");
            }
            s.close();
        }
    }

    public boolean bandwidth(String file) {
        Data data;
        this.source.setAudioFile(new File(file), "");
        double[] energy = new double[40];
        while ((data = this.frontend.getData()) != null) {
            if (!(data instanceof DoubleData)) continue;
            double maxIntensity = 100000.0;
            double[] frame = ((DoubleData)data).getValues();
            int i = 0;
            while (i < 40) {
                maxIntensity = Math.max(maxIntensity, frame[i]);
                ++i;
            }
            if (maxIntensity <= 100000.0) continue;
            i = 0;
            while (i < 40) {
                energy[i] = Math.max(frame[i] / maxIntensity, energy[i]);
                ++i;
            }
        }
        double maxLow = this.max(energy, 23, 29);
        double maxHi = this.max(energy, 35, 39);
        return maxHi < 0.02 && maxLow > 0.5;
    }

    private double max(double[] energy, int start, int end) {
        double max = 0.0;
        int i = start;
        while (i <= end) {
            max = Math.max(max, energy[i]);
            ++i;
        }
        return max;
    }
}

