/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.RawReader;
import edu.cmu.sphinx.tools.audio.RawWriter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Utils {
    private static final short[] ulawTable;

    static {
        short[] sArray = new short[256];
        sArray[0] = 32760;
        sArray[1] = 31608;
        sArray[2] = 30584;
        sArray[3] = 29560;
        sArray[4] = 28536;
        sArray[5] = 27512;
        sArray[6] = 26488;
        sArray[7] = 25464;
        sArray[8] = 24440;
        sArray[9] = 23416;
        sArray[10] = 22392;
        sArray[11] = 21368;
        sArray[12] = 20344;
        sArray[13] = 19320;
        sArray[14] = 18296;
        sArray[15] = 17272;
        sArray[16] = 16248;
        sArray[17] = 15736;
        sArray[18] = 15224;
        sArray[19] = 14712;
        sArray[20] = 14200;
        sArray[21] = 13688;
        sArray[22] = 13176;
        sArray[23] = 12664;
        sArray[24] = 12152;
        sArray[25] = 11640;
        sArray[26] = 11128;
        sArray[27] = 10616;
        sArray[28] = 10104;
        sArray[29] = 9592;
        sArray[30] = 9080;
        sArray[31] = 8568;
        sArray[32] = 8056;
        sArray[33] = 7800;
        sArray[34] = 7544;
        sArray[35] = 7288;
        sArray[36] = 7032;
        sArray[37] = 6776;
        sArray[38] = 6520;
        sArray[39] = 6264;
        sArray[40] = 6008;
        sArray[41] = 5752;
        sArray[42] = 5496;
        sArray[43] = 5240;
        sArray[44] = 4984;
        sArray[45] = 4728;
        sArray[46] = 4472;
        sArray[47] = 4216;
        sArray[48] = 3960;
        sArray[49] = 3832;
        sArray[50] = 3704;
        sArray[51] = 3576;
        sArray[52] = 3448;
        sArray[53] = 3320;
        sArray[54] = 3192;
        sArray[55] = 3064;
        sArray[56] = 2936;
        sArray[57] = 2808;
        sArray[58] = 2680;
        sArray[59] = 2552;
        sArray[60] = 2424;
        sArray[61] = 2296;
        sArray[62] = 2168;
        sArray[63] = 2040;
        sArray[64] = 1912;
        sArray[65] = 1848;
        sArray[66] = 1784;
        sArray[67] = 1720;
        sArray[68] = 1656;
        sArray[69] = 1592;
        sArray[70] = 1528;
        sArray[71] = 1464;
        sArray[72] = 1400;
        sArray[73] = 1336;
        sArray[74] = 1272;
        sArray[75] = 1208;
        sArray[76] = 1144;
        sArray[77] = 1080;
        sArray[78] = 1016;
        sArray[79] = 952;
        sArray[80] = 888;
        sArray[81] = 856;
        sArray[82] = 824;
        sArray[83] = 792;
        sArray[84] = 760;
        sArray[85] = 728;
        sArray[86] = 696;
        sArray[87] = 664;
        sArray[88] = 632;
        sArray[89] = 600;
        sArray[90] = 568;
        sArray[91] = 536;
        sArray[92] = 504;
        sArray[93] = 472;
        sArray[94] = 440;
        sArray[95] = 408;
        sArray[96] = 376;
        sArray[97] = 360;
        sArray[98] = 344;
        sArray[99] = 328;
        sArray[100] = 312;
        sArray[101] = 296;
        sArray[102] = 280;
        sArray[103] = 264;
        sArray[104] = 248;
        sArray[105] = 232;
        sArray[106] = 216;
        sArray[107] = 200;
        sArray[108] = 184;
        sArray[109] = 168;
        sArray[110] = 152;
        sArray[111] = 136;
        sArray[112] = 120;
        sArray[113] = 112;
        sArray[114] = 104;
        sArray[115] = 96;
        sArray[116] = 88;
        sArray[117] = 80;
        sArray[118] = 72;
        sArray[119] = 64;
        sArray[120] = 56;
        sArray[121] = 48;
        sArray[122] = 40;
        sArray[123] = 32;
        sArray[124] = 24;
        sArray[125] = 16;
        sArray[126] = 8;
        sArray[128] = -32760;
        sArray[129] = -31608;
        sArray[130] = -30584;
        sArray[131] = -29560;
        sArray[132] = -28536;
        sArray[133] = -27512;
        sArray[134] = -26488;
        sArray[135] = -25464;
        sArray[136] = -24440;
        sArray[137] = -23416;
        sArray[138] = -22392;
        sArray[139] = -21368;
        sArray[140] = -20344;
        sArray[141] = -19320;
        sArray[142] = -18296;
        sArray[143] = -17272;
        sArray[144] = -16248;
        sArray[145] = -15736;
        sArray[146] = -15224;
        sArray[147] = -14712;
        sArray[148] = -14200;
        sArray[149] = -13688;
        sArray[150] = -13176;
        sArray[151] = -12664;
        sArray[152] = -12152;
        sArray[153] = -11640;
        sArray[154] = -11128;
        sArray[155] = -10616;
        sArray[156] = -10104;
        sArray[157] = -9592;
        sArray[158] = -9080;
        sArray[159] = -8568;
        sArray[160] = -8056;
        sArray[161] = -7800;
        sArray[162] = -7544;
        sArray[163] = -7288;
        sArray[164] = -7032;
        sArray[165] = -6776;
        sArray[166] = -6520;
        sArray[167] = -6264;
        sArray[168] = -6008;
        sArray[169] = -5752;
        sArray[170] = -5496;
        sArray[171] = -5240;
        sArray[172] = -4984;
        sArray[173] = -4728;
        sArray[174] = -4472;
        sArray[175] = -4216;
        sArray[176] = -3960;
        sArray[177] = -3832;
        sArray[178] = -3704;
        sArray[179] = -3576;
        sArray[180] = -3448;
        sArray[181] = -3320;
        sArray[182] = -3192;
        sArray[183] = -3064;
        sArray[184] = -2936;
        sArray[185] = -2808;
        sArray[186] = -2680;
        sArray[187] = -2552;
        sArray[188] = -2424;
        sArray[189] = -2296;
        sArray[190] = -2168;
        sArray[191] = -2040;
        sArray[192] = -1912;
        sArray[193] = -1848;
        sArray[194] = -1784;
        sArray[195] = -1720;
        sArray[196] = -1656;
        sArray[197] = -1592;
        sArray[198] = -1528;
        sArray[199] = -1464;
        sArray[200] = -1400;
        sArray[201] = -1336;
        sArray[202] = -1272;
        sArray[203] = -1208;
        sArray[204] = -1144;
        sArray[205] = -1080;
        sArray[206] = -1016;
        sArray[207] = -952;
        sArray[208] = -888;
        sArray[209] = -856;
        sArray[210] = -824;
        sArray[211] = -792;
        sArray[212] = -760;
        sArray[213] = -728;
        sArray[214] = -696;
        sArray[215] = -664;
        sArray[216] = -632;
        sArray[217] = -600;
        sArray[218] = -568;
        sArray[219] = -536;
        sArray[220] = -504;
        sArray[221] = -472;
        sArray[222] = -440;
        sArray[223] = -408;
        sArray[224] = -376;
        sArray[225] = -360;
        sArray[226] = -344;
        sArray[227] = -328;
        sArray[228] = -312;
        sArray[229] = -296;
        sArray[230] = -280;
        sArray[231] = -264;
        sArray[232] = -248;
        sArray[233] = -232;
        sArray[234] = -216;
        sArray[235] = -200;
        sArray[236] = -184;
        sArray[237] = -168;
        sArray[238] = -152;
        sArray[239] = -136;
        sArray[240] = -120;
        sArray[241] = -112;
        sArray[242] = -104;
        sArray[243] = -96;
        sArray[244] = -88;
        sArray[245] = -80;
        sArray[246] = -72;
        sArray[247] = -64;
        sArray[248] = -56;
        sArray[249] = -48;
        sArray[250] = -40;
        sArray[251] = -32;
        sArray[252] = -24;
        sArray[253] = -16;
        sArray[254] = -8;
        ulawTable = sArray;
    }

    private Utils() {
    }

    public static short toShort(byte[] bytes, boolean bigEndian) {
        if (bytes.length == 1) {
            return bytes[0];
        }
        if (bigEndian) {
            return (short)(bytes[0] << 8 | 0xFF & bytes[1]);
        }
        return (short)(bytes[1] << 8 | 0xFF & bytes[0]);
    }

    public static int toUnsignedShort(byte[] bytes, boolean bigEndian) {
        if (bytes.length == 1) {
            return 0xFF & bytes[0];
        }
        if (bigEndian) {
            return (bytes[0] & 0xFF) << 8 | 0xFF & bytes[1];
        }
        return (bytes[1] & 0xFF) << 8 | 0xFF & bytes[0];
    }

    public static void toBytes(short sVal, byte[] bytes, boolean bigEndian) {
        if (bigEndian) {
            bytes[0] = (byte)(sVal >> 8);
            bytes[1] = (byte)(sVal & 0xFF);
        } else {
            bytes[0] = (byte)(sVal & 0xFF);
            bytes[1] = (byte)(sVal >> 8);
        }
    }

    public static short bytesToShort(AudioFormat format, byte[] byteArray) {
        short result = 0;
        AudioFormat.Encoding encoding = format.getEncoding();
        int frameSize = format.getFrameSize();
        if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            result = Utils.toShort(byteArray, format.isBigEndian());
            if (frameSize == 1) {
                result = (short)(result << 8);
            }
        } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            int tmp = Utils.toUnsignedShort(byteArray, format.isBigEndian());
            if (frameSize == 1) {
                tmp <<= 8;
            }
            result = (short)(tmp - 32768);
        } else if (encoding == AudioFormat.Encoding.ULAW) {
            result = ulawTable[byteArray[0] + 128];
        } else {
            System.out.println("Unknown encoding: " + encoding);
        }
        return result;
    }

    public static short[] toSignedPCM(AudioInputStream ais) throws IOException {
        AudioFormat aisFormat = ais.getFormat();
        short[] shorts = new short[ais.available() / aisFormat.getFrameSize()];
        byte[] frame = new byte[aisFormat.getFrameSize()];
        int pos = 0;
        while (ais.read(frame) != -1) {
            shorts[pos++] = Utils.bytesToShort(aisFormat, frame);
        }
        return shorts;
    }

    public static AudioData readAudioFile(String filename) throws IOException {
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(filename));
            AudioInputStream ais = AudioSystem.getAudioInputStream(stream);
            AudioData audioData = new AudioData(ais);
            stream.close();
            return audioData;
        }
        catch (UnsupportedAudioFileException e) {
            return null;
        }
    }

    public static AudioData readRawFile(String filename) throws IOException {
        FileInputStream stream = new FileInputStream(filename);
        AudioFormat format = new AudioFormat(8000.0f, 16, 1, true, false);
        short[] audioData = RawReader.readAudioData(stream, format);
        stream.close();
        return new AudioData(audioData, 8000.0f);
    }

    public static void writeRawFile(AudioData audio, String filename) throws IOException {
        short[] samples;
        FileOutputStream outputStream = new FileOutputStream(filename);
        AudioFormat format = new AudioFormat(8000.0f, 16, 1, true, false);
        RawWriter writer = new RawWriter(outputStream, format);
        short[] sArray = samples = audio.getAudioData();
        int n = samples.length;
        int n2 = 0;
        while (n2 < n) {
            short sample = sArray[n2];
            writer.writeSample(sample);
            ++n2;
        }
        outputStream.flush();
        outputStream.close();
    }
}

