/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;

public class RawReader {
    public static short[] readAudioData(InputStream audioStream, AudioFormat audioFormat) throws IOException {
        int i;
        boolean signedData = true;
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        int bytesPerSample = audioFormat.getSampleSizeInBits() / 8;
        if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            signedData = true;
        } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            signedData = false;
        } else {
            System.err.println("Unsupported audio encoding: " + encoding);
            System.exit(-1);
        }
        boolean bigEndian = audioFormat.isBigEndian();
        byte[] buffer = new byte[bytesPerSample];
        ArrayList<Short> samples = new ArrayList<Short>();
        int read = 0;
        int totalRead = 0;
        boolean done = false;
        while (!done) {
            int temp;
            totalRead = read = audioStream.read(buffer, 0, bytesPerSample);
            while (totalRead < bytesPerSample) {
                if (read == -1) {
                    done = true;
                    break;
                }
                read = audioStream.read(buffer, totalRead, bytesPerSample - totalRead);
                totalRead += read;
            }
            if (done) continue;
            int val = 0;
            if (bigEndian) {
                val = buffer[0];
                if (!signedData) {
                    val &= 0xFF;
                }
                i = 1;
                while (i < bytesPerSample) {
                    temp = buffer[i] & 0xFF;
                    val = (val << 8) + temp;
                    ++i;
                }
            } else {
                val = buffer[bytesPerSample - 1];
                if (!signedData) {
                    val &= 0xFF;
                }
                i = bytesPerSample - 2;
                while (i >= 0) {
                    temp = buffer[i] & 0xFF;
                    val = (val << 8) + temp;
                    --i;
                }
            }
            if (!signedData) {
                val -= 1 << bytesPerSample * 8 - 1;
            }
            samples.add((short)val);
        }
        short[] audioData = new short[samples.size()];
        i = 0;
        while (i < audioData.length) {
            audioData[i] = (Short)samples.get(i);
            ++i;
        }
        return audioData;
    }
}

